/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiClient;
import software.amazon.awssdk.services.pi.internal.UserAgentUtils;
import software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest;
import software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse;

public class ListPerformanceAnalysisReportsIterable
implements SdkIterable<ListPerformanceAnalysisReportsResponse> {
    private final PiClient client;
    private final ListPerformanceAnalysisReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPerformanceAnalysisReportsIterable(PiClient client, ListPerformanceAnalysisReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPerformanceAnalysisReportsResponseFetcher();
    }

    public Iterator<ListPerformanceAnalysisReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPerformanceAnalysisReportsResponseFetcher
    implements SyncPageFetcher<ListPerformanceAnalysisReportsResponse> {
        private ListPerformanceAnalysisReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListPerformanceAnalysisReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPerformanceAnalysisReportsResponse nextPage(ListPerformanceAnalysisReportsResponse previousPage) {
            if (previousPage == null) {
                return ListPerformanceAnalysisReportsIterable.this.client.listPerformanceAnalysisReports(ListPerformanceAnalysisReportsIterable.this.firstRequest);
            }
            return ListPerformanceAnalysisReportsIterable.this.client.listPerformanceAnalysisReports((ListPerformanceAnalysisReportsRequest)((Object)ListPerformanceAnalysisReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

