/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceMetricsResponse extends PiResponse implements
        ToCopyableBuilder<GetResourceMetricsResponse.Builder, GetResourceMetricsResponse> {
    private static final SdkField<Instant> ALIGNED_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetResourceMetricsResponse::alignedStartTime)).setter(setter(Builder::alignedStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlignedStartTime").build()).build();

    private static final SdkField<Instant> ALIGNED_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetResourceMetricsResponse::alignedEndTime)).setter(setter(Builder::alignedEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlignedEndTime").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceMetricsResponse::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<List<MetricKeyDataPoints>> METRIC_LIST_FIELD = SdkField
            .<List<MetricKeyDataPoints>> builder(MarshallingType.LIST)
            .getter(getter(GetResourceMetricsResponse::metricList))
            .setter(setter(Builder::metricList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricKeyDataPoints> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricKeyDataPoints::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceMetricsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNED_START_TIME_FIELD,
            ALIGNED_END_TIME_FIELD, IDENTIFIER_FIELD, METRIC_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final Instant alignedStartTime;

    private final Instant alignedEndTime;

    private final String identifier;

    private final List<MetricKeyDataPoints> metricList;

    private final String nextToken;

    private GetResourceMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.alignedStartTime = builder.alignedStartTime;
        this.alignedEndTime = builder.alignedEndTime;
        this.identifier = builder.identifier;
        this.metricList = builder.metricList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start time for the returned metrics, after alignment to a granular boundary (as specified by
     * <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value of the
     * user-specified <code>StartTime</code>.
     * </p>
     * 
     * @return The start time for the returned metrics, after alignment to a granular boundary (as specified by
     *         <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value of
     *         the user-specified <code>StartTime</code>.
     */
    public Instant alignedStartTime() {
        return alignedStartTime;
    }

    /**
     * <p>
     * The end time for the returned metrics, after alignment to a granular boundary (as specified by
     * <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value of the
     * user-specified <code>Endtime</code>.
     * </p>
     * 
     * @return The end time for the returned metrics, after alignment to a granular boundary (as specified by
     *         <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value of
     *         the user-specified <code>Endtime</code>.
     */
    public Instant alignedEndTime() {
        return alignedEndTime;
    }

    /**
     * <p>
     * An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data
     * source.
     * </p>
     * <p>
     * To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value - for example:
     * <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
     * </p>
     * 
     * @return An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
     *         this data source.</p>
     *         <p>
     *         To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value - for
     *         example: <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
     */
    public String identifier() {
        return identifier;
    }

    /**
     * Returns true if the MetricList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMetricList() {
        return metricList != null && !(metricList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of metric results,, where each array element contains all of the data points for a particular dimension.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of metric results,, where each array element contains all of the data points for a particular
     *         dimension.
     */
    public List<MetricKeyDataPoints> metricList() {
        return metricList;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alignedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(alignedEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(metricList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceMetricsResponse)) {
            return false;
        }
        GetResourceMetricsResponse other = (GetResourceMetricsResponse) obj;
        return Objects.equals(alignedStartTime(), other.alignedStartTime())
                && Objects.equals(alignedEndTime(), other.alignedEndTime()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(metricList(), other.metricList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetResourceMetricsResponse").add("AlignedStartTime", alignedStartTime())
                .add("AlignedEndTime", alignedEndTime()).add("Identifier", identifier()).add("MetricList", metricList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlignedStartTime":
            return Optional.ofNullable(clazz.cast(alignedStartTime()));
        case "AlignedEndTime":
            return Optional.ofNullable(clazz.cast(alignedEndTime()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "MetricList":
            return Optional.ofNullable(clazz.cast(metricList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceMetricsResponse, T> g) {
        return obj -> g.apply((GetResourceMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceMetricsResponse> {
        /**
         * <p>
         * The start time for the returned metrics, after alignment to a granular boundary (as specified by
         * <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value of the
         * user-specified <code>StartTime</code>.
         * </p>
         * 
         * @param alignedStartTime
         *        The start time for the returned metrics, after alignment to a granular boundary (as specified by
         *        <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value
         *        of the user-specified <code>StartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alignedStartTime(Instant alignedStartTime);

        /**
         * <p>
         * The end time for the returned metrics, after alignment to a granular boundary (as specified by
         * <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value of the
         * user-specified <code>Endtime</code>.
         * </p>
         * 
         * @param alignedEndTime
         *        The end time for the returned metrics, after alignment to a granular boundary (as specified by
         *        <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value
         *        of the user-specified <code>Endtime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alignedEndTime(Instant alignedEndTime);

        /**
         * <p>
         * An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this
         * data source.
         * </p>
         * <p>
         * To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value - for
         * example: <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
         * </p>
         * 
         * @param identifier
         *        An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics
         *        from this data source.</p>
         *        <p>
         *        To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value - for
         *        example: <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * An array of metric results,, where each array element contains all of the data points for a particular
         * dimension.
         * </p>
         * 
         * @param metricList
         *        An array of metric results,, where each array element contains all of the data points for a particular
         *        dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(Collection<MetricKeyDataPoints> metricList);

        /**
         * <p>
         * An array of metric results,, where each array element contains all of the data points for a particular
         * dimension.
         * </p>
         * 
         * @param metricList
         *        An array of metric results,, where each array element contains all of the data points for a particular
         *        dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(MetricKeyDataPoints... metricList);

        /**
         * <p>
         * An array of metric results,, where each array element contains all of the data points for a particular
         * dimension.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricKeyDataPoints>.Builder} avoiding the
         * need to create one manually via {@link List<MetricKeyDataPoints>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricKeyDataPoints>.Builder#build()} is called immediately
         * and its result is passed to {@link #metricList(List<MetricKeyDataPoints>)}.
         * 
         * @param metricList
         *        a consumer that will call methods on {@link List<MetricKeyDataPoints>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricList(List<MetricKeyDataPoints>)
         */
        Builder metricList(Consumer<MetricKeyDataPoints.Builder>... metricList);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PiResponse.BuilderImpl implements Builder {
        private Instant alignedStartTime;

        private Instant alignedEndTime;

        private String identifier;

        private List<MetricKeyDataPoints> metricList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceMetricsResponse model) {
            super(model);
            alignedStartTime(model.alignedStartTime);
            alignedEndTime(model.alignedEndTime);
            identifier(model.identifier);
            metricList(model.metricList);
            nextToken(model.nextToken);
        }

        public final Instant getAlignedStartTime() {
            return alignedStartTime;
        }

        @Override
        public final Builder alignedStartTime(Instant alignedStartTime) {
            this.alignedStartTime = alignedStartTime;
            return this;
        }

        public final void setAlignedStartTime(Instant alignedStartTime) {
            this.alignedStartTime = alignedStartTime;
        }

        public final Instant getAlignedEndTime() {
            return alignedEndTime;
        }

        @Override
        public final Builder alignedEndTime(Instant alignedEndTime) {
            this.alignedEndTime = alignedEndTime;
            return this;
        }

        public final void setAlignedEndTime(Instant alignedEndTime) {
            this.alignedEndTime = alignedEndTime;
        }

        public final String getIdentifier() {
            return identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final Collection<MetricKeyDataPoints.Builder> getMetricList() {
            return metricList != null ? metricList.stream().map(MetricKeyDataPoints::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder metricList(Collection<MetricKeyDataPoints> metricList) {
            this.metricList = MetricKeyDataPointsListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(MetricKeyDataPoints... metricList) {
            metricList(Arrays.asList(metricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Consumer<MetricKeyDataPoints.Builder>... metricList) {
            metricList(Stream.of(metricList).map(c -> MetricKeyDataPoints.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricList(Collection<MetricKeyDataPoints.BuilderImpl> metricList) {
            this.metricList = MetricKeyDataPointsListCopier.copyFromBuilder(metricList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourceMetricsResponse build() {
            return new GetResourceMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
