/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalizeruntime.model.ActionListCopier;
import software.amazon.awssdk.services.personalizeruntime.model.PersonalizeRuntimeResponse;
import software.amazon.awssdk.services.personalizeruntime.model.PredictedAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetActionRecommendationsResponse
extends PersonalizeRuntimeResponse
implements ToCopyableBuilder<Builder, GetActionRecommendationsResponse> {
    private static final SdkField<List<PredictedAction>> ACTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionList").getter(GetActionRecommendationsResponse.getter(GetActionRecommendationsResponse::actionList)).setter(GetActionRecommendationsResponse.setter(Builder::actionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictedAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(GetActionRecommendationsResponse.getter(GetActionRecommendationsResponse::recommendationId)).setter(GetActionRecommendationsResponse.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_LIST_FIELD, RECOMMENDATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetActionRecommendationsResponse.memberNameToFieldInitializer();
    private final List<PredictedAction> actionList;
    private final String recommendationId;

    private GetActionRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.actionList = builder.actionList;
        this.recommendationId = builder.recommendationId;
    }

    public final boolean hasActionList() {
        return this.actionList != null && !(this.actionList instanceof SdkAutoConstructList);
    }

    public final List<PredictedAction> actionList() {
        return this.actionList;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionList() ? this.actionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActionRecommendationsResponse)) {
            return false;
        }
        GetActionRecommendationsResponse other = (GetActionRecommendationsResponse)((Object)obj);
        return this.hasActionList() == other.hasActionList() && Objects.equals(this.actionList(), other.actionList()) && Objects.equals(this.recommendationId(), other.recommendationId());
    }

    public final String toString() {
        return ToString.builder((String)"GetActionRecommendationsResponse").add("ActionList", this.hasActionList() ? this.actionList() : null).add("RecommendationId", (Object)this.recommendationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionList": {
                return Optional.ofNullable(clazz.cast(this.actionList()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionList", ACTION_LIST_FIELD);
        map.put("recommendationId", RECOMMENDATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetActionRecommendationsResponse, T> g) {
        return obj -> g.apply((GetActionRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRuntimeResponse.BuilderImpl
    implements Builder {
        private List<PredictedAction> actionList = DefaultSdkAutoConstructList.getInstance();
        private String recommendationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActionRecommendationsResponse model) {
            super(model);
            this.actionList(model.actionList);
            this.recommendationId(model.recommendationId);
        }

        public final List<PredictedAction.Builder> getActionList() {
            List<PredictedAction.Builder> result = ActionListCopier.copyToBuilder(this.actionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionList(Collection<PredictedAction.BuilderImpl> actionList) {
            this.actionList = ActionListCopier.copyFromBuilder(actionList);
        }

        @Override
        public final Builder actionList(Collection<PredictedAction> actionList) {
            this.actionList = ActionListCopier.copy(actionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionList(PredictedAction ... actionList) {
            this.actionList(Arrays.asList(actionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionList(Consumer<PredictedAction.Builder> ... actionList) {
            this.actionList(Stream.of(actionList).map(c -> (PredictedAction)((PredictedAction.Builder)PredictedAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        @Override
        public GetActionRecommendationsResponse build() {
            return new GetActionRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetActionRecommendationsResponse> {
        public Builder actionList(Collection<PredictedAction> var1);

        public Builder actionList(PredictedAction ... var1);

        public Builder actionList(Consumer<PredictedAction.Builder> ... var1);

        public Builder recommendationId(String var1);
    }
}

