/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.personalizeruntime.DefaultPersonalizeRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.personalizeruntime.DefaultPersonalizeRuntimeClient;
import software.amazon.awssdk.services.personalizeruntime.PersonalizeRuntimeClient;
import software.amazon.awssdk.services.personalizeruntime.PersonalizeRuntimeClientBuilder;
import software.amazon.awssdk.services.personalizeruntime.PersonalizeRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.personalizeruntime.endpoints.PersonalizeRuntimeEndpointProvider;

@SdkInternalApi
final class DefaultPersonalizeRuntimeClientBuilder
extends DefaultPersonalizeRuntimeBaseClientBuilder<PersonalizeRuntimeClientBuilder, PersonalizeRuntimeClient>
implements PersonalizeRuntimeClientBuilder {
    DefaultPersonalizeRuntimeClientBuilder() {
    }

    @Override
    public DefaultPersonalizeRuntimeClientBuilder endpointProvider(PersonalizeRuntimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PersonalizeRuntimeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPersonalizeRuntimeClientBuilder.validateClientOptions(clientConfiguration);
        PersonalizeRuntimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPersonalizeRuntimeClient client = new DefaultPersonalizeRuntimeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PersonalizeRuntimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PersonalizeRuntimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

