/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest;
import software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingResponse;
import software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsResponse;
import software.amazon.awssdk.services.personalizeruntime.model.InvalidInputException;
import software.amazon.awssdk.services.personalizeruntime.model.PersonalizeRuntimeException;
import software.amazon.awssdk.services.personalizeruntime.model.ResourceNotFoundException;

/**
 * Service client for accessing Amazon Personalize Runtime. This can be created using the static {@link #builder()}
 * method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public interface PersonalizeRuntimeClient extends SdkClient {
    String SERVICE_NAME = "personalize";

    /**
     * Create a {@link PersonalizeRuntimeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PersonalizeRuntimeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PersonalizeRuntimeClient}.
     */
    static PersonalizeRuntimeClientBuilder builder() {
        return new DefaultPersonalizeRuntimeClientBuilder();
    }

    /**
     * <p>
     * Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely
     * item to be of interest to the user.
     * </p>
     * <note>
     * <p>
     * The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.
     * </p>
     * </note>
     *
     * @param getPersonalizedRankingRequest
     * @return Result of the GetPersonalizedRanking operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeRuntimeClient.GetPersonalizedRanking
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPersonalizedRankingResponse getPersonalizedRanking(GetPersonalizedRankingRequest getPersonalizedRankingRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely
     * item to be of interest to the user.
     * </p>
     * <note>
     * <p>
     * The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPersonalizedRankingRequest.Builder} avoiding the
     * need to create one manually via {@link GetPersonalizedRankingRequest#builder()}
     * </p>
     *
     * @param getPersonalizedRankingRequest
     *        A {@link Consumer} that will call methods on {@link GetPersonalizedRankingRequest.Builder} to create a
     *        request.
     * @return Result of the GetPersonalizedRanking operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeRuntimeClient.GetPersonalizedRanking
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPersonalizedRankingResponse getPersonalizedRanking(
            Consumer<GetPersonalizedRankingRequest.Builder> getPersonalizedRankingRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeRuntimeException {
        return getPersonalizedRanking(GetPersonalizedRankingRequest.builder().applyMutation(getPersonalizedRankingRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of recommended items. The required input depends on the recipe type used to create the solution
     * backing the campaign, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RELATED_ITEMS - <code>itemId</code> required, <code>userId</code> not used
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PERSONALIZATION - <code>itemId</code> optional, <code>userId</code> required
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.
     * </p>
     * </note>
     *
     * @param getRecommendationsRequest
     * @return Result of the GetRecommendations operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeRuntimeClient.GetRecommendations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationsResponse getRecommendations(GetRecommendationsRequest getRecommendationsRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeRuntimeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommended items. The required input depends on the recipe type used to create the solution
     * backing the campaign, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RELATED_ITEMS - <code>itemId</code> required, <code>userId</code> not used
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PERSONALIZATION - <code>itemId</code> optional, <code>userId</code> required
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRecommendationsRequest#builder()}
     * </p>
     *
     * @param getRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommendationsRequest.Builder} to create a
     *        request.
     * @return Result of the GetRecommendations operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeRuntimeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeRuntimeClient.GetRecommendations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationsResponse getRecommendations(Consumer<GetRecommendationsRequest.Builder> getRecommendationsRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeRuntimeException {
        return getRecommendations(GetRecommendationsRequest.builder().applyMutation(getRecommendationsRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("personalize-runtime");
    }
}
