/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalizeruntime.model.ContextCopier;
import software.amazon.awssdk.services.personalizeruntime.model.InputListCopier;
import software.amazon.awssdk.services.personalizeruntime.model.PersonalizeRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPersonalizedRankingRequest
extends PersonalizeRuntimeRequest
implements ToCopyableBuilder<Builder, GetPersonalizedRankingRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPersonalizedRankingRequest.getter(GetPersonalizedRankingRequest::campaignArn)).setter(GetPersonalizedRankingRequest.setter(Builder::campaignArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()}).build();
    private static final SdkField<List<String>> INPUT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetPersonalizedRankingRequest.getter(GetPersonalizedRankingRequest::inputList)).setter(GetPersonalizedRankingRequest.setter(Builder::inputList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetPersonalizedRankingRequest.getter(GetPersonalizedRankingRequest::userId)).setter(GetPersonalizedRankingRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetPersonalizedRankingRequest.getter(GetPersonalizedRankingRequest::context)).setter(GetPersonalizedRankingRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD, INPUT_LIST_FIELD, USER_ID_FIELD, CONTEXT_FIELD));
    private final String campaignArn;
    private final List<String> inputList;
    private final String userId;
    private final Map<String, String> context;

    private GetPersonalizedRankingRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
        this.inputList = builder.inputList;
        this.userId = builder.userId;
        this.context = builder.context;
    }

    public String campaignArn() {
        return this.campaignArn;
    }

    public boolean hasInputList() {
        return this.inputList != null && !(this.inputList instanceof SdkAutoConstructList);
    }

    public List<String> inputList() {
        return this.inputList;
    }

    public String userId() {
        return this.userId;
    }

    public boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public Map<String, String> context() {
        return this.context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputList());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersonalizedRankingRequest)) {
            return false;
        }
        GetPersonalizedRankingRequest other = (GetPersonalizedRankingRequest)((Object)obj);
        return Objects.equals(this.campaignArn(), other.campaignArn()) && Objects.equals(this.inputList(), other.inputList()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.context(), other.context());
    }

    public String toString() {
        return ToString.builder((String)"GetPersonalizedRankingRequest").add("CampaignArn", (Object)this.campaignArn()).add("InputList", this.inputList()).add("UserId", (Object)this.userId()).add("Context", (Object)(this.context() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignArn": {
                return Optional.ofNullable(clazz.cast(this.campaignArn()));
            }
            case "inputList": {
                return Optional.ofNullable(clazz.cast(this.inputList()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPersonalizedRankingRequest, T> g) {
        return obj -> g.apply((GetPersonalizedRankingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRuntimeRequest.BuilderImpl
    implements Builder {
        private String campaignArn;
        private List<String> inputList = DefaultSdkAutoConstructList.getInstance();
        private String userId;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersonalizedRankingRequest model) {
            super(model);
            this.campaignArn(model.campaignArn);
            this.inputList(model.inputList);
            this.userId(model.userId);
            this.context(model.context);
        }

        public final String getCampaignArn() {
            return this.campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        public final Collection<String> getInputList() {
            return this.inputList;
        }

        @Override
        public final Builder inputList(Collection<String> inputList) {
            this.inputList = InputListCopier.copy(inputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputList(String ... inputList) {
            this.inputList(Arrays.asList(inputList));
            return this;
        }

        public final void setInputList(Collection<String> inputList) {
            this.inputList = InputListCopier.copy(inputList);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Map<String, String> getContext() {
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPersonalizedRankingRequest build() {
            return new GetPersonalizedRankingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPersonalizedRankingRequest> {
        public Builder campaignArn(String var1);

        public Builder inputList(Collection<String> var1);

        public Builder inputList(String ... var1);

        public Builder userId(String var1);

        public Builder context(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

