/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutActionInteractionsRequest extends PersonalizeEventsRequest implements
        ToCopyableBuilder<PutActionInteractionsRequest.Builder, PutActionInteractionsRequest> {
    private static final SdkField<String> TRACKING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingId").getter(getter(PutActionInteractionsRequest::trackingId))
            .setter(setter(Builder::trackingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingId").build()).build();

    private static final SdkField<List<ActionInteraction>> ACTION_INTERACTIONS_FIELD = SdkField
            .<List<ActionInteraction>> builder(MarshallingType.LIST)
            .memberName("actionInteractions")
            .getter(getter(PutActionInteractionsRequest::actionInteractions))
            .setter(setter(Builder::actionInteractions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionInteractions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionInteraction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionInteraction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_ID_FIELD,
            ACTION_INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackingId;

    private final List<ActionInteraction> actionInteractions;

    private PutActionInteractionsRequest(BuilderImpl builder) {
        super(builder);
        this.trackingId = builder.trackingId;
        this.actionInteractions = builder.actionInteractions;
    }

    /**
     * <p>
     * The ID of your action interaction event tracker. When you create an Action interactions dataset, Amazon
     * Personalize creates an action interaction event tracker for you. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-tracker-id.html">Action interaction
     * event tracker ID</a>.
     * </p>
     * 
     * @return The ID of your action interaction event tracker. When you create an Action interactions dataset, Amazon
     *         Personalize creates an action interaction event tracker for you. For more information, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-tracker-id.html">Action
     *         interaction event tracker ID</a>.
     */
    public final String trackingId() {
        return trackingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionInteractions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionInteractions() {
        return actionInteractions != null && !(actionInteractions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of action interaction events from the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionInteractions} method.
     * </p>
     * 
     * @return A list of action interaction events from the session.
     */
    public final List<ActionInteraction> actionInteractions() {
        return actionInteractions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackingId());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionInteractions() ? actionInteractions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutActionInteractionsRequest)) {
            return false;
        }
        PutActionInteractionsRequest other = (PutActionInteractionsRequest) obj;
        return Objects.equals(trackingId(), other.trackingId()) && hasActionInteractions() == other.hasActionInteractions()
                && Objects.equals(actionInteractions(), other.actionInteractions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutActionInteractionsRequest").add("TrackingId", trackingId())
                .add("ActionInteractions", hasActionInteractions() ? actionInteractions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trackingId":
            return Optional.ofNullable(clazz.cast(trackingId()));
        case "actionInteractions":
            return Optional.ofNullable(clazz.cast(actionInteractions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trackingId", TRACKING_ID_FIELD);
        map.put("actionInteractions", ACTION_INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutActionInteractionsRequest, T> g) {
        return obj -> g.apply((PutActionInteractionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PersonalizeEventsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutActionInteractionsRequest> {
        /**
         * <p>
         * The ID of your action interaction event tracker. When you create an Action interactions dataset, Amazon
         * Personalize creates an action interaction event tracker for you. For more information, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-tracker-id.html">Action
         * interaction event tracker ID</a>.
         * </p>
         * 
         * @param trackingId
         *        The ID of your action interaction event tracker. When you create an Action interactions dataset,
         *        Amazon Personalize creates an action interaction event tracker for you. For more information, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-tracker-id.html">Action
         *        interaction event tracker ID</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingId(String trackingId);

        /**
         * <p>
         * A list of action interaction events from the session.
         * </p>
         * 
         * @param actionInteractions
         *        A list of action interaction events from the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionInteractions(Collection<ActionInteraction> actionInteractions);

        /**
         * <p>
         * A list of action interaction events from the session.
         * </p>
         * 
         * @param actionInteractions
         *        A list of action interaction events from the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionInteractions(ActionInteraction... actionInteractions);

        /**
         * <p>
         * A list of action interaction events from the session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalizeevents.model.ActionInteraction.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.personalizeevents.model.ActionInteraction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalizeevents.model.ActionInteraction.Builder#build()} is called
         * immediately and its result is passed to {@link #actionInteractions(List<ActionInteraction>)}.
         * 
         * @param actionInteractions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalizeevents.model.ActionInteraction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionInteractions(java.util.Collection<ActionInteraction>)
         */
        Builder actionInteractions(Consumer<ActionInteraction.Builder>... actionInteractions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeEventsRequest.BuilderImpl implements Builder {
        private String trackingId;

        private List<ActionInteraction> actionInteractions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutActionInteractionsRequest model) {
            super(model);
            trackingId(model.trackingId);
            actionInteractions(model.actionInteractions);
        }

        public final String getTrackingId() {
            return trackingId;
        }

        public final void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Override
        public final Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public final List<ActionInteraction.Builder> getActionInteractions() {
            List<ActionInteraction.Builder> result = ActionInteractionsListCopier.copyToBuilder(this.actionInteractions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionInteractions(Collection<ActionInteraction.BuilderImpl> actionInteractions) {
            this.actionInteractions = ActionInteractionsListCopier.copyFromBuilder(actionInteractions);
        }

        @Override
        public final Builder actionInteractions(Collection<ActionInteraction> actionInteractions) {
            this.actionInteractions = ActionInteractionsListCopier.copy(actionInteractions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionInteractions(ActionInteraction... actionInteractions) {
            actionInteractions(Arrays.asList(actionInteractions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionInteractions(Consumer<ActionInteraction.Builder>... actionInteractions) {
            actionInteractions(Stream.of(actionInteractions).map(c -> ActionInteraction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutActionInteractionsRequest build() {
            return new PutActionInteractionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
