/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.personalizeevents.DefaultPersonalizeEventsBaseClientBuilder;
import software.amazon.awssdk.services.personalizeevents.DefaultPersonalizeEventsClient;
import software.amazon.awssdk.services.personalizeevents.PersonalizeEventsClient;
import software.amazon.awssdk.services.personalizeevents.PersonalizeEventsClientBuilder;
import software.amazon.awssdk.services.personalizeevents.PersonalizeEventsServiceClientConfiguration;
import software.amazon.awssdk.services.personalizeevents.endpoints.PersonalizeEventsEndpointProvider;

@SdkInternalApi
final class DefaultPersonalizeEventsClientBuilder
extends DefaultPersonalizeEventsBaseClientBuilder<PersonalizeEventsClientBuilder, PersonalizeEventsClient>
implements PersonalizeEventsClientBuilder {
    DefaultPersonalizeEventsClientBuilder() {
    }

    @Override
    public DefaultPersonalizeEventsClientBuilder endpointProvider(PersonalizeEventsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PersonalizeEventsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPersonalizeEventsClientBuilder.validateClientOptions(clientConfiguration);
        PersonalizeEventsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPersonalizeEventsClient client = new DefaultPersonalizeEventsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PersonalizeEventsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PersonalizeEventsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

