/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalizeevents.model.Event;
import software.amazon.awssdk.services.personalizeevents.model.EventListCopier;
import software.amazon.awssdk.services.personalizeevents.model.PersonalizeEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsRequest
extends PersonalizeEventsRequest
implements ToCopyableBuilder<Builder, PutEventsRequest> {
    private static final SdkField<String> TRACKING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackingId").getter(PutEventsRequest.getter(PutEventsRequest::trackingId)).setter(PutEventsRequest.setter(Builder::trackingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(PutEventsRequest.getter(PutEventsRequest::userId)).setter(PutEventsRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(PutEventsRequest.getter(PutEventsRequest::sessionId)).setter(PutEventsRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<List<Event>> EVENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventList").getter(PutEventsRequest.getter(PutEventsRequest::eventList)).setter(PutEventsRequest.setter(Builder::eventList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Event::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_ID_FIELD, USER_ID_FIELD, SESSION_ID_FIELD, EVENT_LIST_FIELD));
    private final String trackingId;
    private final String userId;
    private final String sessionId;
    private final List<Event> eventList;

    private PutEventsRequest(BuilderImpl builder) {
        super(builder);
        this.trackingId = builder.trackingId;
        this.userId = builder.userId;
        this.sessionId = builder.sessionId;
        this.eventList = builder.eventList;
    }

    public final String trackingId() {
        return this.trackingId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final boolean hasEventList() {
        return this.eventList != null && !(this.eventList instanceof SdkAutoConstructList);
    }

    public final List<Event> eventList() {
        return this.eventList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventList() ? this.eventList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsRequest)) {
            return false;
        }
        PutEventsRequest other = (PutEventsRequest)((Object)obj);
        return Objects.equals(this.trackingId(), other.trackingId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.sessionId(), other.sessionId()) && this.hasEventList() == other.hasEventList() && Objects.equals(this.eventList(), other.eventList());
    }

    public final String toString() {
        return ToString.builder((String)"PutEventsRequest").add("TrackingId", (Object)this.trackingId()).add("UserId", (Object)this.userId()).add("SessionId", (Object)this.sessionId()).add("EventList", this.hasEventList() ? this.eventList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trackingId": {
                return Optional.ofNullable(clazz.cast(this.trackingId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "eventList": {
                return Optional.ofNullable(clazz.cast(this.eventList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventsRequest, T> g) {
        return obj -> g.apply((PutEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeEventsRequest.BuilderImpl
    implements Builder {
        private String trackingId;
        private String userId;
        private String sessionId;
        private List<Event> eventList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsRequest model) {
            super(model);
            this.trackingId(model.trackingId);
            this.userId(model.userId);
            this.sessionId(model.sessionId);
            this.eventList(model.eventList);
        }

        public final String getTrackingId() {
            return this.trackingId;
        }

        public final void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Override
        public final Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final List<Event.Builder> getEventList() {
            List<Event.Builder> result = EventListCopier.copyToBuilder(this.eventList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventList(Collection<Event.BuilderImpl> eventList) {
            this.eventList = EventListCopier.copyFromBuilder(eventList);
        }

        @Override
        public final Builder eventList(Collection<Event> eventList) {
            this.eventList = EventListCopier.copy(eventList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventList(Event ... eventList) {
            this.eventList(Arrays.asList(eventList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventList(Consumer<Event.Builder> ... eventList) {
            this.eventList(Stream.of(eventList).map(c -> (Event)((Event.Builder)Event.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventsRequest build() {
            return new PutEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventsRequest> {
        public Builder trackingId(String var1);

        public Builder userId(String var1);

        public Builder sessionId(String var1);

        public Builder eventList(Collection<Event> var1);

        public Builder eventList(Event ... var1);

        public Builder eventList(Consumer<Event.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

