/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents item metadata added to an Items dataset using the <code>PutItems</code> API. For more information see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html">Importing Items Incrementally</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Item implements SdkPojo, Serializable, ToCopyableBuilder<Item.Builder, Item> {
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("itemId")
            .getter(getter(Item::itemId)).setter(setter(Builder::itemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()).build();

    private static final SdkField<String> PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("properties")
            .getter(getter(Item::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ID_FIELD,
            PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String itemId;

    private final String properties;

    private Item(BuilderImpl builder) {
        this.itemId = builder.itemId;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The ID associated with the item.
     * </p>
     * 
     * @return The ID associated with the item.
     */
    public final String itemId() {
        return itemId;
    }

    /**
     * <p>
     * A string map of item-specific metadata. Each element in the map consists of a key-value pair. For example,
     * <code>{"numberOfRatings": "12"}</code>.
     * </p>
     * <p>
     * The keys use camel case names that match the fields in the schema for the Items dataset. In the previous example,
     * the <code>numberOfRatings</code> matches the 'NUMBER_OF_RATINGS' field defined in the Items schema. For
     * categorical string data, to include multiple categories for a single item, separate each category with a pipe
     * separator (<code>|</code>). For example, <code>\"Horror|Action\"</code>.
     * </p>
     * 
     * @return A string map of item-specific metadata. Each element in the map consists of a key-value pair. For
     *         example, <code>{"numberOfRatings": "12"}</code>.</p>
     *         <p>
     *         The keys use camel case names that match the fields in the schema for the Items dataset. In the previous
     *         example, the <code>numberOfRatings</code> matches the 'NUMBER_OF_RATINGS' field defined in the Items
     *         schema. For categorical string data, to include multiple categories for a single item, separate each
     *         category with a pipe separator (<code>|</code>). For example, <code>\"Horror|Action\"</code>.
     */
    public final String properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemId());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item) obj;
        return Objects.equals(itemId(), other.itemId()) && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Item").add("ItemId", itemId()).add("Properties", properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemId":
            return Optional.ofNullable(clazz.cast(itemId()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Item, T> g) {
        return obj -> g.apply((Item) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Item> {
        /**
         * <p>
         * The ID associated with the item.
         * </p>
         * 
         * @param itemId
         *        The ID associated with the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemId(String itemId);

        /**
         * <p>
         * A string map of item-specific metadata. Each element in the map consists of a key-value pair. For example,
         * <code>{"numberOfRatings": "12"}</code>.
         * </p>
         * <p>
         * The keys use camel case names that match the fields in the schema for the Items dataset. In the previous
         * example, the <code>numberOfRatings</code> matches the 'NUMBER_OF_RATINGS' field defined in the Items schema.
         * For categorical string data, to include multiple categories for a single item, separate each category with a
         * pipe separator (<code>|</code>). For example, <code>\"Horror|Action\"</code>.
         * </p>
         * 
         * @param properties
         *        A string map of item-specific metadata. Each element in the map consists of a key-value pair. For
         *        example, <code>{"numberOfRatings": "12"}</code>.</p>
         *        <p>
         *        The keys use camel case names that match the fields in the schema for the Items dataset. In the
         *        previous example, the <code>numberOfRatings</code> matches the 'NUMBER_OF_RATINGS' field defined in
         *        the Items schema. For categorical string data, to include multiple categories for a single item,
         *        separate each category with a pipe separator (<code>|</code>). For example,
         *        <code>\"Horror|Action\"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);
    }

    static final class BuilderImpl implements Builder {
        private String itemId;

        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(Item model) {
            itemId(model.itemId);
            properties(model.properties);
        }

        public final String getItemId() {
            return itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public final String getProperties() {
            return properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public Item build() {
            return new Item(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
