/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalizeevents.model.PersonalizeEventsRequest;
import software.amazon.awssdk.services.personalizeevents.model.User;
import software.amazon.awssdk.services.personalizeevents.model.UserListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutUsersRequest
extends PersonalizeEventsRequest
implements ToCopyableBuilder<Builder, PutUsersRequest> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetArn").getter(PutUsersRequest.getter(PutUsersRequest::datasetArn)).setter(PutUsersRequest.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()}).build();
    private static final SdkField<List<User>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("users").getter(PutUsersRequest.getter(PutUsersRequest::users)).setter(PutUsersRequest.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD, USERS_FIELD));
    private final String datasetArn;
    private final List<User> users;

    private PutUsersRequest(BuilderImpl builder) {
        super(builder);
        this.datasetArn = builder.datasetArn;
        this.users = builder.users;
    }

    public String datasetArn() {
        return this.datasetArn;
    }

    public boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public List<User> users() {
        return this.users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutUsersRequest)) {
            return false;
        }
        PutUsersRequest other = (PutUsersRequest)((Object)obj);
        return Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.users(), other.users());
    }

    public String toString() {
        return ToString.builder((String)"PutUsersRequest").add("DatasetArn", (Object)this.datasetArn()).add("Users", this.users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutUsersRequest, T> g) {
        return obj -> g.apply((PutUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeEventsRequest.BuilderImpl
    implements Builder {
        private String datasetArn;
        private List<User> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutUsersRequest model) {
            super(model);
            this.datasetArn(model.datasetArn);
            this.users(model.users);
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final Collection<User.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(User::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = UserListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (User)((User.Builder)User.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = UserListCopier.copyFromBuilder(users);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutUsersRequest build() {
            return new PutUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutUsersRequest> {
        public Builder datasetArn(String var1);

        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder users(Consumer<User.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

