/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents user interaction event information sent using the <code>PutEvents</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Event implements SdkPojo, Serializable, ToCopyableBuilder<Event.Builder, Event> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Event::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Instant> SENT_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Event::sentAt)).setter(setter(Builder::sentAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_FIELD, PROPERTIES_FIELD, SENT_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final String eventType;

    private final String properties;

    private final Instant sentAt;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.properties = builder.properties;
        this.sentAt = builder.sentAt;
    }

    /**
     * <p>
     * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the
     * event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinquish
     * unique events. Any subsequent events after the first with the same event ID are not used in model training.
     * </p>
     * 
     * @return An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID
     *         for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to
     *         distinquish unique events. Any subsequent events after the first with the same event ID are not used in
     *         model training.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The type of event. This property corresponds to the <code>EVENT_TYPE</code> field of the Interactions schema.
     * </p>
     * 
     * @return The type of event. This property corresponds to the <code>EVENT_TYPE</code> field of the Interactions
     *         schema.
     */
    public String eventType() {
        return eventType;
    }

    /**
     * <p>
     * A string map of event-specific data that you might choose to record. For example, if a user rates a movie on your
     * site, you might send the movie ID and rating, and the number of movie ratings made by the user.
     * </p>
     * <p>
     * Each item in the map consists of a key-value pair. For example,
     * </p>
     * <p>
     * <code>{"itemId": "movie1"}</code>
     * </p>
     * <p>
     * <code>{"itemId": "movie2", "eventValue": "4.5"}</code>
     * </p>
     * <p>
     * <code>{"itemId": "movie3", "eventValue": "3", "numberOfRatings": "12"}</code>
     * </p>
     * <p>
     * The keys use camel case names that match the fields in the Interactions schema. The <code>itemId</code> and
     * <code>eventValue</code> keys correspond to the <code>ITEM_ID</code> and <code>EVENT_VALUE</code> fields. In the
     * above example, the <code>eventType</code> might be 'MovieRating' with <code>eventValue</code> being the rating.
     * The <code>numberOfRatings</code> would match the 'NUMBER_OF_RATINGS' field defined in the Interactions schema.
     * </p>
     * 
     * @return A string map of event-specific data that you might choose to record. For example, if a user rates a movie
     *         on your site, you might send the movie ID and rating, and the number of movie ratings made by the
     *         user.</p>
     *         <p>
     *         Each item in the map consists of a key-value pair. For example,
     *         </p>
     *         <p>
     *         <code>{"itemId": "movie1"}</code>
     *         </p>
     *         <p>
     *         <code>{"itemId": "movie2", "eventValue": "4.5"}</code>
     *         </p>
     *         <p>
     *         <code>{"itemId": "movie3", "eventValue": "3", "numberOfRatings": "12"}</code>
     *         </p>
     *         <p>
     *         The keys use camel case names that match the fields in the Interactions schema. The <code>itemId</code>
     *         and <code>eventValue</code> keys correspond to the <code>ITEM_ID</code> and <code>EVENT_VALUE</code>
     *         fields. In the above example, the <code>eventType</code> might be 'MovieRating' with
     *         <code>eventValue</code> being the rating. The <code>numberOfRatings</code> would match the
     *         'NUMBER_OF_RATINGS' field defined in the Interactions schema.
     */
    public String properties() {
        return properties;
    }

    /**
     * <p>
     * The timestamp on the client side when the event occurred.
     * </p>
     * 
     * @return The timestamp on the client side when the event occurred.
     */
    public Instant sentAt() {
        return sentAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        hashCode = 31 * hashCode + Objects.hashCode(sentAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventType(), other.eventType())
                && Objects.equals(properties(), other.properties()) && Objects.equals(sentAt(), other.sentAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Event").add("EventId", eventId()).add("EventType", eventType()).add("Properties", properties())
                .add("SentAt", sentAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "sentAt":
            return Optional.ofNullable(clazz.cast(sentAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Event> {
        /**
         * <p>
         * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for
         * the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to
         * distinquish unique events. Any subsequent events after the first with the same event ID are not used in model
         * training.
         * </p>
         * 
         * @param eventId
         *        An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique
         *        ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event
         *        ID to distinquish unique events. Any subsequent events after the first with the same event ID are not
         *        used in model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The type of event. This property corresponds to the <code>EVENT_TYPE</code> field of the Interactions schema.
         * </p>
         * 
         * @param eventType
         *        The type of event. This property corresponds to the <code>EVENT_TYPE</code> field of the Interactions
         *        schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * A string map of event-specific data that you might choose to record. For example, if a user rates a movie on
         * your site, you might send the movie ID and rating, and the number of movie ratings made by the user.
         * </p>
         * <p>
         * Each item in the map consists of a key-value pair. For example,
         * </p>
         * <p>
         * <code>{"itemId": "movie1"}</code>
         * </p>
         * <p>
         * <code>{"itemId": "movie2", "eventValue": "4.5"}</code>
         * </p>
         * <p>
         * <code>{"itemId": "movie3", "eventValue": "3", "numberOfRatings": "12"}</code>
         * </p>
         * <p>
         * The keys use camel case names that match the fields in the Interactions schema. The <code>itemId</code> and
         * <code>eventValue</code> keys correspond to the <code>ITEM_ID</code> and <code>EVENT_VALUE</code> fields. In
         * the above example, the <code>eventType</code> might be 'MovieRating' with <code>eventValue</code> being the
         * rating. The <code>numberOfRatings</code> would match the 'NUMBER_OF_RATINGS' field defined in the
         * Interactions schema.
         * </p>
         * 
         * @param properties
         *        A string map of event-specific data that you might choose to record. For example, if a user rates a
         *        movie on your site, you might send the movie ID and rating, and the number of movie ratings made by
         *        the user.</p>
         *        <p>
         *        Each item in the map consists of a key-value pair. For example,
         *        </p>
         *        <p>
         *        <code>{"itemId": "movie1"}</code>
         *        </p>
         *        <p>
         *        <code>{"itemId": "movie2", "eventValue": "4.5"}</code>
         *        </p>
         *        <p>
         *        <code>{"itemId": "movie3", "eventValue": "3", "numberOfRatings": "12"}</code>
         *        </p>
         *        <p>
         *        The keys use camel case names that match the fields in the Interactions schema. The
         *        <code>itemId</code> and <code>eventValue</code> keys correspond to the <code>ITEM_ID</code> and
         *        <code>EVENT_VALUE</code> fields. In the above example, the <code>eventType</code> might be
         *        'MovieRating' with <code>eventValue</code> being the rating. The <code>numberOfRatings</code> would
         *        match the 'NUMBER_OF_RATINGS' field defined in the Interactions schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);

        /**
         * <p>
         * The timestamp on the client side when the event occurred.
         * </p>
         * 
         * @param sentAt
         *        The timestamp on the client side when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentAt(Instant sentAt);
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private String eventType;

        private String properties;

        private Instant sentAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            eventId(model.eventId);
            eventType(model.eventType);
            properties(model.properties);
            sentAt(model.sentAt);
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final String getProperties() {
            return properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        public final Instant getSentAt() {
            return sentAt;
        }

        @Override
        public final Builder sentAt(Instant sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public final void setSentAt(Instant sentAt) {
            this.sentAt = sentAt;
        }

        @Override
        public Event build() {
            return new Event(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
