/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.DatasetSummary;
import software.amazon.awssdk.services.personalize.model.DatasetsCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListDatasetsResponse> {
    private static final SdkField<List<DatasetSummary>> DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDatasetsResponse.getter(ListDatasetsResponse::datasets)).setter(ListDatasetsResponse.setter(Builder::datasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDatasetsResponse.getter(ListDatasetsResponse::nextToken)).setter(ListDatasetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DatasetSummary> datasets;
    private final String nextToken;

    private ListDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.datasets = builder.datasets;
        this.nextToken = builder.nextToken;
    }

    public List<DatasetSummary> datasets() {
        return this.datasets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetsResponse)) {
            return false;
        }
        ListDatasetsResponse other = (ListDatasetsResponse)((Object)obj);
        return Objects.equals(this.datasets(), other.datasets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDatasetsResponse").add("Datasets", this.datasets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasets": {
                return Optional.ofNullable(clazz.cast(this.datasets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetsResponse, T> g) {
        return obj -> g.apply((ListDatasetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<DatasetSummary> datasets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetsResponse model) {
            super(model);
            this.datasets(model.datasets);
            this.nextToken(model.nextToken);
        }

        public final Collection<DatasetSummary.Builder> getDatasets() {
            return this.datasets != null ? (Collection)this.datasets.stream().map(DatasetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datasets(Collection<DatasetSummary> datasets) {
            this.datasets = DatasetsCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(DatasetSummary ... datasets) {
            this.datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<DatasetSummary.Builder> ... datasets) {
            this.datasets(Stream.of(datasets).map(c -> (DatasetSummary)((DatasetSummary.Builder)DatasetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatasets(Collection<DatasetSummary.BuilderImpl> datasets) {
            this.datasets = DatasetsCopier.copyFromBuilder(datasets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatasetsResponse build() {
            return new ListDatasetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetsResponse> {
        public Builder datasets(Collection<DatasetSummary> var1);

        public Builder datasets(DatasetSummary ... var1);

        public Builder datasets(Consumer<DatasetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

