/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.SolutionUpdateConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSolutionRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, UpdateSolutionRequest> {
    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionArn").getter(UpdateSolutionRequest.getter(UpdateSolutionRequest::solutionArn)).setter(UpdateSolutionRequest.setter(Builder::solutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()}).build();
    private static final SdkField<Boolean> PERFORM_AUTO_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performAutoTraining").getter(UpdateSolutionRequest.getter(UpdateSolutionRequest::performAutoTraining)).setter(UpdateSolutionRequest.setter(Builder::performAutoTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoTraining").build()}).build();
    private static final SdkField<Boolean> PERFORM_INCREMENTAL_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performIncrementalUpdate").getter(UpdateSolutionRequest.getter(UpdateSolutionRequest::performIncrementalUpdate)).setter(UpdateSolutionRequest.setter(Builder::performIncrementalUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performIncrementalUpdate").build()}).build();
    private static final SdkField<SolutionUpdateConfig> SOLUTION_UPDATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("solutionUpdateConfig").getter(UpdateSolutionRequest.getter(UpdateSolutionRequest::solutionUpdateConfig)).setter(UpdateSolutionRequest.setter(Builder::solutionUpdateConfig)).constructor(SolutionUpdateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionUpdateConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_ARN_FIELD, PERFORM_AUTO_TRAINING_FIELD, PERFORM_INCREMENTAL_UPDATE_FIELD, SOLUTION_UPDATE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSolutionRequest.memberNameToFieldInitializer();
    private final String solutionArn;
    private final Boolean performAutoTraining;
    private final Boolean performIncrementalUpdate;
    private final SolutionUpdateConfig solutionUpdateConfig;

    private UpdateSolutionRequest(BuilderImpl builder) {
        super(builder);
        this.solutionArn = builder.solutionArn;
        this.performAutoTraining = builder.performAutoTraining;
        this.performIncrementalUpdate = builder.performIncrementalUpdate;
        this.solutionUpdateConfig = builder.solutionUpdateConfig;
    }

    public final String solutionArn() {
        return this.solutionArn;
    }

    public final Boolean performAutoTraining() {
        return this.performAutoTraining;
    }

    public final Boolean performIncrementalUpdate() {
        return this.performIncrementalUpdate;
    }

    public final SolutionUpdateConfig solutionUpdateConfig() {
        return this.solutionUpdateConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.performAutoTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.performIncrementalUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionUpdateConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSolutionRequest)) {
            return false;
        }
        UpdateSolutionRequest other = (UpdateSolutionRequest)((Object)obj);
        return Objects.equals(this.solutionArn(), other.solutionArn()) && Objects.equals(this.performAutoTraining(), other.performAutoTraining()) && Objects.equals(this.performIncrementalUpdate(), other.performIncrementalUpdate()) && Objects.equals(this.solutionUpdateConfig(), other.solutionUpdateConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSolutionRequest").add("SolutionArn", (Object)this.solutionArn()).add("PerformAutoTraining", (Object)this.performAutoTraining()).add("PerformIncrementalUpdate", (Object)this.performIncrementalUpdate()).add("SolutionUpdateConfig", (Object)this.solutionUpdateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionArn()));
            }
            case "performAutoTraining": {
                return Optional.ofNullable(clazz.cast(this.performAutoTraining()));
            }
            case "performIncrementalUpdate": {
                return Optional.ofNullable(clazz.cast(this.performIncrementalUpdate()));
            }
            case "solutionUpdateConfig": {
                return Optional.ofNullable(clazz.cast(this.solutionUpdateConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("solutionArn", SOLUTION_ARN_FIELD);
        map.put("performAutoTraining", PERFORM_AUTO_TRAINING_FIELD);
        map.put("performIncrementalUpdate", PERFORM_INCREMENTAL_UPDATE_FIELD);
        map.put("solutionUpdateConfig", SOLUTION_UPDATE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSolutionRequest, T> g) {
        return obj -> g.apply((UpdateSolutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String solutionArn;
        private Boolean performAutoTraining;
        private Boolean performIncrementalUpdate;
        private SolutionUpdateConfig solutionUpdateConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSolutionRequest model) {
            super(model);
            this.solutionArn(model.solutionArn);
            this.performAutoTraining(model.performAutoTraining);
            this.performIncrementalUpdate(model.performIncrementalUpdate);
            this.solutionUpdateConfig(model.solutionUpdateConfig);
        }

        public final String getSolutionArn() {
            return this.solutionArn;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        @Override
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final Boolean getPerformAutoTraining() {
            return this.performAutoTraining;
        }

        public final void setPerformAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
        }

        @Override
        public final Builder performAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
            return this;
        }

        public final Boolean getPerformIncrementalUpdate() {
            return this.performIncrementalUpdate;
        }

        public final void setPerformIncrementalUpdate(Boolean performIncrementalUpdate) {
            this.performIncrementalUpdate = performIncrementalUpdate;
        }

        @Override
        public final Builder performIncrementalUpdate(Boolean performIncrementalUpdate) {
            this.performIncrementalUpdate = performIncrementalUpdate;
            return this;
        }

        public final SolutionUpdateConfig.Builder getSolutionUpdateConfig() {
            return this.solutionUpdateConfig != null ? this.solutionUpdateConfig.toBuilder() : null;
        }

        public final void setSolutionUpdateConfig(SolutionUpdateConfig.BuilderImpl solutionUpdateConfig) {
            this.solutionUpdateConfig = solutionUpdateConfig != null ? solutionUpdateConfig.build() : null;
        }

        @Override
        public final Builder solutionUpdateConfig(SolutionUpdateConfig solutionUpdateConfig) {
            this.solutionUpdateConfig = solutionUpdateConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSolutionRequest build() {
            return new UpdateSolutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSolutionRequest> {
        public Builder solutionArn(String var1);

        public Builder performAutoTraining(Boolean var1);

        public Builder performIncrementalUpdate(Boolean var1);

        public Builder solutionUpdateConfig(SolutionUpdateConfig var1);

        default public Builder solutionUpdateConfig(Consumer<SolutionUpdateConfig.Builder> solutionUpdateConfig) {
            return this.solutionUpdateConfig((SolutionUpdateConfig)((SolutionUpdateConfig.Builder)SolutionUpdateConfig.builder().applyMutation(solutionUpdateConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

