/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.SolutionUpdateConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SolutionUpdateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SolutionUpdateSummary> {
    private static final SdkField<SolutionUpdateConfig> SOLUTION_UPDATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("solutionUpdateConfig").getter(SolutionUpdateSummary.getter(SolutionUpdateSummary::solutionUpdateConfig)).setter(SolutionUpdateSummary.setter(Builder::solutionUpdateConfig)).constructor(SolutionUpdateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionUpdateConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SolutionUpdateSummary.getter(SolutionUpdateSummary::status)).setter(SolutionUpdateSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> PERFORM_AUTO_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performAutoTraining").getter(SolutionUpdateSummary.getter(SolutionUpdateSummary::performAutoTraining)).setter(SolutionUpdateSummary.setter(Builder::performAutoTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoTraining").build()}).build();
    private static final SdkField<Boolean> PERFORM_INCREMENTAL_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performIncrementalUpdate").getter(SolutionUpdateSummary.getter(SolutionUpdateSummary::performIncrementalUpdate)).setter(SolutionUpdateSummary.setter(Builder::performIncrementalUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performIncrementalUpdate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(SolutionUpdateSummary.getter(SolutionUpdateSummary::creationDateTime)).setter(SolutionUpdateSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(SolutionUpdateSummary.getter(SolutionUpdateSummary::lastUpdatedDateTime)).setter(SolutionUpdateSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(SolutionUpdateSummary.getter(SolutionUpdateSummary::failureReason)).setter(SolutionUpdateSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_UPDATE_CONFIG_FIELD, STATUS_FIELD, PERFORM_AUTO_TRAINING_FIELD, PERFORM_INCREMENTAL_UPDATE_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SolutionUpdateSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SolutionUpdateConfig solutionUpdateConfig;
    private final String status;
    private final Boolean performAutoTraining;
    private final Boolean performIncrementalUpdate;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String failureReason;

    private SolutionUpdateSummary(BuilderImpl builder) {
        this.solutionUpdateConfig = builder.solutionUpdateConfig;
        this.status = builder.status;
        this.performAutoTraining = builder.performAutoTraining;
        this.performIncrementalUpdate = builder.performIncrementalUpdate;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    public final SolutionUpdateConfig solutionUpdateConfig() {
        return this.solutionUpdateConfig;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean performAutoTraining() {
        return this.performAutoTraining;
    }

    public final Boolean performIncrementalUpdate() {
        return this.performIncrementalUpdate;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionUpdateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.performAutoTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.performIncrementalUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionUpdateSummary)) {
            return false;
        }
        SolutionUpdateSummary other = (SolutionUpdateSummary)obj;
        return Objects.equals(this.solutionUpdateConfig(), other.solutionUpdateConfig()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.performAutoTraining(), other.performAutoTraining()) && Objects.equals(this.performIncrementalUpdate(), other.performIncrementalUpdate()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"SolutionUpdateSummary").add("SolutionUpdateConfig", (Object)this.solutionUpdateConfig()).add("Status", (Object)this.status()).add("PerformAutoTraining", (Object)this.performAutoTraining()).add("PerformIncrementalUpdate", (Object)this.performIncrementalUpdate()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutionUpdateConfig": {
                return Optional.ofNullable(clazz.cast(this.solutionUpdateConfig()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "performAutoTraining": {
                return Optional.ofNullable(clazz.cast(this.performAutoTraining()));
            }
            case "performIncrementalUpdate": {
                return Optional.ofNullable(clazz.cast(this.performIncrementalUpdate()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("solutionUpdateConfig", SOLUTION_UPDATE_CONFIG_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("performAutoTraining", PERFORM_AUTO_TRAINING_FIELD);
        map.put("performIncrementalUpdate", PERFORM_INCREMENTAL_UPDATE_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SolutionUpdateSummary, T> g) {
        return obj -> g.apply((SolutionUpdateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SolutionUpdateConfig solutionUpdateConfig;
        private String status;
        private Boolean performAutoTraining;
        private Boolean performIncrementalUpdate;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionUpdateSummary model) {
            this.solutionUpdateConfig(model.solutionUpdateConfig);
            this.status(model.status);
            this.performAutoTraining(model.performAutoTraining);
            this.performIncrementalUpdate(model.performIncrementalUpdate);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.failureReason(model.failureReason);
        }

        public final SolutionUpdateConfig.Builder getSolutionUpdateConfig() {
            return this.solutionUpdateConfig != null ? this.solutionUpdateConfig.toBuilder() : null;
        }

        public final void setSolutionUpdateConfig(SolutionUpdateConfig.BuilderImpl solutionUpdateConfig) {
            this.solutionUpdateConfig = solutionUpdateConfig != null ? solutionUpdateConfig.build() : null;
        }

        @Override
        public final Builder solutionUpdateConfig(SolutionUpdateConfig solutionUpdateConfig) {
            this.solutionUpdateConfig = solutionUpdateConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getPerformAutoTraining() {
            return this.performAutoTraining;
        }

        public final void setPerformAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
        }

        @Override
        public final Builder performAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
            return this;
        }

        public final Boolean getPerformIncrementalUpdate() {
            return this.performIncrementalUpdate;
        }

        public final void setPerformIncrementalUpdate(Boolean performIncrementalUpdate) {
            this.performIncrementalUpdate = performIncrementalUpdate;
        }

        @Override
        public final Builder performIncrementalUpdate(Boolean performIncrementalUpdate) {
            this.performIncrementalUpdate = performIncrementalUpdate;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public SolutionUpdateSummary build() {
            return new SolutionUpdateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SolutionUpdateSummary> {
        public Builder solutionUpdateConfig(SolutionUpdateConfig var1);

        default public Builder solutionUpdateConfig(Consumer<SolutionUpdateConfig.Builder> solutionUpdateConfig) {
            return this.solutionUpdateConfig((SolutionUpdateConfig)((SolutionUpdateConfig.Builder)SolutionUpdateConfig.builder().applyMutation(solutionUpdateConfig)).build());
        }

        public Builder status(String var1);

        public Builder performAutoTraining(Boolean var1);

        public Builder performIncrementalUpdate(Boolean var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

