/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The training data configuration to use when creating a domain recommender or custom solution version (trained model).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingDataConfig.Builder, TrainingDataConfig> {
    private static final SdkField<Map<String, List<String>>> EXCLUDED_DATASET_COLUMNS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("excludedDatasetColumns")
            .getter(getter(TrainingDataConfig::excludedDatasetColumns))
            .setter(setter(Builder::excludedDatasetColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedDatasetColumns").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> INCLUDED_DATASET_COLUMNS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("includedDatasetColumns")
            .getter(getter(TrainingDataConfig::includedDatasetColumns))
            .setter(setter(Builder::includedDatasetColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedDatasetColumns").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXCLUDED_DATASET_COLUMNS_FIELD, INCLUDED_DATASET_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, List<String>> excludedDatasetColumns;

    private final Map<String, List<String>> includedDatasetColumns;

    private TrainingDataConfig(BuilderImpl builder) {
        this.excludedDatasetColumns = builder.excludedDatasetColumns;
        this.includedDatasetColumns = builder.includedDatasetColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedDatasetColumns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExcludedDatasetColumns() {
        return excludedDatasetColumns != null && !(excludedDatasetColumns instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the columns to exclude from training. Each key is a dataset type, and each value is a list of columns.
     * Exclude columns to control what data Amazon Personalize uses to generate recommendations.
     * </p>
     * <p>
     * For example, you might have a column that you want to use only to filter recommendations. You can exclude this
     * column from training and Amazon Personalize considers it only when filtering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedDatasetColumns} method.
     * </p>
     * 
     * @return Specifies the columns to exclude from training. Each key is a dataset type, and each value is a list of
     *         columns. Exclude columns to control what data Amazon Personalize uses to generate recommendations.</p>
     *         <p>
     *         For example, you might have a column that you want to use only to filter recommendations. You can exclude
     *         this column from training and Amazon Personalize considers it only when filtering.
     */
    public final Map<String, List<String>> excludedDatasetColumns() {
        return excludedDatasetColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludedDatasetColumns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIncludedDatasetColumns() {
        return includedDatasetColumns != null && !(includedDatasetColumns instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that specifies which columns to include from each dataset during training. The map can contain up to 3
     * entries, where each key is a dataset name (maximum length of 256 characters, must contain only letters and
     * underscores) and each value is an array of up to 50 column names. Column names can be up to 150 characters long,
     * must start with a letter or underscore, and can contain only letters, numbers, and underscores.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludedDatasetColumns} method.
     * </p>
     * 
     * @return A map that specifies which columns to include from each dataset during training. The map can contain up
     *         to 3 entries, where each key is a dataset name (maximum length of 256 characters, must contain only
     *         letters and underscores) and each value is an array of up to 50 column names. Column names can be up to
     *         150 characters long, must start with a letter or underscore, and can contain only letters, numbers, and
     *         underscores.
     */
    public final Map<String, List<String>> includedDatasetColumns() {
        return includedDatasetColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedDatasetColumns() ? excludedDatasetColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludedDatasetColumns() ? includedDatasetColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataConfig)) {
            return false;
        }
        TrainingDataConfig other = (TrainingDataConfig) obj;
        return hasExcludedDatasetColumns() == other.hasExcludedDatasetColumns()
                && Objects.equals(excludedDatasetColumns(), other.excludedDatasetColumns())
                && hasIncludedDatasetColumns() == other.hasIncludedDatasetColumns()
                && Objects.equals(includedDatasetColumns(), other.includedDatasetColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingDataConfig")
                .add("ExcludedDatasetColumns", hasExcludedDatasetColumns() ? excludedDatasetColumns() : null)
                .add("IncludedDatasetColumns", hasIncludedDatasetColumns() ? includedDatasetColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "excludedDatasetColumns":
            return Optional.ofNullable(clazz.cast(excludedDatasetColumns()));
        case "includedDatasetColumns":
            return Optional.ofNullable(clazz.cast(includedDatasetColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("excludedDatasetColumns", EXCLUDED_DATASET_COLUMNS_FIELD);
        map.put("includedDatasetColumns", INCLUDED_DATASET_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataConfig, T> g) {
        return obj -> g.apply((TrainingDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingDataConfig> {
        /**
         * <p>
         * Specifies the columns to exclude from training. Each key is a dataset type, and each value is a list of
         * columns. Exclude columns to control what data Amazon Personalize uses to generate recommendations.
         * </p>
         * <p>
         * For example, you might have a column that you want to use only to filter recommendations. You can exclude
         * this column from training and Amazon Personalize considers it only when filtering.
         * </p>
         * 
         * @param excludedDatasetColumns
         *        Specifies the columns to exclude from training. Each key is a dataset type, and each value is a list
         *        of columns. Exclude columns to control what data Amazon Personalize uses to generate
         *        recommendations.</p>
         *        <p>
         *        For example, you might have a column that you want to use only to filter recommendations. You can
         *        exclude this column from training and Amazon Personalize considers it only when filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedDatasetColumns(Map<String, ? extends Collection<String>> excludedDatasetColumns);

        /**
         * <p>
         * A map that specifies which columns to include from each dataset during training. The map can contain up to 3
         * entries, where each key is a dataset name (maximum length of 256 characters, must contain only letters and
         * underscores) and each value is an array of up to 50 column names. Column names can be up to 150 characters
         * long, must start with a letter or underscore, and can contain only letters, numbers, and underscores.
         * </p>
         * 
         * @param includedDatasetColumns
         *        A map that specifies which columns to include from each dataset during training. The map can contain
         *        up to 3 entries, where each key is a dataset name (maximum length of 256 characters, must contain only
         *        letters and underscores) and each value is an array of up to 50 column names. Column names can be up
         *        to 150 characters long, must start with a letter or underscore, and can contain only letters, numbers,
         *        and underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedDatasetColumns(Map<String, ? extends Collection<String>> includedDatasetColumns);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<String>> excludedDatasetColumns = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<String>> includedDatasetColumns = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataConfig model) {
            excludedDatasetColumns(model.excludedDatasetColumns);
            includedDatasetColumns(model.includedDatasetColumns);
        }

        public final Map<String, ? extends Collection<String>> getExcludedDatasetColumns() {
            if (excludedDatasetColumns instanceof SdkAutoConstructMap) {
                return null;
            }
            return excludedDatasetColumns;
        }

        public final void setExcludedDatasetColumns(Map<String, ? extends Collection<String>> excludedDatasetColumns) {
            this.excludedDatasetColumns = ExcludedDatasetColumnsCopier.copy(excludedDatasetColumns);
        }

        @Override
        public final Builder excludedDatasetColumns(Map<String, ? extends Collection<String>> excludedDatasetColumns) {
            this.excludedDatasetColumns = ExcludedDatasetColumnsCopier.copy(excludedDatasetColumns);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIncludedDatasetColumns() {
            if (includedDatasetColumns instanceof SdkAutoConstructMap) {
                return null;
            }
            return includedDatasetColumns;
        }

        public final void setIncludedDatasetColumns(Map<String, ? extends Collection<String>> includedDatasetColumns) {
            this.includedDatasetColumns = IncludedDatasetColumnsCopier.copy(includedDatasetColumns);
        }

        @Override
        public final Builder includedDatasetColumns(Map<String, ? extends Collection<String>> includedDatasetColumns) {
            this.includedDatasetColumns = IncludedDatasetColumnsCopier.copy(includedDatasetColumns);
            return this;
        }

        @Override
        public TrainingDataConfig build() {
            return new TrainingDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
