/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.DatasetExportJobSummary;
import software.amazon.awssdk.services.personalize.model.DatasetExportJobsCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetExportJobsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListDatasetExportJobsResponse> {
    private static final SdkField<List<DatasetExportJobSummary>> DATASET_EXPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datasetExportJobs").getter(ListDatasetExportJobsResponse.getter(ListDatasetExportJobsResponse::datasetExportJobs)).setter(ListDatasetExportJobsResponse.setter(Builder::datasetExportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetExportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetExportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDatasetExportJobsResponse.getter(ListDatasetExportJobsResponse::nextToken)).setter(ListDatasetExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_EXPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datasetExportJobs", DATASET_EXPORT_JOBS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DatasetExportJobSummary> datasetExportJobs;
    private final String nextToken;

    private ListDatasetExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetExportJobs = builder.datasetExportJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatasetExportJobs() {
        return this.datasetExportJobs != null && !(this.datasetExportJobs instanceof SdkAutoConstructList);
    }

    public final List<DatasetExportJobSummary> datasetExportJobs() {
        return this.datasetExportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetExportJobs() ? this.datasetExportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetExportJobsResponse)) {
            return false;
        }
        ListDatasetExportJobsResponse other = (ListDatasetExportJobsResponse)((Object)obj);
        return this.hasDatasetExportJobs() == other.hasDatasetExportJobs() && Objects.equals(this.datasetExportJobs(), other.datasetExportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetExportJobsResponse").add("DatasetExportJobs", this.hasDatasetExportJobs() ? this.datasetExportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetExportJobs": {
                return Optional.ofNullable(clazz.cast(this.datasetExportJobs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetExportJobsResponse, T> g) {
        return obj -> g.apply((ListDatasetExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<DatasetExportJobSummary> datasetExportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetExportJobsResponse model) {
            super(model);
            this.datasetExportJobs(model.datasetExportJobs);
            this.nextToken(model.nextToken);
        }

        public final List<DatasetExportJobSummary.Builder> getDatasetExportJobs() {
            List<DatasetExportJobSummary.Builder> result = DatasetExportJobsCopier.copyToBuilder(this.datasetExportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetExportJobs(Collection<DatasetExportJobSummary.BuilderImpl> datasetExportJobs) {
            this.datasetExportJobs = DatasetExportJobsCopier.copyFromBuilder(datasetExportJobs);
        }

        @Override
        public final Builder datasetExportJobs(Collection<DatasetExportJobSummary> datasetExportJobs) {
            this.datasetExportJobs = DatasetExportJobsCopier.copy(datasetExportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetExportJobs(DatasetExportJobSummary ... datasetExportJobs) {
            this.datasetExportJobs(Arrays.asList(datasetExportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetExportJobs(Consumer<DatasetExportJobSummary.Builder> ... datasetExportJobs) {
            this.datasetExportJobs(Stream.of(datasetExportJobs).map(c -> (DatasetExportJobSummary)((DatasetExportJobSummary.Builder)DatasetExportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasetExportJobsResponse build() {
            return new ListDatasetExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetExportJobsResponse> {
        public Builder datasetExportJobs(Collection<DatasetExportJobSummary> var1);

        public Builder datasetExportJobs(DatasetExportJobSummary ... var1);

        public Builder datasetExportJobs(Consumer<DatasetExportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

