/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainingMode {
    FULL("FULL"),
    UPDATE("UPDATE"),
    AUTOTRAIN("AUTOTRAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainingMode> VALUE_MAP;
    private final String value;

    private TrainingMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingMode> knownValues() {
        EnumSet<TrainingMode> knownValues = EnumSet.allOf(TrainingMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainingMode.class, TrainingMode::toString);
    }
}

