/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecommenderResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeRecommenderResponse.Builder, DescribeRecommenderResponse> {
    private static final SdkField<Recommender> RECOMMENDER_FIELD = SdkField.<Recommender> builder(MarshallingType.SDK_POJO)
            .memberName("recommender").getter(getter(DescribeRecommenderResponse::recommender))
            .setter(setter(Builder::recommender)).constructor(Recommender::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommender").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_FIELD));

    private final Recommender recommender;

    private DescribeRecommenderResponse(BuilderImpl builder) {
        super(builder);
        this.recommender = builder.recommender;
    }

    /**
     * <p>
     * The properties of the recommender.
     * </p>
     * 
     * @return The properties of the recommender.
     */
    public final Recommender recommender() {
        return recommender;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommender());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommenderResponse)) {
            return false;
        }
        DescribeRecommenderResponse other = (DescribeRecommenderResponse) obj;
        return Objects.equals(recommender(), other.recommender());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecommenderResponse").add("Recommender", recommender()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommender":
            return Optional.ofNullable(clazz.cast(recommender()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommenderResponse, T> g) {
        return obj -> g.apply((DescribeRecommenderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRecommenderResponse> {
        /**
         * <p>
         * The properties of the recommender.
         * </p>
         * 
         * @param recommender
         *        The properties of the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommender(Recommender recommender);

        /**
         * <p>
         * The properties of the recommender.
         * </p>
         * This is a convenience method that creates an instance of the {@link Recommender.Builder} avoiding the need to
         * create one manually via {@link Recommender#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Recommender.Builder#build()} is called immediately and its result
         * is passed to {@link #recommender(Recommender)}.
         * 
         * @param recommender
         *        a consumer that will call methods on {@link Recommender.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommender(Recommender)
         */
        default Builder recommender(Consumer<Recommender.Builder> recommender) {
            return recommender(Recommender.builder().applyMutation(recommender).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private Recommender recommender;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommenderResponse model) {
            super(model);
            recommender(model.recommender);
        }

        public final Recommender.Builder getRecommender() {
            return recommender != null ? recommender.toBuilder() : null;
        }

        public final void setRecommender(Recommender.BuilderImpl recommender) {
            this.recommender = recommender != null ? recommender.build() : null;
        }

        @Override
        public final Builder recommender(Recommender recommender) {
            this.recommender = recommender;
            return this;
        }

        @Override
        public DescribeRecommenderResponse build() {
            return new DescribeRecommenderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
