/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlgorithmResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeAlgorithmResponse.Builder, DescribeAlgorithmResponse> {
    private static final SdkField<Algorithm> ALGORITHM_FIELD = SdkField.<Algorithm> builder(MarshallingType.SDK_POJO)
            .memberName("algorithm").getter(getter(DescribeAlgorithmResponse::algorithm)).setter(setter(Builder::algorithm))
            .constructor(Algorithm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD));

    private final Algorithm algorithm;

    private DescribeAlgorithmResponse(BuilderImpl builder) {
        super(builder);
        this.algorithm = builder.algorithm;
    }

    /**
     * <p>
     * A listing of the properties of the algorithm.
     * </p>
     * 
     * @return A listing of the properties of the algorithm.
     */
    public final Algorithm algorithm() {
        return algorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(algorithm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlgorithmResponse)) {
            return false;
        }
        DescribeAlgorithmResponse other = (DescribeAlgorithmResponse) obj;
        return Objects.equals(algorithm(), other.algorithm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlgorithmResponse").add("Algorithm", algorithm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "algorithm":
            return Optional.ofNullable(clazz.cast(algorithm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlgorithmResponse, T> g) {
        return obj -> g.apply((DescribeAlgorithmResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlgorithmResponse> {
        /**
         * <p>
         * A listing of the properties of the algorithm.
         * </p>
         * 
         * @param algorithm
         *        A listing of the properties of the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithm(Algorithm algorithm);

        /**
         * <p>
         * A listing of the properties of the algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link Algorithm.Builder} avoiding the need to
         * create one manually via {@link Algorithm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Algorithm.Builder#build()} is called immediately and its result
         * is passed to {@link #algorithm(Algorithm)}.
         * 
         * @param algorithm
         *        a consumer that will call methods on {@link Algorithm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithm(Algorithm)
         */
        default Builder algorithm(Consumer<Algorithm.Builder> algorithm) {
            return algorithm(Algorithm.builder().applyMutation(algorithm).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private Algorithm algorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlgorithmResponse model) {
            super(model);
            algorithm(model.algorithm);
        }

        public final Algorithm.Builder getAlgorithm() {
            return algorithm != null ? algorithm.toBuilder() : null;
        }

        public final void setAlgorithm(Algorithm.BuilderImpl algorithm) {
            this.algorithm = algorithm != null ? algorithm.build() : null;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public DescribeAlgorithmResponse build() {
            return new DescribeAlgorithmResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
