/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommenderConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommenderConfig> {
    private static final SdkField<Map<String, String>> ITEM_EXPLORATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("itemExplorationConfig").getter(RecommenderConfig.getter(RecommenderConfig::itemExplorationConfig)).setter(RecommenderConfig.setter(Builder::itemExplorationConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemExplorationConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_RECOMMENDATION_REQUESTS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minRecommendationRequestsPerSecond").getter(RecommenderConfig.getter(RecommenderConfig::minRecommendationRequestsPerSecond)).setter(RecommenderConfig.setter(Builder::minRecommendationRequestsPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minRecommendationRequestsPerSecond").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_EXPLORATION_CONFIG_FIELD, MIN_RECOMMENDATION_REQUESTS_PER_SECOND_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> itemExplorationConfig;
    private final Integer minRecommendationRequestsPerSecond;

    private RecommenderConfig(BuilderImpl builder) {
        this.itemExplorationConfig = builder.itemExplorationConfig;
        this.minRecommendationRequestsPerSecond = builder.minRecommendationRequestsPerSecond;
    }

    public final boolean hasItemExplorationConfig() {
        return this.itemExplorationConfig != null && !(this.itemExplorationConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> itemExplorationConfig() {
        return this.itemExplorationConfig;
    }

    public final Integer minRecommendationRequestsPerSecond() {
        return this.minRecommendationRequestsPerSecond;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemExplorationConfig() ? this.itemExplorationConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minRecommendationRequestsPerSecond());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommenderConfig)) {
            return false;
        }
        RecommenderConfig other = (RecommenderConfig)obj;
        return this.hasItemExplorationConfig() == other.hasItemExplorationConfig() && Objects.equals(this.itemExplorationConfig(), other.itemExplorationConfig()) && Objects.equals(this.minRecommendationRequestsPerSecond(), other.minRecommendationRequestsPerSecond());
    }

    public final String toString() {
        return ToString.builder((String)"RecommenderConfig").add("ItemExplorationConfig", this.hasItemExplorationConfig() ? this.itemExplorationConfig() : null).add("MinRecommendationRequestsPerSecond", (Object)this.minRecommendationRequestsPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemExplorationConfig": {
                return Optional.ofNullable(clazz.cast(this.itemExplorationConfig()));
            }
            case "minRecommendationRequestsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.minRecommendationRequestsPerSecond()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommenderConfig, T> g) {
        return obj -> g.apply((RecommenderConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> itemExplorationConfig = DefaultSdkAutoConstructMap.getInstance();
        private Integer minRecommendationRequestsPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommenderConfig model) {
            this.itemExplorationConfig(model.itemExplorationConfig);
            this.minRecommendationRequestsPerSecond(model.minRecommendationRequestsPerSecond);
        }

        public final Map<String, String> getItemExplorationConfig() {
            if (this.itemExplorationConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.itemExplorationConfig;
        }

        public final void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
        }

        @Override
        public final Builder itemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
            return this;
        }

        public final Integer getMinRecommendationRequestsPerSecond() {
            return this.minRecommendationRequestsPerSecond;
        }

        public final void setMinRecommendationRequestsPerSecond(Integer minRecommendationRequestsPerSecond) {
            this.minRecommendationRequestsPerSecond = minRecommendationRequestsPerSecond;
        }

        @Override
        public final Builder minRecommendationRequestsPerSecond(Integer minRecommendationRequestsPerSecond) {
            this.minRecommendationRequestsPerSecond = minRecommendationRequestsPerSecond;
            return this;
        }

        public RecommenderConfig build() {
            return new RecommenderConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommenderConfig> {
        public Builder itemExplorationConfig(Map<String, String> var1);

        public Builder minRecommendationRequestsPerSecond(Integer var1);
    }
}

