/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetGroupResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeDatasetGroupResponse.Builder, DescribeDatasetGroupResponse> {
    private static final SdkField<DatasetGroup> DATASET_GROUP_FIELD = SdkField.<DatasetGroup> builder(MarshallingType.SDK_POJO)
            .memberName("datasetGroup").getter(getter(DescribeDatasetGroupResponse::datasetGroup))
            .setter(setter(Builder::datasetGroup)).constructor(DatasetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_FIELD));

    private final DatasetGroup datasetGroup;

    private DescribeDatasetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.datasetGroup = builder.datasetGroup;
    }

    /**
     * <p>
     * A listing of the dataset group's properties.
     * </p>
     * 
     * @return A listing of the dataset group's properties.
     */
    public final DatasetGroup datasetGroup() {
        return datasetGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetGroupResponse)) {
            return false;
        }
        DescribeDatasetGroupResponse other = (DescribeDatasetGroupResponse) obj;
        return Objects.equals(datasetGroup(), other.datasetGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetGroupResponse").add("DatasetGroup", datasetGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetGroup":
            return Optional.ofNullable(clazz.cast(datasetGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetGroupResponse, T> g) {
        return obj -> g.apply((DescribeDatasetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetGroupResponse> {
        /**
         * <p>
         * A listing of the dataset group's properties.
         * </p>
         * 
         * @param datasetGroup
         *        A listing of the dataset group's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroup(DatasetGroup datasetGroup);

        /**
         * <p>
         * A listing of the dataset group's properties.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetGroup.Builder} avoiding the need to
         * create one manually via {@link DatasetGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetGroup(DatasetGroup)}.
         * 
         * @param datasetGroup
         *        a consumer that will call methods on {@link DatasetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetGroup(DatasetGroup)
         */
        default Builder datasetGroup(Consumer<DatasetGroup.Builder> datasetGroup) {
            return datasetGroup(DatasetGroup.builder().applyMutation(datasetGroup).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private DatasetGroup datasetGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetGroupResponse model) {
            super(model);
            datasetGroup(model.datasetGroup);
        }

        public final DatasetGroup.Builder getDatasetGroup() {
            return datasetGroup != null ? datasetGroup.toBuilder() : null;
        }

        @Override
        public final Builder datasetGroup(DatasetGroup datasetGroup) {
            this.datasetGroup = datasetGroup;
            return this;
        }

        public final void setDatasetGroup(DatasetGroup.BuilderImpl datasetGroup) {
            this.datasetGroup = datasetGroup != null ? datasetGroup.build() : null;
        }

        @Override
        public DescribeDatasetGroupResponse build() {
            return new DescribeDatasetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
