/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.MetricsCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolutionMetricsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, GetSolutionMetricsResponse> {
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionVersionArn").getter(GetSolutionMetricsResponse.getter(GetSolutionMetricsResponse::solutionVersionArn)).setter(GetSolutionMetricsResponse.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<Map<String, Double>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metrics").getter(GetSolutionMetricsResponse.getter(GetSolutionMetricsResponse::metrics)).setter(GetSolutionMetricsResponse.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_VERSION_ARN_FIELD, METRICS_FIELD));
    private final String solutionVersionArn;
    private final Map<String, Double> metrics;

    private GetSolutionMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.solutionVersionArn = builder.solutionVersionArn;
        this.metrics = builder.metrics;
    }

    public String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public Map<String, Double> metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolutionMetricsResponse)) {
            return false;
        }
        GetSolutionMetricsResponse other = (GetSolutionMetricsResponse)((Object)obj);
        return Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.metrics(), other.metrics());
    }

    public String toString() {
        return ToString.builder((String)"GetSolutionMetricsResponse").add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("Metrics", this.metrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSolutionMetricsResponse, T> g) {
        return obj -> g.apply((GetSolutionMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private String solutionVersionArn;
        private Map<String, Double> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolutionMetricsResponse model) {
            super(model);
            this.solutionVersionArn(model.solutionVersionArn);
            this.metrics(model.metrics);
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        public final Map<String, Double> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Map<String, Double> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        @Override
        public GetSolutionMetricsResponse build() {
            return new GetSolutionMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSolutionMetricsResponse> {
        public Builder solutionVersionArn(String var1);

        public Builder metrics(Map<String, Double> var1);
    }
}

