/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBatchInferenceJobResponse extends PersonalizeResponse implements
        ToCopyableBuilder<CreateBatchInferenceJobResponse.Builder, CreateBatchInferenceJobResponse> {
    private static final SdkField<String> BATCH_INFERENCE_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBatchInferenceJobResponse::batchInferenceJobArn)).setter(setter(Builder::batchInferenceJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(BATCH_INFERENCE_JOB_ARN_FIELD));

    private final String batchInferenceJobArn;

    private CreateBatchInferenceJobResponse(BuilderImpl builder) {
        super(builder);
        this.batchInferenceJobArn = builder.batchInferenceJobArn;
    }

    /**
     * <p>
     * The ARN of the batch inference job.
     * </p>
     * 
     * @return The ARN of the batch inference job.
     */
    public String batchInferenceJobArn() {
        return batchInferenceJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(batchInferenceJobArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchInferenceJobResponse)) {
            return false;
        }
        CreateBatchInferenceJobResponse other = (CreateBatchInferenceJobResponse) obj;
        return Objects.equals(batchInferenceJobArn(), other.batchInferenceJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateBatchInferenceJobResponse").add("BatchInferenceJobArn", batchInferenceJobArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchInferenceJobArn":
            return Optional.ofNullable(clazz.cast(batchInferenceJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchInferenceJobResponse, T> g) {
        return obj -> g.apply((CreateBatchInferenceJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBatchInferenceJobResponse> {
        /**
         * <p>
         * The ARN of the batch inference job.
         * </p>
         * 
         * @param batchInferenceJobArn
         *        The ARN of the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchInferenceJobArn(String batchInferenceJobArn);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private String batchInferenceJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchInferenceJobResponse model) {
            super(model);
            batchInferenceJobArn(model.batchInferenceJobArn);
        }

        public final String getBatchInferenceJobArn() {
            return batchInferenceJobArn;
        }

        @Override
        public final Builder batchInferenceJobArn(String batchInferenceJobArn) {
            this.batchInferenceJobArn = batchInferenceJobArn;
            return this;
        }

        public final void setBatchInferenceJobArn(String batchInferenceJobArn) {
            this.batchInferenceJobArn = batchInferenceJobArn;
        }

        @Override
        public CreateBatchInferenceJobResponse build() {
            return new CreateBatchInferenceJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
