/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcs.PcsClient;
import software.amazon.awssdk.services.pcs.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSummary;
import software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest;
import software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse;

public class ListComputeNodeGroupsIterable
implements SdkIterable<ListComputeNodeGroupsResponse> {
    private final PcsClient client;
    private final ListComputeNodeGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComputeNodeGroupsIterable(PcsClient client, ListComputeNodeGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComputeNodeGroupsResponseFetcher();
    }

    public Iterator<ListComputeNodeGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComputeNodeGroupSummary> computeNodeGroups() {
        Function<ListComputeNodeGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.computeNodeGroups() != null) {
                return response.computeNodeGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComputeNodeGroupsResponseFetcher
    implements SyncPageFetcher<ListComputeNodeGroupsResponse> {
        private ListComputeNodeGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListComputeNodeGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComputeNodeGroupsResponse nextPage(ListComputeNodeGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListComputeNodeGroupsIterable.this.client.listComputeNodeGroups(ListComputeNodeGroupsIterable.this.firstRequest);
            }
            return ListComputeNodeGroupsIterable.this.client.listComputeNodeGroups((ListComputeNodeGroupsRequest)((Object)ListComputeNodeGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

