/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcs.model.PcsResponse;
import software.amazon.awssdk.services.pcs.model.QueueListCopier;
import software.amazon.awssdk.services.pcs.model.QueueSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueuesResponse
extends PcsResponse
implements ToCopyableBuilder<Builder, ListQueuesResponse> {
    private static final SdkField<List<QueueSummary>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queues").getter(ListQueuesResponse.getter(ListQueuesResponse::queues)).setter(ListQueuesResponse.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueueSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListQueuesResponse.getter(ListQueuesResponse::nextToken)).setter(ListQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQueuesResponse.memberNameToFieldInitializer();
    private final List<QueueSummary> queues;
    private final String nextToken;

    private ListQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queues = builder.queues;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public final List<QueueSummary> queues() {
        return this.queues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse)((Object)obj);
        return this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueuesResponse").add("Queues", this.hasQueues() ? this.queues() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queues", QUEUES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesResponse, T> g) {
        return obj -> g.apply((ListQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcsResponse.BuilderImpl
    implements Builder {
        private List<QueueSummary> queues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            super(model);
            this.queues(model.queues);
            this.nextToken(model.nextToken);
        }

        public final List<QueueSummary.Builder> getQueues() {
            List<QueueSummary.Builder> result = QueueListCopier.copyToBuilder(this.queues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueues(Collection<QueueSummary.BuilderImpl> queues) {
            this.queues = QueueListCopier.copyFromBuilder(queues);
        }

        @Override
        public final Builder queues(Collection<QueueSummary> queues) {
            this.queues = QueueListCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(QueueSummary ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Consumer<QueueSummary.Builder> ... queues) {
            this.queues(Stream.of(queues).map(c -> (QueueSummary)((QueueSummary.Builder)QueueSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueuesResponse> {
        public Builder queues(Collection<QueueSummary> var1);

        public Builder queues(QueueSummary ... var1);

        public Builder queues(Consumer<QueueSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

