/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSlurmConfiguration;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupStatus;
import software.amazon.awssdk.services.pcs.model.CustomLaunchTemplate;
import software.amazon.awssdk.services.pcs.model.ErrorInfo;
import software.amazon.awssdk.services.pcs.model.ErrorInfoListCopier;
import software.amazon.awssdk.services.pcs.model.InstanceConfig;
import software.amazon.awssdk.services.pcs.model.InstanceListCopier;
import software.amazon.awssdk.services.pcs.model.PurchaseOption;
import software.amazon.awssdk.services.pcs.model.ScalingConfiguration;
import software.amazon.awssdk.services.pcs.model.SpotOptions;
import software.amazon.awssdk.services.pcs.model.SubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeNodeGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeNodeGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ComputeNodeGroup.getter(ComputeNodeGroup::name)).setter(ComputeNodeGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ComputeNodeGroup.getter(ComputeNodeGroup::id)).setter(ComputeNodeGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ComputeNodeGroup.getter(ComputeNodeGroup::arn)).setter(ComputeNodeGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterId").getter(ComputeNodeGroup.getter(ComputeNodeGroup::clusterId)).setter(ComputeNodeGroup.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ComputeNodeGroup.getter(ComputeNodeGroup::createdAt)).setter(ComputeNodeGroup.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(ComputeNodeGroup.getter(ComputeNodeGroup::modifiedAt)).setter(ComputeNodeGroup.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ComputeNodeGroup.getter(ComputeNodeGroup::statusAsString)).setter(ComputeNodeGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amiId").getter(ComputeNodeGroup.getter(ComputeNodeGroup::amiId)).setter(ComputeNodeGroup.setter(Builder::amiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(ComputeNodeGroup.getter(ComputeNodeGroup::subnetIds)).setter(ComputeNodeGroup.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PURCHASE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("purchaseOption").getter(ComputeNodeGroup.getter(ComputeNodeGroup::purchaseOptionAsString)).setter(ComputeNodeGroup.setter(Builder::purchaseOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchaseOption").build()}).build();
    private static final SdkField<CustomLaunchTemplate> CUSTOM_LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customLaunchTemplate").getter(ComputeNodeGroup.getter(ComputeNodeGroup::customLaunchTemplate)).setter(ComputeNodeGroup.setter(Builder::customLaunchTemplate)).constructor(CustomLaunchTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLaunchTemplate").build()}).build();
    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamInstanceProfileArn").getter(ComputeNodeGroup.getter(ComputeNodeGroup::iamInstanceProfileArn)).setter(ComputeNodeGroup.setter(Builder::iamInstanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileArn").build()}).build();
    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingConfiguration").getter(ComputeNodeGroup.getter(ComputeNodeGroup::scalingConfiguration)).setter(ComputeNodeGroup.setter(Builder::scalingConfiguration)).constructor(ScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfiguration").build()}).build();
    private static final SdkField<List<InstanceConfig>> INSTANCE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceConfigs").getter(ComputeNodeGroup.getter(ComputeNodeGroup::instanceConfigs)).setter(ComputeNodeGroup.setter(Builder::instanceConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SpotOptions> SPOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spotOptions").getter(ComputeNodeGroup.getter(ComputeNodeGroup::spotOptions)).setter(ComputeNodeGroup.setter(Builder::spotOptions)).constructor(SpotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spotOptions").build()}).build();
    private static final SdkField<ComputeNodeGroupSlurmConfiguration> SLURM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("slurmConfiguration").getter(ComputeNodeGroup.getter(ComputeNodeGroup::slurmConfiguration)).setter(ComputeNodeGroup.setter(Builder::slurmConfiguration)).constructor(ComputeNodeGroupSlurmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build()}).build();
    private static final SdkField<List<ErrorInfo>> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorInfo").getter(ComputeNodeGroup.getter(ComputeNodeGroup::errorInfo)).setter(ComputeNodeGroup.setter(Builder::errorInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, ARN_FIELD, CLUSTER_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD, AMI_ID_FIELD, SUBNET_IDS_FIELD, PURCHASE_OPTION_FIELD, CUSTOM_LAUNCH_TEMPLATE_FIELD, IAM_INSTANCE_PROFILE_ARN_FIELD, SCALING_CONFIGURATION_FIELD, INSTANCE_CONFIGS_FIELD, SPOT_OPTIONS_FIELD, SLURM_CONFIGURATION_FIELD, ERROR_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputeNodeGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String arn;
    private final String clusterId;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String status;
    private final String amiId;
    private final List<String> subnetIds;
    private final String purchaseOption;
    private final CustomLaunchTemplate customLaunchTemplate;
    private final String iamInstanceProfileArn;
    private final ScalingConfiguration scalingConfiguration;
    private final List<InstanceConfig> instanceConfigs;
    private final SpotOptions spotOptions;
    private final ComputeNodeGroupSlurmConfiguration slurmConfiguration;
    private final List<ErrorInfo> errorInfo;

    private ComputeNodeGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.clusterId = builder.clusterId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.amiId = builder.amiId;
        this.subnetIds = builder.subnetIds;
        this.purchaseOption = builder.purchaseOption;
        this.customLaunchTemplate = builder.customLaunchTemplate;
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.instanceConfigs = builder.instanceConfigs;
        this.spotOptions = builder.spotOptions;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.errorInfo = builder.errorInfo;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final ComputeNodeGroupStatus status() {
        return ComputeNodeGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String amiId() {
        return this.amiId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final PurchaseOption purchaseOption() {
        return PurchaseOption.fromValue(this.purchaseOption);
    }

    public final String purchaseOptionAsString() {
        return this.purchaseOption;
    }

    public final CustomLaunchTemplate customLaunchTemplate() {
        return this.customLaunchTemplate;
    }

    public final String iamInstanceProfileArn() {
        return this.iamInstanceProfileArn;
    }

    public final ScalingConfiguration scalingConfiguration() {
        return this.scalingConfiguration;
    }

    public final boolean hasInstanceConfigs() {
        return this.instanceConfigs != null && !(this.instanceConfigs instanceof SdkAutoConstructList);
    }

    public final List<InstanceConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public final SpotOptions spotOptions() {
        return this.spotOptions;
    }

    public final ComputeNodeGroupSlurmConfiguration slurmConfiguration() {
        return this.slurmConfiguration;
    }

    public final boolean hasErrorInfo() {
        return this.errorInfo != null && !(this.errorInfo instanceof SdkAutoConstructList);
    }

    public final List<ErrorInfo> errorInfo() {
        return this.errorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceConfigs() ? this.instanceConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorInfo() ? this.errorInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeNodeGroup)) {
            return false;
        }
        ComputeNodeGroup other = (ComputeNodeGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.amiId(), other.amiId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.purchaseOptionAsString(), other.purchaseOptionAsString()) && Objects.equals(this.customLaunchTemplate(), other.customLaunchTemplate()) && Objects.equals(this.iamInstanceProfileArn(), other.iamInstanceProfileArn()) && Objects.equals(this.scalingConfiguration(), other.scalingConfiguration()) && this.hasInstanceConfigs() == other.hasInstanceConfigs() && Objects.equals(this.instanceConfigs(), other.instanceConfigs()) && Objects.equals(this.spotOptions(), other.spotOptions()) && Objects.equals(this.slurmConfiguration(), other.slurmConfiguration()) && this.hasErrorInfo() == other.hasErrorInfo() && Objects.equals(this.errorInfo(), other.errorInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeNodeGroup").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ClusterId", (Object)this.clusterId()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Status", (Object)this.statusAsString()).add("AmiId", (Object)this.amiId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("PurchaseOption", (Object)this.purchaseOptionAsString()).add("CustomLaunchTemplate", (Object)this.customLaunchTemplate()).add("IamInstanceProfileArn", (Object)this.iamInstanceProfileArn()).add("ScalingConfiguration", (Object)this.scalingConfiguration()).add("InstanceConfigs", this.hasInstanceConfigs() ? this.instanceConfigs() : null).add("SpotOptions", (Object)this.spotOptions()).add("SlurmConfiguration", (Object)this.slurmConfiguration()).add("ErrorInfo", this.hasErrorInfo() ? this.errorInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "amiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "purchaseOption": {
                return Optional.ofNullable(clazz.cast(this.purchaseOptionAsString()));
            }
            case "customLaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.customLaunchTemplate()));
            }
            case "iamInstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfileArn()));
            }
            case "scalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingConfiguration()));
            }
            case "instanceConfigs": {
                return Optional.ofNullable(clazz.cast(this.instanceConfigs()));
            }
            case "spotOptions": {
                return Optional.ofNullable(clazz.cast(this.spotOptions()));
            }
            case "slurmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.slurmConfiguration()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("amiId", AMI_ID_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("purchaseOption", PURCHASE_OPTION_FIELD);
        map.put("customLaunchTemplate", CUSTOM_LAUNCH_TEMPLATE_FIELD);
        map.put("iamInstanceProfileArn", IAM_INSTANCE_PROFILE_ARN_FIELD);
        map.put("scalingConfiguration", SCALING_CONFIGURATION_FIELD);
        map.put("instanceConfigs", INSTANCE_CONFIGS_FIELD);
        map.put("spotOptions", SPOT_OPTIONS_FIELD);
        map.put("slurmConfiguration", SLURM_CONFIGURATION_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeNodeGroup, T> g) {
        return obj -> g.apply((ComputeNodeGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String arn;
        private String clusterId;
        private Instant createdAt;
        private Instant modifiedAt;
        private String status;
        private String amiId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String purchaseOption;
        private CustomLaunchTemplate customLaunchTemplate;
        private String iamInstanceProfileArn;
        private ScalingConfiguration scalingConfiguration;
        private List<InstanceConfig> instanceConfigs = DefaultSdkAutoConstructList.getInstance();
        private SpotOptions spotOptions;
        private ComputeNodeGroupSlurmConfiguration slurmConfiguration;
        private List<ErrorInfo> errorInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeNodeGroup model) {
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.clusterId(model.clusterId);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.status(model.status);
            this.amiId(model.amiId);
            this.subnetIds(model.subnetIds);
            this.purchaseOption(model.purchaseOption);
            this.customLaunchTemplate(model.customLaunchTemplate);
            this.iamInstanceProfileArn(model.iamInstanceProfileArn);
            this.scalingConfiguration(model.scalingConfiguration);
            this.instanceConfigs(model.instanceConfigs);
            this.spotOptions(model.spotOptions);
            this.slurmConfiguration(model.slurmConfiguration);
            this.errorInfo(model.errorInfo);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComputeNodeGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getPurchaseOption() {
            return this.purchaseOption;
        }

        public final void setPurchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
        }

        @Override
        public final Builder purchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
            return this;
        }

        @Override
        public final Builder purchaseOption(PurchaseOption purchaseOption) {
            this.purchaseOption(purchaseOption == null ? null : purchaseOption.toString());
            return this;
        }

        public final CustomLaunchTemplate.Builder getCustomLaunchTemplate() {
            return this.customLaunchTemplate != null ? this.customLaunchTemplate.toBuilder() : null;
        }

        public final void setCustomLaunchTemplate(CustomLaunchTemplate.BuilderImpl customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate != null ? customLaunchTemplate.build() : null;
        }

        @Override
        public final Builder customLaunchTemplate(CustomLaunchTemplate customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate;
            return this;
        }

        public final String getIamInstanceProfileArn() {
            return this.iamInstanceProfileArn;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return this.scalingConfiguration != null ? this.scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final List<InstanceConfig.Builder> getInstanceConfigs() {
            List<InstanceConfig.Builder> result = InstanceListCopier.copyToBuilder(this.instanceConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceConfigs(Collection<InstanceConfig.BuilderImpl> instanceConfigs) {
            this.instanceConfigs = InstanceListCopier.copyFromBuilder(instanceConfigs);
        }

        @Override
        public final Builder instanceConfigs(Collection<InstanceConfig> instanceConfigs) {
            this.instanceConfigs = InstanceListCopier.copy(instanceConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConfigs(InstanceConfig ... instanceConfigs) {
            this.instanceConfigs(Arrays.asList(instanceConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConfigs(Consumer<InstanceConfig.Builder> ... instanceConfigs) {
            this.instanceConfigs(Stream.of(instanceConfigs).map(c -> (InstanceConfig)((InstanceConfig.Builder)InstanceConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SpotOptions.Builder getSpotOptions() {
            return this.spotOptions != null ? this.spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(SpotOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final ComputeNodeGroupSlurmConfiguration.Builder getSlurmConfiguration() {
            return this.slurmConfiguration != null ? this.slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(ComputeNodeGroupSlurmConfiguration.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(ComputeNodeGroupSlurmConfiguration slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final List<ErrorInfo.Builder> getErrorInfo() {
            List<ErrorInfo.Builder> result = ErrorInfoListCopier.copyToBuilder(this.errorInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorInfo(Collection<ErrorInfo.BuilderImpl> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copyFromBuilder(errorInfo);
        }

        @Override
        public final Builder errorInfo(Collection<ErrorInfo> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copy(errorInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(ErrorInfo ... errorInfo) {
            this.errorInfo(Arrays.asList(errorInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(Consumer<ErrorInfo.Builder> ... errorInfo) {
            this.errorInfo(Stream.of(errorInfo).map(c -> (ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ComputeNodeGroup build() {
            return new ComputeNodeGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeNodeGroup> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder clusterId(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(ComputeNodeGroupStatus var1);

        public Builder amiId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder purchaseOption(String var1);

        public Builder purchaseOption(PurchaseOption var1);

        public Builder customLaunchTemplate(CustomLaunchTemplate var1);

        default public Builder customLaunchTemplate(Consumer<CustomLaunchTemplate.Builder> customLaunchTemplate) {
            return this.customLaunchTemplate((CustomLaunchTemplate)((CustomLaunchTemplate.Builder)CustomLaunchTemplate.builder().applyMutation(customLaunchTemplate)).build());
        }

        public Builder iamInstanceProfileArn(String var1);

        public Builder scalingConfiguration(ScalingConfiguration var1);

        default public Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return this.scalingConfiguration((ScalingConfiguration)((ScalingConfiguration.Builder)ScalingConfiguration.builder().applyMutation(scalingConfiguration)).build());
        }

        public Builder instanceConfigs(Collection<InstanceConfig> var1);

        public Builder instanceConfigs(InstanceConfig ... var1);

        public Builder instanceConfigs(Consumer<InstanceConfig.Builder> ... var1);

        public Builder spotOptions(SpotOptions var1);

        default public Builder spotOptions(Consumer<SpotOptions.Builder> spotOptions) {
            return this.spotOptions((SpotOptions)((SpotOptions.Builder)SpotOptions.builder().applyMutation(spotOptions)).build());
        }

        public Builder slurmConfiguration(ComputeNodeGroupSlurmConfiguration var1);

        default public Builder slurmConfiguration(Consumer<ComputeNodeGroupSlurmConfiguration.Builder> slurmConfiguration) {
            return this.slurmConfiguration((ComputeNodeGroupSlurmConfiguration)((ComputeNodeGroupSlurmConfiguration.Builder)ComputeNodeGroupSlurmConfiguration.builder().applyMutation(slurmConfiguration)).build());
        }

        public Builder errorInfo(Collection<ErrorInfo> var1);

        public Builder errorInfo(ErrorInfo ... var1);

        public Builder errorInfo(Consumer<ErrorInfo.Builder> ... var1);
    }
}

