/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcaconnectorscep.PcaConnectorScepAsyncClient;
import software.amazon.awssdk.services.pcaconnectorscep.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcaconnectorscep.model.ChallengeMetadataSummary;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataResponse;

public class ListChallengeMetadataPublisher
implements SdkPublisher<ListChallengeMetadataResponse> {
    private final PcaConnectorScepAsyncClient client;
    private final ListChallengeMetadataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChallengeMetadataPublisher(PcaConnectorScepAsyncClient client, ListChallengeMetadataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChallengeMetadataPublisher(PcaConnectorScepAsyncClient client, ListChallengeMetadataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChallengeMetadataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChallengeMetadataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChallengeMetadataSummary> challenges() {
        Function<ListChallengeMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.challenges() != null) {
                return response.challenges().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChallengeMetadataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChallengeMetadataResponseFetcher
    implements AsyncPageFetcher<ListChallengeMetadataResponse> {
        private ListChallengeMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListChallengeMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChallengeMetadataResponse> nextPage(ListChallengeMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListChallengeMetadataPublisher.this.client.listChallengeMetadata(ListChallengeMetadataPublisher.this.firstRequest);
            }
            return ListChallengeMetadataPublisher.this.client.listChallengeMetadata((ListChallengeMetadataRequest)((Object)ListChallengeMetadataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

