/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateGroupAccessControlEntryRequest extends PcaConnectorAdRequest implements
        ToCopyableBuilder<GetTemplateGroupAccessControlEntryRequest.Builder, GetTemplateGroupAccessControlEntryRequest> {
    private static final SdkField<String> GROUP_SECURITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupSecurityIdentifier")
            .getter(getter(GetTemplateGroupAccessControlEntryRequest::groupSecurityIdentifier))
            .setter(setter(Builder::groupSecurityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GroupSecurityIdentifier").build())
            .build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(GetTemplateGroupAccessControlEntryRequest::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GROUP_SECURITY_IDENTIFIER_FIELD, TEMPLATE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupSecurityIdentifier;

    private final String templateArn;

    private GetTemplateGroupAccessControlEntryRequest(BuilderImpl builder) {
        super(builder);
        this.groupSecurityIdentifier = builder.groupSecurityIdentifier;
        this.templateArn = builder.templateArn;
    }

    /**
     * <p>
     * Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
     * </p>
     * 
     * @return Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
     */
    public final String groupSecurityIdentifier() {
        return groupSecurityIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
     * >CreateTemplate</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
     *         >CreateTemplate</a>.
     */
    public final String templateArn() {
        return templateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupSecurityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateGroupAccessControlEntryRequest)) {
            return false;
        }
        GetTemplateGroupAccessControlEntryRequest other = (GetTemplateGroupAccessControlEntryRequest) obj;
        return Objects.equals(groupSecurityIdentifier(), other.groupSecurityIdentifier())
                && Objects.equals(templateArn(), other.templateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemplateGroupAccessControlEntryRequest")
                .add("GroupSecurityIdentifier", groupSecurityIdentifier()).add("TemplateArn", templateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupSecurityIdentifier":
            return Optional.ofNullable(clazz.cast(groupSecurityIdentifier()));
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupSecurityIdentifier", GROUP_SECURITY_IDENTIFIER_FIELD);
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateGroupAccessControlEntryRequest, T> g) {
        return obj -> g.apply((GetTemplateGroupAccessControlEntryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcaConnectorAdRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTemplateGroupAccessControlEntryRequest> {
        /**
         * <p>
         * Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
         * </p>
         * 
         * @param groupSecurityIdentifier
         *        Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupSecurityIdentifier(String groupSecurityIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
         * >CreateTemplate</a>.
         * </p>
         * 
         * @param templateArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
         *        >CreateTemplate</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcaConnectorAdRequest.BuilderImpl implements Builder {
        private String groupSecurityIdentifier;

        private String templateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateGroupAccessControlEntryRequest model) {
            super(model);
            groupSecurityIdentifier(model.groupSecurityIdentifier);
            templateArn(model.templateArn);
        }

        public final String getGroupSecurityIdentifier() {
            return groupSecurityIdentifier;
        }

        public final void setGroupSecurityIdentifier(String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
        }

        @Override
        public final Builder groupSecurityIdentifier(String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
            return this;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateGroupAccessControlEntryRequest build() {
            return new GetTemplateGroupAccessControlEntryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
