/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pcaconnectorad.model.KeyUsagePropertyFlags;
import software.amazon.awssdk.services.pcaconnectorad.model.KeyUsagePropertyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyUsageProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyUsageProperty> {
    private static final SdkField<KeyUsagePropertyFlags> PROPERTY_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PropertyFlags").getter(KeyUsageProperty.getter(KeyUsageProperty::propertyFlags)).setter(KeyUsageProperty.setter(Builder::propertyFlags)).constructor(KeyUsagePropertyFlags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyFlags").build()}).build();
    private static final SdkField<String> PROPERTY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyType").getter(KeyUsageProperty.getter(KeyUsageProperty::propertyTypeAsString)).setter(KeyUsageProperty.setter(Builder::propertyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_FLAGS_FIELD, PROPERTY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeyUsageProperty.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KeyUsagePropertyFlags propertyFlags;
    private final String propertyType;
    private final Type type;

    private KeyUsageProperty(BuilderImpl builder) {
        this.propertyFlags = builder.propertyFlags;
        this.propertyType = builder.propertyType;
        this.type = builder.type;
    }

    public final KeyUsagePropertyFlags propertyFlags() {
        return this.propertyFlags;
    }

    public final KeyUsagePropertyType propertyType() {
        return KeyUsagePropertyType.fromValue(this.propertyType);
    }

    public final String propertyTypeAsString() {
        return this.propertyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsageProperty)) {
            return false;
        }
        KeyUsageProperty other = (KeyUsageProperty)obj;
        return Objects.equals(this.propertyFlags(), other.propertyFlags()) && Objects.equals(this.propertyTypeAsString(), other.propertyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KeyUsageProperty").add("PropertyFlags", (Object)this.propertyFlags()).add("PropertyType", (Object)this.propertyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyFlags": {
                return Optional.ofNullable(clazz.cast(this.propertyFlags()));
            }
            case "PropertyType": {
                return Optional.ofNullable(clazz.cast(this.propertyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public static KeyUsageProperty fromPropertyFlags(KeyUsagePropertyFlags propertyFlags) {
        return (KeyUsageProperty)KeyUsageProperty.builder().propertyFlags(propertyFlags).build();
    }

    public static KeyUsageProperty fromPropertyFlags(Consumer<KeyUsagePropertyFlags.Builder> propertyFlags) {
        KeyUsagePropertyFlags.Builder builder = KeyUsagePropertyFlags.builder();
        propertyFlags.accept(builder);
        return KeyUsageProperty.fromPropertyFlags((KeyUsagePropertyFlags)builder.build());
    }

    public static KeyUsageProperty fromPropertyType(String propertyType) {
        return (KeyUsageProperty)KeyUsageProperty.builder().propertyType(propertyType).build();
    }

    public static KeyUsageProperty fromPropertyType(KeyUsagePropertyType propertyType) {
        return (KeyUsageProperty)KeyUsageProperty.builder().propertyType(propertyType).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PropertyFlags", PROPERTY_FLAGS_FIELD);
        map.put("PropertyType", PROPERTY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyUsageProperty, T> g) {
        return obj -> g.apply((KeyUsageProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PROPERTY_FLAGS,
        PROPERTY_TYPE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private KeyUsagePropertyFlags propertyFlags;
        private String propertyType;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsageProperty model) {
            this.propertyFlags(model.propertyFlags);
            this.propertyType(model.propertyType);
        }

        public final KeyUsagePropertyFlags.Builder getPropertyFlags() {
            return this.propertyFlags != null ? this.propertyFlags.toBuilder() : null;
        }

        public final void setPropertyFlags(KeyUsagePropertyFlags.BuilderImpl propertyFlags) {
            KeyUsagePropertyFlags oldValue = this.propertyFlags;
            this.propertyFlags = propertyFlags != null ? propertyFlags.build() : null;
            this.handleUnionValueChange(Type.PROPERTY_FLAGS, oldValue, this.propertyFlags);
        }

        @Override
        public final Builder propertyFlags(KeyUsagePropertyFlags propertyFlags) {
            KeyUsagePropertyFlags oldValue = this.propertyFlags;
            this.propertyFlags = propertyFlags;
            this.handleUnionValueChange(Type.PROPERTY_FLAGS, oldValue, this.propertyFlags);
            return this;
        }

        public final String getPropertyType() {
            return this.propertyType;
        }

        public final void setPropertyType(String propertyType) {
            String oldValue = this.propertyType;
            this.propertyType = propertyType;
            this.handleUnionValueChange(Type.PROPERTY_TYPE, oldValue, this.propertyType);
        }

        @Override
        public final Builder propertyType(String propertyType) {
            String oldValue = this.propertyType;
            this.propertyType = propertyType;
            this.handleUnionValueChange(Type.PROPERTY_TYPE, oldValue, this.propertyType);
            return this;
        }

        @Override
        public final Builder propertyType(KeyUsagePropertyType propertyType) {
            this.propertyType(propertyType == null ? null : propertyType.toString());
            return this;
        }

        public KeyUsageProperty build() {
            return new KeyUsageProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyUsageProperty> {
        public Builder propertyFlags(KeyUsagePropertyFlags var1);

        default public Builder propertyFlags(Consumer<KeyUsagePropertyFlags.Builder> propertyFlags) {
            return this.propertyFlags((KeyUsagePropertyFlags)((KeyUsagePropertyFlags.Builder)KeyUsagePropertyFlags.builder().applyMutation(propertyFlags)).build());
        }

        public Builder propertyType(String var1);

        public Builder propertyType(KeyUsagePropertyType var1);
    }
}

