/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ServicePrincipalNameListCopier;
import software.amazon.awssdk.services.pcaconnectorad.model.ServicePrincipalNameSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServicePrincipalNamesResponse
extends PcaConnectorAdResponse
implements ToCopyableBuilder<Builder, ListServicePrincipalNamesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServicePrincipalNamesResponse.getter(ListServicePrincipalNamesResponse::nextToken)).setter(ListServicePrincipalNamesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ServicePrincipalNameSummary>> SERVICE_PRINCIPAL_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServicePrincipalNames").getter(ListServicePrincipalNamesResponse.getter(ListServicePrincipalNamesResponse::servicePrincipalNames)).setter(ListServicePrincipalNamesResponse.setter(Builder::servicePrincipalNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipalNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServicePrincipalNameSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICE_PRINCIPAL_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServicePrincipalNamesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ServicePrincipalNameSummary> servicePrincipalNames;

    private ListServicePrincipalNamesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.servicePrincipalNames = builder.servicePrincipalNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServicePrincipalNames() {
        return this.servicePrincipalNames != null && !(this.servicePrincipalNames instanceof SdkAutoConstructList);
    }

    public final List<ServicePrincipalNameSummary> servicePrincipalNames() {
        return this.servicePrincipalNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServicePrincipalNames() ? this.servicePrincipalNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicePrincipalNamesResponse)) {
            return false;
        }
        ListServicePrincipalNamesResponse other = (ListServicePrincipalNamesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServicePrincipalNames() == other.hasServicePrincipalNames() && Objects.equals(this.servicePrincipalNames(), other.servicePrincipalNames());
    }

    public final String toString() {
        return ToString.builder((String)"ListServicePrincipalNamesResponse").add("NextToken", (Object)this.nextToken()).add("ServicePrincipalNames", this.hasServicePrincipalNames() ? this.servicePrincipalNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ServicePrincipalNames": {
                return Optional.ofNullable(clazz.cast(this.servicePrincipalNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ServicePrincipalNames", SERVICE_PRINCIPAL_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServicePrincipalNamesResponse, T> g) {
        return obj -> g.apply((ListServicePrincipalNamesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorAdResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServicePrincipalNameSummary> servicePrincipalNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicePrincipalNamesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.servicePrincipalNames(model.servicePrincipalNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServicePrincipalNameSummary.Builder> getServicePrincipalNames() {
            List<ServicePrincipalNameSummary.Builder> result = ServicePrincipalNameListCopier.copyToBuilder(this.servicePrincipalNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServicePrincipalNames(Collection<ServicePrincipalNameSummary.BuilderImpl> servicePrincipalNames) {
            this.servicePrincipalNames = ServicePrincipalNameListCopier.copyFromBuilder(servicePrincipalNames);
        }

        @Override
        public final Builder servicePrincipalNames(Collection<ServicePrincipalNameSummary> servicePrincipalNames) {
            this.servicePrincipalNames = ServicePrincipalNameListCopier.copy(servicePrincipalNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servicePrincipalNames(ServicePrincipalNameSummary ... servicePrincipalNames) {
            this.servicePrincipalNames(Arrays.asList(servicePrincipalNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servicePrincipalNames(Consumer<ServicePrincipalNameSummary.Builder> ... servicePrincipalNames) {
            this.servicePrincipalNames(Stream.of(servicePrincipalNames).map(c -> (ServicePrincipalNameSummary)((ServicePrincipalNameSummary.Builder)ServicePrincipalNameSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServicePrincipalNamesResponse build() {
            return new ListServicePrincipalNamesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PcaConnectorAdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServicePrincipalNamesResponse> {
        public Builder nextToken(String var1);

        public Builder servicePrincipalNames(Collection<ServicePrincipalNameSummary> var1);

        public Builder servicePrincipalNames(ServicePrincipalNameSummary ... var1);

        public Builder servicePrincipalNames(Consumer<ServicePrincipalNameSummary.Builder> ... var1);
    }
}

