/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClientCompatibilityV3 {
    WINDOWS_SERVER_2008("WINDOWS_SERVER_2008"),
    WINDOWS_SERVER_2008_R2("WINDOWS_SERVER_2008_R2"),
    WINDOWS_SERVER_2012("WINDOWS_SERVER_2012"),
    WINDOWS_SERVER_2012_R2("WINDOWS_SERVER_2012_R2"),
    WINDOWS_SERVER_2016("WINDOWS_SERVER_2016"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClientCompatibilityV3> VALUE_MAP;
    private final String value;

    private ClientCompatibilityV3(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientCompatibilityV3 fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientCompatibilityV3> knownValues() {
        EnumSet<ClientCompatibilityV3> knownValues = EnumSet.allOf(ClientCompatibilityV3.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClientCompatibilityV3.class, ClientCompatibilityV3::toString);
    }
}

