/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes values used for Amex and Visa derivation methods.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisaAmexDerivationOutputs implements SdkPojo, Serializable,
        ToCopyableBuilder<VisaAmexDerivationOutputs.Builder, VisaAmexDerivationOutputs> {
    private static final SdkField<String> AUTHORIZATION_REQUEST_KEY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationRequestKeyArn")
            .getter(getter(VisaAmexDerivationOutputs::authorizationRequestKeyArn))
            .setter(setter(Builder::authorizationRequestKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationRequestKeyArn").build())
            .build();

    private static final SdkField<String> AUTHORIZATION_REQUEST_KEY_CHECK_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationRequestKeyCheckValue")
            .getter(getter(VisaAmexDerivationOutputs::authorizationRequestKeyCheckValue))
            .setter(setter(Builder::authorizationRequestKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationRequestKeyCheckValue")
                    .build()).build();

    private static final SdkField<String> CURRENT_PIN_PEK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentPinPekArn").getter(getter(VisaAmexDerivationOutputs::currentPinPekArn))
            .setter(setter(Builder::currentPinPekArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPinPekArn").build()).build();

    private static final SdkField<String> CURRENT_PIN_PEK_KEY_CHECK_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentPinPekKeyCheckValue")
            .getter(getter(VisaAmexDerivationOutputs::currentPinPekKeyCheckValue))
            .setter(setter(Builder::currentPinPekKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPinPekKeyCheckValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZATION_REQUEST_KEY_ARN_FIELD, AUTHORIZATION_REQUEST_KEY_CHECK_VALUE_FIELD, CURRENT_PIN_PEK_ARN_FIELD,
            CURRENT_PIN_PEK_KEY_CHECK_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authorizationRequestKeyArn;

    private final String authorizationRequestKeyCheckValue;

    private final String currentPinPekArn;

    private final String currentPinPekKeyCheckValue;

    private VisaAmexDerivationOutputs(BuilderImpl builder) {
        this.authorizationRequestKeyArn = builder.authorizationRequestKeyArn;
        this.authorizationRequestKeyCheckValue = builder.authorizationRequestKeyCheckValue;
        this.currentPinPekArn = builder.currentPinPekArn;
        this.currentPinPekKeyCheckValue = builder.currentPinPekKeyCheckValue;
    }

    /**
     * <p>
     * The <code>keyArn</code> of the issuer master key for cryptogram (IMK-AC) used by the operation.
     * </p>
     * 
     * @return The <code>keyArn</code> of the issuer master key for cryptogram (IMK-AC) used by the operation.
     */
    public final String authorizationRequestKeyArn() {
        return authorizationRequestKeyArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the issuer master key for cryptogram (IMK-AC) used by the operation.
     * </p>
     * 
     * @return The key check value (KCV) of the issuer master key for cryptogram (IMK-AC) used by the operation.
     */
    public final String authorizationRequestKeyCheckValue() {
        return authorizationRequestKeyCheckValue;
    }

    /**
     * <p>
     * The <code>keyArn</code> of the current PIN PEK.
     * </p>
     * 
     * @return The <code>keyArn</code> of the current PIN PEK.
     */
    public final String currentPinPekArn() {
        return currentPinPekArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the current PIN PEK.
     * </p>
     * 
     * @return The key check value (KCV) of the current PIN PEK.
     */
    public final String currentPinPekKeyCheckValue() {
        return currentPinPekKeyCheckValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationRequestKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationRequestKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(currentPinPekArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentPinPekKeyCheckValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisaAmexDerivationOutputs)) {
            return false;
        }
        VisaAmexDerivationOutputs other = (VisaAmexDerivationOutputs) obj;
        return Objects.equals(authorizationRequestKeyArn(), other.authorizationRequestKeyArn())
                && Objects.equals(authorizationRequestKeyCheckValue(), other.authorizationRequestKeyCheckValue())
                && Objects.equals(currentPinPekArn(), other.currentPinPekArn())
                && Objects.equals(currentPinPekKeyCheckValue(), other.currentPinPekKeyCheckValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VisaAmexDerivationOutputs").add("AuthorizationRequestKeyArn", authorizationRequestKeyArn())
                .add("AuthorizationRequestKeyCheckValue", authorizationRequestKeyCheckValue())
                .add("CurrentPinPekArn", currentPinPekArn()).add("CurrentPinPekKeyCheckValue", currentPinPekKeyCheckValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationRequestKeyArn":
            return Optional.ofNullable(clazz.cast(authorizationRequestKeyArn()));
        case "AuthorizationRequestKeyCheckValue":
            return Optional.ofNullable(clazz.cast(authorizationRequestKeyCheckValue()));
        case "CurrentPinPekArn":
            return Optional.ofNullable(clazz.cast(currentPinPekArn()));
        case "CurrentPinPekKeyCheckValue":
            return Optional.ofNullable(clazz.cast(currentPinPekKeyCheckValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizationRequestKeyArn", AUTHORIZATION_REQUEST_KEY_ARN_FIELD);
        map.put("AuthorizationRequestKeyCheckValue", AUTHORIZATION_REQUEST_KEY_CHECK_VALUE_FIELD);
        map.put("CurrentPinPekArn", CURRENT_PIN_PEK_ARN_FIELD);
        map.put("CurrentPinPekKeyCheckValue", CURRENT_PIN_PEK_KEY_CHECK_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VisaAmexDerivationOutputs, T> g) {
        return obj -> g.apply((VisaAmexDerivationOutputs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisaAmexDerivationOutputs> {
        /**
         * <p>
         * The <code>keyArn</code> of the issuer master key for cryptogram (IMK-AC) used by the operation.
         * </p>
         * 
         * @param authorizationRequestKeyArn
         *        The <code>keyArn</code> of the issuer master key for cryptogram (IMK-AC) used by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationRequestKeyArn(String authorizationRequestKeyArn);

        /**
         * <p>
         * The key check value (KCV) of the issuer master key for cryptogram (IMK-AC) used by the operation.
         * </p>
         * 
         * @param authorizationRequestKeyCheckValue
         *        The key check value (KCV) of the issuer master key for cryptogram (IMK-AC) used by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationRequestKeyCheckValue(String authorizationRequestKeyCheckValue);

        /**
         * <p>
         * The <code>keyArn</code> of the current PIN PEK.
         * </p>
         * 
         * @param currentPinPekArn
         *        The <code>keyArn</code> of the current PIN PEK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPinPekArn(String currentPinPekArn);

        /**
         * <p>
         * The key check value (KCV) of the current PIN PEK.
         * </p>
         * 
         * @param currentPinPekKeyCheckValue
         *        The key check value (KCV) of the current PIN PEK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPinPekKeyCheckValue(String currentPinPekKeyCheckValue);
    }

    static final class BuilderImpl implements Builder {
        private String authorizationRequestKeyArn;

        private String authorizationRequestKeyCheckValue;

        private String currentPinPekArn;

        private String currentPinPekKeyCheckValue;

        private BuilderImpl() {
        }

        private BuilderImpl(VisaAmexDerivationOutputs model) {
            authorizationRequestKeyArn(model.authorizationRequestKeyArn);
            authorizationRequestKeyCheckValue(model.authorizationRequestKeyCheckValue);
            currentPinPekArn(model.currentPinPekArn);
            currentPinPekKeyCheckValue(model.currentPinPekKeyCheckValue);
        }

        public final String getAuthorizationRequestKeyArn() {
            return authorizationRequestKeyArn;
        }

        public final void setAuthorizationRequestKeyArn(String authorizationRequestKeyArn) {
            this.authorizationRequestKeyArn = authorizationRequestKeyArn;
        }

        @Override
        public final Builder authorizationRequestKeyArn(String authorizationRequestKeyArn) {
            this.authorizationRequestKeyArn = authorizationRequestKeyArn;
            return this;
        }

        public final String getAuthorizationRequestKeyCheckValue() {
            return authorizationRequestKeyCheckValue;
        }

        public final void setAuthorizationRequestKeyCheckValue(String authorizationRequestKeyCheckValue) {
            this.authorizationRequestKeyCheckValue = authorizationRequestKeyCheckValue;
        }

        @Override
        public final Builder authorizationRequestKeyCheckValue(String authorizationRequestKeyCheckValue) {
            this.authorizationRequestKeyCheckValue = authorizationRequestKeyCheckValue;
            return this;
        }

        public final String getCurrentPinPekArn() {
            return currentPinPekArn;
        }

        public final void setCurrentPinPekArn(String currentPinPekArn) {
            this.currentPinPekArn = currentPinPekArn;
        }

        @Override
        public final Builder currentPinPekArn(String currentPinPekArn) {
            this.currentPinPekArn = currentPinPekArn;
            return this;
        }

        public final String getCurrentPinPekKeyCheckValue() {
            return currentPinPekKeyCheckValue;
        }

        public final void setCurrentPinPekKeyCheckValue(String currentPinPekKeyCheckValue) {
            this.currentPinPekKeyCheckValue = currentPinPekKeyCheckValue;
        }

        @Override
        public final Builder currentPinPekKeyCheckValue(String currentPinPekKeyCheckValue) {
            this.currentPinPekKeyCheckValue = currentPinPekKeyCheckValue;
            return this;
        }

        @Override
        public VisaAmexDerivationOutputs build() {
            return new VisaAmexDerivationOutputs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
