/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyPinDataResponse extends PaymentCryptographyDataResponse implements
        ToCopyableBuilder<VerifyPinDataResponse.Builder, VerifyPinDataResponse> {
    private static final SdkField<String> VERIFICATION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationKeyArn").getter(getter(VerifyPinDataResponse::verificationKeyArn))
            .setter(setter(Builder::verificationKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationKeyArn").build())
            .build();

    private static final SdkField<String> VERIFICATION_KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationKeyCheckValue").getter(getter(VerifyPinDataResponse::verificationKeyCheckValue))
            .setter(setter(Builder::verificationKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationKeyCheckValue").build())
            .build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(VerifyPinDataResponse::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyCheckValue").getter(getter(VerifyPinDataResponse::encryptionKeyCheckValue))
            .setter(setter(Builder::encryptionKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyCheckValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFICATION_KEY_ARN_FIELD,
            VERIFICATION_KEY_CHECK_VALUE_FIELD, ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_KEY_CHECK_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String verificationKeyArn;

    private final String verificationKeyCheckValue;

    private final String encryptionKeyArn;

    private final String encryptionKeyCheckValue;

    private VerifyPinDataResponse(BuilderImpl builder) {
        super(builder);
        this.verificationKeyArn = builder.verificationKeyArn;
        this.verificationKeyCheckValue = builder.verificationKeyCheckValue;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionKeyCheckValue = builder.encryptionKeyCheckValue;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the PIN encryption key that Amazon Web Services Payment Cryptography uses for PIN or
     * PIN Offset verification.
     * </p>
     * 
     * @return The <code>keyARN</code> of the PIN encryption key that Amazon Web Services Payment Cryptography uses for
     *         PIN or PIN Offset verification.
     */
    public final String verificationKeyArn() {
        return verificationKeyArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have
     * the same key or to detect that a key has changed.
     * </p>
     * <p>
     * Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
     * </p>
     * 
     * @return The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given
     *         key have the same key or to detect that a key has changed.</p>
     *         <p>
     *         Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
     */
    public final String verificationKeyCheckValue() {
        return verificationKeyCheckValue;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted pin block
     * generation.
     * </p>
     * 
     * @return The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted pin
     *         block generation.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have
     * the same key or to detect that a key has changed.
     * </p>
     * <p>
     * Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
     * </p>
     * 
     * @return The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given
     *         key have the same key or to detect that a key has changed.</p>
     *         <p>
     *         Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
     */
    public final String encryptionKeyCheckValue() {
        return encryptionKeyCheckValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verificationKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(verificationKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyCheckValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyPinDataResponse)) {
            return false;
        }
        VerifyPinDataResponse other = (VerifyPinDataResponse) obj;
        return Objects.equals(verificationKeyArn(), other.verificationKeyArn())
                && Objects.equals(verificationKeyCheckValue(), other.verificationKeyCheckValue())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(encryptionKeyCheckValue(), other.encryptionKeyCheckValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyPinDataResponse").add("VerificationKeyArn", verificationKeyArn())
                .add("VerificationKeyCheckValue", verificationKeyCheckValue()).add("EncryptionKeyArn", encryptionKeyArn())
                .add("EncryptionKeyCheckValue", encryptionKeyCheckValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerificationKeyArn":
            return Optional.ofNullable(clazz.cast(verificationKeyArn()));
        case "VerificationKeyCheckValue":
            return Optional.ofNullable(clazz.cast(verificationKeyCheckValue()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "EncryptionKeyCheckValue":
            return Optional.ofNullable(clazz.cast(encryptionKeyCheckValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerificationKeyArn", VERIFICATION_KEY_ARN_FIELD);
        map.put("VerificationKeyCheckValue", VERIFICATION_KEY_CHECK_VALUE_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("EncryptionKeyCheckValue", ENCRYPTION_KEY_CHECK_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifyPinDataResponse, T> g) {
        return obj -> g.apply((VerifyPinDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifyPinDataResponse> {
        /**
         * <p>
         * The <code>keyARN</code> of the PIN encryption key that Amazon Web Services Payment Cryptography uses for PIN
         * or PIN Offset verification.
         * </p>
         * 
         * @param verificationKeyArn
         *        The <code>keyARN</code> of the PIN encryption key that Amazon Web Services Payment Cryptography uses
         *        for PIN or PIN Offset verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationKeyArn(String verificationKeyArn);

        /**
         * <p>
         * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key
         * have the same key or to detect that a key has changed.
         * </p>
         * <p>
         * Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
         * </p>
         * 
         * @param verificationKeyCheckValue
         *        The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a
         *        given key have the same key or to detect that a key has changed.</p>
         *        <p>
         *        Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationKeyCheckValue(String verificationKeyCheckValue);

        /**
         * <p>
         * The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted pin block
         * generation.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted
         *        pin block generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key
         * have the same key or to detect that a key has changed.
         * </p>
         * <p>
         * Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
         * </p>
         * 
         * @param encryptionKeyCheckValue
         *        The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a
         *        given key have the same key or to detect that a key has changed.</p>
         *        <p>
         *        Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyCheckValue(String encryptionKeyCheckValue);
    }

    static final class BuilderImpl extends PaymentCryptographyDataResponse.BuilderImpl implements Builder {
        private String verificationKeyArn;

        private String verificationKeyCheckValue;

        private String encryptionKeyArn;

        private String encryptionKeyCheckValue;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyPinDataResponse model) {
            super(model);
            verificationKeyArn(model.verificationKeyArn);
            verificationKeyCheckValue(model.verificationKeyCheckValue);
            encryptionKeyArn(model.encryptionKeyArn);
            encryptionKeyCheckValue(model.encryptionKeyCheckValue);
        }

        public final String getVerificationKeyArn() {
            return verificationKeyArn;
        }

        public final void setVerificationKeyArn(String verificationKeyArn) {
            this.verificationKeyArn = verificationKeyArn;
        }

        @Override
        public final Builder verificationKeyArn(String verificationKeyArn) {
            this.verificationKeyArn = verificationKeyArn;
            return this;
        }

        public final String getVerificationKeyCheckValue() {
            return verificationKeyCheckValue;
        }

        public final void setVerificationKeyCheckValue(String verificationKeyCheckValue) {
            this.verificationKeyCheckValue = verificationKeyCheckValue;
        }

        @Override
        public final Builder verificationKeyCheckValue(String verificationKeyCheckValue) {
            this.verificationKeyCheckValue = verificationKeyCheckValue;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getEncryptionKeyCheckValue() {
            return encryptionKeyCheckValue;
        }

        public final void setEncryptionKeyCheckValue(String encryptionKeyCheckValue) {
            this.encryptionKeyCheckValue = encryptionKeyCheckValue;
        }

        @Override
        public final Builder encryptionKeyCheckValue(String encryptionKeyCheckValue) {
            this.encryptionKeyCheckValue = encryptionKeyCheckValue;
            return this;
        }

        @Override
        public VerifyPinDataResponse build() {
            return new VerifyPinDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
