/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslatePinDataResponse extends PaymentCryptographyDataResponse implements
        ToCopyableBuilder<TranslatePinDataResponse.Builder, TranslatePinDataResponse> {
    private static final SdkField<String> PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinBlock").getter(getter(TranslatePinDataResponse::pinBlock)).setter(setter(Builder::pinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlock").build()).build();

    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyArn")
            .getter(getter(TranslatePinDataResponse::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()).build();

    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCheckValue").getter(getter(TranslatePinDataResponse::keyCheckValue))
            .setter(setter(Builder::keyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIN_BLOCK_FIELD,
            KEY_ARN_FIELD, KEY_CHECK_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pinBlock;

    private final String keyArn;

    private final String keyCheckValue;

    private TranslatePinDataResponse(BuilderImpl builder) {
        super(builder);
        this.pinBlock = builder.pinBlock;
        this.keyArn = builder.keyArn;
        this.keyCheckValue = builder.keyCheckValue;
    }

    /**
     * <p>
     * The outgoing encrypted PIN block data after translation.
     * </p>
     * 
     * @return The outgoing encrypted PIN block data after translation.
     */
    public final String pinBlock() {
        return pinBlock;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to encrypt
     * outgoing PIN block data after translation.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to
     *         encrypt outgoing PIN block data after translation.
     */
    public final String keyArn() {
        return keyArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have
     * the same key or to detect that a key has changed.
     * </p>
     * <p>
     * Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
     * </p>
     * 
     * @return The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given
     *         key have the same key or to detect that a key has changed.</p>
     *         <p>
     *         Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
     */
    public final String keyCheckValue() {
        return keyCheckValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(keyCheckValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslatePinDataResponse)) {
            return false;
        }
        TranslatePinDataResponse other = (TranslatePinDataResponse) obj;
        return Objects.equals(pinBlock(), other.pinBlock()) && Objects.equals(keyArn(), other.keyArn())
                && Objects.equals(keyCheckValue(), other.keyCheckValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranslatePinDataResponse")
                .add("PinBlock", pinBlock() == null ? null : "*** Sensitive Data Redacted ***").add("KeyArn", keyArn())
                .add("KeyCheckValue", keyCheckValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PinBlock":
            return Optional.ofNullable(clazz.cast(pinBlock()));
        case "KeyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        case "KeyCheckValue":
            return Optional.ofNullable(clazz.cast(keyCheckValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PinBlock", PIN_BLOCK_FIELD);
        map.put("KeyArn", KEY_ARN_FIELD);
        map.put("KeyCheckValue", KEY_CHECK_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranslatePinDataResponse, T> g) {
        return obj -> g.apply((TranslatePinDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, TranslatePinDataResponse> {
        /**
         * <p>
         * The outgoing encrypted PIN block data after translation.
         * </p>
         * 
         * @param pinBlock
         *        The outgoing encrypted PIN block data after translation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinBlock(String pinBlock);

        /**
         * <p>
         * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to encrypt
         * outgoing PIN block data after translation.
         * </p>
         * 
         * @param keyArn
         *        The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to
         *        encrypt outgoing PIN block data after translation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);

        /**
         * <p>
         * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key
         * have the same key or to detect that a key has changed.
         * </p>
         * <p>
         * Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
         * </p>
         * 
         * @param keyCheckValue
         *        The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a
         *        given key have the same key or to detect that a key has changed.</p>
         *        <p>
         *        Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCheckValue(String keyCheckValue);
    }

    static final class BuilderImpl extends PaymentCryptographyDataResponse.BuilderImpl implements Builder {
        private String pinBlock;

        private String keyArn;

        private String keyCheckValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslatePinDataResponse model) {
            super(model);
            pinBlock(model.pinBlock);
            keyArn(model.keyArn);
            keyCheckValue(model.keyCheckValue);
        }

        public final String getPinBlock() {
            return pinBlock;
        }

        public final void setPinBlock(String pinBlock) {
            this.pinBlock = pinBlock;
        }

        @Override
        public final Builder pinBlock(String pinBlock) {
            this.pinBlock = pinBlock;
            return this;
        }

        public final String getKeyArn() {
            return keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyCheckValue() {
            return keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        @Override
        public TranslatePinDataResponse build() {
            return new TranslatePinDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
