/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters to derive session key for Visa payment card for ARQC verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionKeyVisa implements SdkPojo, Serializable, ToCopyableBuilder<SessionKeyVisa.Builder, SessionKeyVisa> {
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(SessionKeyVisa::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PanSequenceNumber").getter(getter(SessionKeyVisa::panSequenceNumber))
            .setter(setter(Builder::panSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_ACCOUNT_NUMBER_FIELD,
            PAN_SEQUENCE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String primaryAccountNumber;

    private final String panSequenceNumber;

    private SessionKeyVisa(BuilderImpl builder) {
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.panSequenceNumber = builder.panSequenceNumber;
    }

    /**
     * <p>
     * The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or debit
     * card and associates the card to a specific account holder.
     * </p>
     * 
     * @return The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or
     *         debit card and associates the card to a specific account holder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */
    public final String panSequenceNumber() {
        return panSequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(panSequenceNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeyVisa)) {
            return false;
        }
        SessionKeyVisa other = (SessionKeyVisa) obj;
        return Objects.equals(primaryAccountNumber(), other.primaryAccountNumber())
                && Objects.equals(panSequenceNumber(), other.panSequenceNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionKeyVisa")
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PanSequenceNumber", panSequenceNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        case "PanSequenceNumber":
            return Optional.ofNullable(clazz.cast(panSequenceNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryAccountNumber", PRIMARY_ACCOUNT_NUMBER_FIELD);
        map.put("PanSequenceNumber", PAN_SEQUENCE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionKeyVisa, T> g) {
        return obj -> g.apply((SessionKeyVisa) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionKeyVisa> {
        /**
         * <p>
         * The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or
         * debit card and associates the card to a specific account holder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit
         *        or debit card and associates the card to a specific account holder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        /**
         * <p>
         * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * </p>
         * 
         * @param panSequenceNumber
         *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panSequenceNumber(String panSequenceNumber);
    }

    static final class BuilderImpl implements Builder {
        private String primaryAccountNumber;

        private String panSequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeyVisa model) {
            primaryAccountNumber(model.primaryAccountNumber);
            panSequenceNumber(model.panSequenceNumber);
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPanSequenceNumber() {
            return panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        @Override
        public SessionKeyVisa build() {
            return new SessionKeyVisa(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
