/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required for PIN data verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PinVerificationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<PinVerificationAttributes.Builder, PinVerificationAttributes> {
    private static final SdkField<VisaPinVerification> VISA_PIN_FIELD = SdkField
            .<VisaPinVerification> builder(MarshallingType.SDK_POJO).memberName("VisaPin")
            .getter(getter(PinVerificationAttributes::visaPin)).setter(setter(Builder::visaPin))
            .constructor(VisaPinVerification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisaPin").build()).build();

    private static final SdkField<Ibm3624PinVerification> IBM3624_PIN_FIELD = SdkField
            .<Ibm3624PinVerification> builder(MarshallingType.SDK_POJO).memberName("Ibm3624Pin")
            .getter(getter(PinVerificationAttributes::ibm3624Pin)).setter(setter(Builder::ibm3624Pin))
            .constructor(Ibm3624PinVerification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624Pin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISA_PIN_FIELD,
            IBM3624_PIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VisaPinVerification visaPin;

    private final Ibm3624PinVerification ibm3624Pin;

    private final Type type;

    private PinVerificationAttributes(BuilderImpl builder) {
        this.visaPin = builder.visaPin;
        this.ibm3624Pin = builder.ibm3624Pin;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameters that are required to generate or verify Visa PIN.
     * </p>
     * 
     * @return Parameters that are required to generate or verify Visa PIN.
     */
    public final VisaPinVerification visaPin() {
        return visaPin;
    }

    /**
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN.
     * </p>
     * 
     * @return Parameters that are required to generate or verify Ibm3624 PIN.
     */
    public final Ibm3624PinVerification ibm3624Pin() {
        return ibm3624Pin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visaPin());
        hashCode = 31 * hashCode + Objects.hashCode(ibm3624Pin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PinVerificationAttributes)) {
            return false;
        }
        PinVerificationAttributes other = (PinVerificationAttributes) obj;
        return Objects.equals(visaPin(), other.visaPin()) && Objects.equals(ibm3624Pin(), other.ibm3624Pin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PinVerificationAttributes").add("VisaPin", visaPin()).add("Ibm3624Pin", ibm3624Pin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisaPin":
            return Optional.ofNullable(clazz.cast(visaPin()));
        case "Ibm3624Pin":
            return Optional.ofNullable(clazz.cast(ibm3624Pin()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #visaPin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Visa PIN.
     * </p>
     * 
     * @param visaPin
     *        Parameters that are required to generate or verify Visa PIN.
     */
    public static PinVerificationAttributes fromVisaPin(VisaPinVerification visaPin) {
        return builder().visaPin(visaPin).build();
    }

    /**
     * Create an instance of this class with {@link #visaPin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Visa PIN.
     * </p>
     * 
     * @param visaPin
     *        Parameters that are required to generate or verify Visa PIN.
     */
    public static PinVerificationAttributes fromVisaPin(Consumer<VisaPinVerification.Builder> visaPin) {
        VisaPinVerification.Builder builder = VisaPinVerification.builder();
        visaPin.accept(builder);
        return fromVisaPin(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ibm3624Pin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN.
     * </p>
     * 
     * @param ibm3624Pin
     *        Parameters that are required to generate or verify Ibm3624 PIN.
     */
    public static PinVerificationAttributes fromIbm3624Pin(Ibm3624PinVerification ibm3624Pin) {
        return builder().ibm3624Pin(ibm3624Pin).build();
    }

    /**
     * Create an instance of this class with {@link #ibm3624Pin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN.
     * </p>
     * 
     * @param ibm3624Pin
     *        Parameters that are required to generate or verify Ibm3624 PIN.
     */
    public static PinVerificationAttributes fromIbm3624Pin(Consumer<Ibm3624PinVerification.Builder> ibm3624Pin) {
        Ibm3624PinVerification.Builder builder = Ibm3624PinVerification.builder();
        ibm3624Pin.accept(builder);
        return fromIbm3624Pin(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VisaPin", VISA_PIN_FIELD);
        map.put("Ibm3624Pin", IBM3624_PIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PinVerificationAttributes, T> g) {
        return obj -> g.apply((PinVerificationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PinVerificationAttributes> {
        /**
         * <p>
         * Parameters that are required to generate or verify Visa PIN.
         * </p>
         * 
         * @param visaPin
         *        Parameters that are required to generate or verify Visa PIN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visaPin(VisaPinVerification visaPin);

        /**
         * <p>
         * Parameters that are required to generate or verify Visa PIN.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisaPinVerification.Builder} avoiding the
         * need to create one manually via {@link VisaPinVerification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisaPinVerification.Builder#build()} is called immediately and
         * its result is passed to {@link #visaPin(VisaPinVerification)}.
         * 
         * @param visaPin
         *        a consumer that will call methods on {@link VisaPinVerification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visaPin(VisaPinVerification)
         */
        default Builder visaPin(Consumer<VisaPinVerification.Builder> visaPin) {
            return visaPin(VisaPinVerification.builder().applyMutation(visaPin).build());
        }

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 PIN.
         * </p>
         * 
         * @param ibm3624Pin
         *        Parameters that are required to generate or verify Ibm3624 PIN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ibm3624Pin(Ibm3624PinVerification ibm3624Pin);

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 PIN.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ibm3624PinVerification.Builder} avoiding
         * the need to create one manually via {@link Ibm3624PinVerification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ibm3624PinVerification.Builder#build()} is called immediately and
         * its result is passed to {@link #ibm3624Pin(Ibm3624PinVerification)}.
         * 
         * @param ibm3624Pin
         *        a consumer that will call methods on {@link Ibm3624PinVerification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ibm3624Pin(Ibm3624PinVerification)
         */
        default Builder ibm3624Pin(Consumer<Ibm3624PinVerification.Builder> ibm3624Pin) {
            return ibm3624Pin(Ibm3624PinVerification.builder().applyMutation(ibm3624Pin).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VisaPinVerification visaPin;

        private Ibm3624PinVerification ibm3624Pin;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PinVerificationAttributes model) {
            visaPin(model.visaPin);
            ibm3624Pin(model.ibm3624Pin);
        }

        public final VisaPinVerification.Builder getVisaPin() {
            return visaPin != null ? visaPin.toBuilder() : null;
        }

        public final void setVisaPin(VisaPinVerification.BuilderImpl visaPin) {
            Object oldValue = this.visaPin;
            this.visaPin = visaPin != null ? visaPin.build() : null;
            handleUnionValueChange(Type.VISA_PIN, oldValue, this.visaPin);
        }

        @Override
        public final Builder visaPin(VisaPinVerification visaPin) {
            Object oldValue = this.visaPin;
            this.visaPin = visaPin;
            handleUnionValueChange(Type.VISA_PIN, oldValue, this.visaPin);
            return this;
        }

        public final Ibm3624PinVerification.Builder getIbm3624Pin() {
            return ibm3624Pin != null ? ibm3624Pin.toBuilder() : null;
        }

        public final void setIbm3624Pin(Ibm3624PinVerification.BuilderImpl ibm3624Pin) {
            Object oldValue = this.ibm3624Pin;
            this.ibm3624Pin = ibm3624Pin != null ? ibm3624Pin.build() : null;
            handleUnionValueChange(Type.IBM3624_PIN, oldValue, this.ibm3624Pin);
        }

        @Override
        public final Builder ibm3624Pin(Ibm3624PinVerification ibm3624Pin) {
            Object oldValue = this.ibm3624Pin;
            this.ibm3624Pin = ibm3624Pin;
            handleUnionValueChange(Type.IBM3624_PIN, oldValue, this.ibm3624Pin);
            return this;
        }

        @Override
        public PinVerificationAttributes build() {
            return new PinVerificationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PinVerificationAttributes#type()
     */
    public enum Type {
        VISA_PIN,

        IBM3624_PIN,

        UNKNOWN_TO_SDK_VERSION
    }
}
