/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information of the incoming WrappedKeyBlock containing the transaction key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncomingKeyMaterial implements SdkPojo, Serializable,
        ToCopyableBuilder<IncomingKeyMaterial.Builder, IncomingKeyMaterial> {
    private static final SdkField<IncomingDiffieHellmanTr31KeyBlock> DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD = SdkField
            .<IncomingDiffieHellmanTr31KeyBlock> builder(MarshallingType.SDK_POJO).memberName("DiffieHellmanTr31KeyBlock")
            .getter(getter(IncomingKeyMaterial::diffieHellmanTr31KeyBlock)).setter(setter(Builder::diffieHellmanTr31KeyBlock))
            .constructor(IncomingDiffieHellmanTr31KeyBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiffieHellmanTr31KeyBlock").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IncomingDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock;

    private final Type type;

    private IncomingKeyMaterial(BuilderImpl builder) {
        this.diffieHellmanTr31KeyBlock = builder.diffieHellmanTr31KeyBlock;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied
     * key.
     * </p>
     * 
     * @return Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH
     *         dervied key.
     */
    public final IncomingDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock() {
        return diffieHellmanTr31KeyBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diffieHellmanTr31KeyBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncomingKeyMaterial)) {
            return false;
        }
        IncomingKeyMaterial other = (IncomingKeyMaterial) obj;
        return Objects.equals(diffieHellmanTr31KeyBlock(), other.diffieHellmanTr31KeyBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncomingKeyMaterial").add("DiffieHellmanTr31KeyBlock", diffieHellmanTr31KeyBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiffieHellmanTr31KeyBlock":
            return Optional.ofNullable(clazz.cast(diffieHellmanTr31KeyBlock()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #diffieHellmanTr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied
     * key.
     * </p>
     * 
     * @param diffieHellmanTr31KeyBlock
     *        Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH
     *        dervied key.
     */
    public static IncomingKeyMaterial fromDiffieHellmanTr31KeyBlock(IncomingDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock) {
        return builder().diffieHellmanTr31KeyBlock(diffieHellmanTr31KeyBlock).build();
    }

    /**
     * Create an instance of this class with {@link #diffieHellmanTr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied
     * key.
     * </p>
     * 
     * @param diffieHellmanTr31KeyBlock
     *        Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH
     *        dervied key.
     */
    public static IncomingKeyMaterial fromDiffieHellmanTr31KeyBlock(
            Consumer<IncomingDiffieHellmanTr31KeyBlock.Builder> diffieHellmanTr31KeyBlock) {
        IncomingDiffieHellmanTr31KeyBlock.Builder builder = IncomingDiffieHellmanTr31KeyBlock.builder();
        diffieHellmanTr31KeyBlock.accept(builder);
        return fromDiffieHellmanTr31KeyBlock(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiffieHellmanTr31KeyBlock", DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncomingKeyMaterial, T> g) {
        return obj -> g.apply((IncomingKeyMaterial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncomingKeyMaterial> {
        /**
         * <p>
         * Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied
         * key.
         * </p>
         * 
         * @param diffieHellmanTr31KeyBlock
         *        Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH
         *        dervied key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diffieHellmanTr31KeyBlock(IncomingDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock);

        /**
         * <p>
         * Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied
         * key.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IncomingDiffieHellmanTr31KeyBlock.Builder} avoiding the need to create one manually via
         * {@link IncomingDiffieHellmanTr31KeyBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncomingDiffieHellmanTr31KeyBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #diffieHellmanTr31KeyBlock(IncomingDiffieHellmanTr31KeyBlock)}.
         * 
         * @param diffieHellmanTr31KeyBlock
         *        a consumer that will call methods on {@link IncomingDiffieHellmanTr31KeyBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diffieHellmanTr31KeyBlock(IncomingDiffieHellmanTr31KeyBlock)
         */
        default Builder diffieHellmanTr31KeyBlock(Consumer<IncomingDiffieHellmanTr31KeyBlock.Builder> diffieHellmanTr31KeyBlock) {
            return diffieHellmanTr31KeyBlock(IncomingDiffieHellmanTr31KeyBlock.builder().applyMutation(diffieHellmanTr31KeyBlock)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IncomingDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IncomingKeyMaterial model) {
            diffieHellmanTr31KeyBlock(model.diffieHellmanTr31KeyBlock);
        }

        public final IncomingDiffieHellmanTr31KeyBlock.Builder getDiffieHellmanTr31KeyBlock() {
            return diffieHellmanTr31KeyBlock != null ? diffieHellmanTr31KeyBlock.toBuilder() : null;
        }

        public final void setDiffieHellmanTr31KeyBlock(IncomingDiffieHellmanTr31KeyBlock.BuilderImpl diffieHellmanTr31KeyBlock) {
            Object oldValue = this.diffieHellmanTr31KeyBlock;
            this.diffieHellmanTr31KeyBlock = diffieHellmanTr31KeyBlock != null ? diffieHellmanTr31KeyBlock.build() : null;
            handleUnionValueChange(Type.DIFFIE_HELLMAN_TR31_KEY_BLOCK, oldValue, this.diffieHellmanTr31KeyBlock);
        }

        @Override
        public final Builder diffieHellmanTr31KeyBlock(IncomingDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock) {
            Object oldValue = this.diffieHellmanTr31KeyBlock;
            this.diffieHellmanTr31KeyBlock = diffieHellmanTr31KeyBlock;
            handleUnionValueChange(Type.DIFFIE_HELLMAN_TR31_KEY_BLOCK, oldValue, this.diffieHellmanTr31KeyBlock);
            return this;
        }

        @Override
        public IncomingKeyMaterial build() {
            return new IncomingKeyMaterial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IncomingKeyMaterial#type()
     */
    public enum Type {
        DIFFIE_HELLMAN_TR31_KEY_BLOCK,

        UNKNOWN_TO_SDK_VERSION
    }
}
