/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateMacEmvPinChangeResponse extends PaymentCryptographyDataResponse implements
        ToCopyableBuilder<GenerateMacEmvPinChangeResponse.Builder, GenerateMacEmvPinChangeResponse> {
    private static final SdkField<String> NEW_PIN_PEK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewPinPekArn").getter(getter(GenerateMacEmvPinChangeResponse::newPinPekArn))
            .setter(setter(Builder::newPinPekArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPinPekArn").build()).build();

    private static final SdkField<String> SECURE_MESSAGING_INTEGRITY_KEY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecureMessagingIntegrityKeyArn")
            .getter(getter(GenerateMacEmvPinChangeResponse::secureMessagingIntegrityKeyArn))
            .setter(setter(Builder::secureMessagingIntegrityKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecureMessagingIntegrityKeyArn")
                    .build()).build();

    private static final SdkField<String> SECURE_MESSAGING_CONFIDENTIALITY_KEY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecureMessagingConfidentialityKeyArn")
            .getter(getter(GenerateMacEmvPinChangeResponse::secureMessagingConfidentialityKeyArn))
            .setter(setter(Builder::secureMessagingConfidentialityKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecureMessagingConfidentialityKeyArn").build()).build();

    private static final SdkField<String> MAC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mac")
            .getter(getter(GenerateMacEmvPinChangeResponse::mac)).setter(setter(Builder::mac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mac").build()).build();

    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptedPinBlock").getter(getter(GenerateMacEmvPinChangeResponse::encryptedPinBlock))
            .setter(setter(Builder::encryptedPinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()).build();

    private static final SdkField<String> NEW_PIN_PEK_KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewPinPekKeyCheckValue").getter(getter(GenerateMacEmvPinChangeResponse::newPinPekKeyCheckValue))
            .setter(setter(Builder::newPinPekKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPinPekKeyCheckValue").build())
            .build();

    private static final SdkField<String> SECURE_MESSAGING_INTEGRITY_KEY_CHECK_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecureMessagingIntegrityKeyCheckValue")
            .getter(getter(GenerateMacEmvPinChangeResponse::secureMessagingIntegrityKeyCheckValue))
            .setter(setter(Builder::secureMessagingIntegrityKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecureMessagingIntegrityKeyCheckValue").build()).build();

    private static final SdkField<String> SECURE_MESSAGING_CONFIDENTIALITY_KEY_CHECK_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecureMessagingConfidentialityKeyCheckValue")
            .getter(getter(GenerateMacEmvPinChangeResponse::secureMessagingConfidentialityKeyCheckValue))
            .setter(setter(Builder::secureMessagingConfidentialityKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecureMessagingConfidentialityKeyCheckValue").build()).build();

    private static final SdkField<VisaAmexDerivationOutputs> VISA_AMEX_DERIVATION_OUTPUTS_FIELD = SdkField
            .<VisaAmexDerivationOutputs> builder(MarshallingType.SDK_POJO).memberName("VisaAmexDerivationOutputs")
            .getter(getter(GenerateMacEmvPinChangeResponse::visaAmexDerivationOutputs))
            .setter(setter(Builder::visaAmexDerivationOutputs)).constructor(VisaAmexDerivationOutputs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisaAmexDerivationOutputs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_PIN_PEK_ARN_FIELD,
            SECURE_MESSAGING_INTEGRITY_KEY_ARN_FIELD, SECURE_MESSAGING_CONFIDENTIALITY_KEY_ARN_FIELD, MAC_FIELD,
            ENCRYPTED_PIN_BLOCK_FIELD, NEW_PIN_PEK_KEY_CHECK_VALUE_FIELD, SECURE_MESSAGING_INTEGRITY_KEY_CHECK_VALUE_FIELD,
            SECURE_MESSAGING_CONFIDENTIALITY_KEY_CHECK_VALUE_FIELD, VISA_AMEX_DERIVATION_OUTPUTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String newPinPekArn;

    private final String secureMessagingIntegrityKeyArn;

    private final String secureMessagingConfidentialityKeyArn;

    private final String mac;

    private final String encryptedPinBlock;

    private final String newPinPekKeyCheckValue;

    private final String secureMessagingIntegrityKeyCheckValue;

    private final String secureMessagingConfidentialityKeyCheckValue;

    private final VisaAmexDerivationOutputs visaAmexDerivationOutputs;

    private GenerateMacEmvPinChangeResponse(BuilderImpl builder) {
        super(builder);
        this.newPinPekArn = builder.newPinPekArn;
        this.secureMessagingIntegrityKeyArn = builder.secureMessagingIntegrityKeyArn;
        this.secureMessagingConfidentialityKeyArn = builder.secureMessagingConfidentialityKeyArn;
        this.mac = builder.mac;
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.newPinPekKeyCheckValue = builder.newPinPekKeyCheckValue;
        this.secureMessagingIntegrityKeyCheckValue = builder.secureMessagingIntegrityKeyCheckValue;
        this.secureMessagingConfidentialityKeyCheckValue = builder.secureMessagingConfidentialityKeyCheckValue;
        this.visaAmexDerivationOutputs = builder.visaAmexDerivationOutputs;
    }

    /**
     * <p>
     * Returns the <code>keyArn</code> of the PEK protecting the incoming new encrypted PIN block.
     * </p>
     * 
     * @return Returns the <code>keyArn</code> of the PEK protecting the incoming new encrypted PIN block.
     */
    public final String newPinPekArn() {
        return newPinPekArn;
    }

    /**
     * <p>
     * Returns the <code>keyArn</code> of the IMK-SMI used by the operation.
     * </p>
     * 
     * @return Returns the <code>keyArn</code> of the IMK-SMI used by the operation.
     */
    public final String secureMessagingIntegrityKeyArn() {
        return secureMessagingIntegrityKeyArn;
    }

    /**
     * <p>
     * Returns the <code>keyArn</code> of the IMK-SMC used by the operation.
     * </p>
     * 
     * @return Returns the <code>keyArn</code> of the IMK-SMC used by the operation.
     */
    public final String secureMessagingConfidentialityKeyArn() {
        return secureMessagingConfidentialityKeyArn;
    }

    /**
     * <p>
     * Returns the mac of the issuer script containing message data and appended target encrypted pin block in ISO2
     * format.
     * </p>
     * 
     * @return Returns the mac of the issuer script containing message data and appended target encrypted pin block in
     *         ISO2 format.
     */
    public final String mac() {
        return mac;
    }

    /**
     * <p>
     * Returns the incoming new encrpted PIN block.
     * </p>
     * 
     * @return Returns the incoming new encrpted PIN block.
     */
    public final String encryptedPinBlock() {
        return encryptedPinBlock;
    }

    /**
     * <p>
     * The key check value (KCV) of the PEK uprotecting the incoming new encrypted PIN block.
     * </p>
     * 
     * @return The key check value (KCV) of the PEK uprotecting the incoming new encrypted PIN block.
     */
    public final String newPinPekKeyCheckValue() {
        return newPinPekKeyCheckValue;
    }

    /**
     * <p>
     * The key check value (KCV) of the SMI issuer master key used by the operation.
     * </p>
     * 
     * @return The key check value (KCV) of the SMI issuer master key used by the operation.
     */
    public final String secureMessagingIntegrityKeyCheckValue() {
        return secureMessagingIntegrityKeyCheckValue;
    }

    /**
     * <p>
     * The key check value (KCV) of the SMC issuer master key used by the operation.
     * </p>
     * 
     * @return The key check value (KCV) of the SMC issuer master key used by the operation.
     */
    public final String secureMessagingConfidentialityKeyCheckValue() {
        return secureMessagingConfidentialityKeyCheckValue;
    }

    /**
     * <p>
     * The attribute values used for Amex and Visa derivation methods.
     * </p>
     * 
     * @return The attribute values used for Amex and Visa derivation methods.
     */
    public final VisaAmexDerivationOutputs visaAmexDerivationOutputs() {
        return visaAmexDerivationOutputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(newPinPekArn());
        hashCode = 31 * hashCode + Objects.hashCode(secureMessagingIntegrityKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(secureMessagingConfidentialityKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(mac());
        hashCode = 31 * hashCode + Objects.hashCode(encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(newPinPekKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(secureMessagingIntegrityKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(secureMessagingConfidentialityKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(visaAmexDerivationOutputs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMacEmvPinChangeResponse)) {
            return false;
        }
        GenerateMacEmvPinChangeResponse other = (GenerateMacEmvPinChangeResponse) obj;
        return Objects.equals(newPinPekArn(), other.newPinPekArn())
                && Objects.equals(secureMessagingIntegrityKeyArn(), other.secureMessagingIntegrityKeyArn())
                && Objects.equals(secureMessagingConfidentialityKeyArn(), other.secureMessagingConfidentialityKeyArn())
                && Objects.equals(mac(), other.mac())
                && Objects.equals(encryptedPinBlock(), other.encryptedPinBlock())
                && Objects.equals(newPinPekKeyCheckValue(), other.newPinPekKeyCheckValue())
                && Objects.equals(secureMessagingIntegrityKeyCheckValue(), other.secureMessagingIntegrityKeyCheckValue())
                && Objects.equals(secureMessagingConfidentialityKeyCheckValue(),
                        other.secureMessagingConfidentialityKeyCheckValue())
                && Objects.equals(visaAmexDerivationOutputs(), other.visaAmexDerivationOutputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateMacEmvPinChangeResponse").add("NewPinPekArn", newPinPekArn())
                .add("SecureMessagingIntegrityKeyArn", secureMessagingIntegrityKeyArn())
                .add("SecureMessagingConfidentialityKeyArn", secureMessagingConfidentialityKeyArn())
                .add("Mac", mac() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EncryptedPinBlock", encryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NewPinPekKeyCheckValue", newPinPekKeyCheckValue())
                .add("SecureMessagingIntegrityKeyCheckValue", secureMessagingIntegrityKeyCheckValue())
                .add("SecureMessagingConfidentialityKeyCheckValue", secureMessagingConfidentialityKeyCheckValue())
                .add("VisaAmexDerivationOutputs", visaAmexDerivationOutputs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NewPinPekArn":
            return Optional.ofNullable(clazz.cast(newPinPekArn()));
        case "SecureMessagingIntegrityKeyArn":
            return Optional.ofNullable(clazz.cast(secureMessagingIntegrityKeyArn()));
        case "SecureMessagingConfidentialityKeyArn":
            return Optional.ofNullable(clazz.cast(secureMessagingConfidentialityKeyArn()));
        case "Mac":
            return Optional.ofNullable(clazz.cast(mac()));
        case "EncryptedPinBlock":
            return Optional.ofNullable(clazz.cast(encryptedPinBlock()));
        case "NewPinPekKeyCheckValue":
            return Optional.ofNullable(clazz.cast(newPinPekKeyCheckValue()));
        case "SecureMessagingIntegrityKeyCheckValue":
            return Optional.ofNullable(clazz.cast(secureMessagingIntegrityKeyCheckValue()));
        case "SecureMessagingConfidentialityKeyCheckValue":
            return Optional.ofNullable(clazz.cast(secureMessagingConfidentialityKeyCheckValue()));
        case "VisaAmexDerivationOutputs":
            return Optional.ofNullable(clazz.cast(visaAmexDerivationOutputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NewPinPekArn", NEW_PIN_PEK_ARN_FIELD);
        map.put("SecureMessagingIntegrityKeyArn", SECURE_MESSAGING_INTEGRITY_KEY_ARN_FIELD);
        map.put("SecureMessagingConfidentialityKeyArn", SECURE_MESSAGING_CONFIDENTIALITY_KEY_ARN_FIELD);
        map.put("Mac", MAC_FIELD);
        map.put("EncryptedPinBlock", ENCRYPTED_PIN_BLOCK_FIELD);
        map.put("NewPinPekKeyCheckValue", NEW_PIN_PEK_KEY_CHECK_VALUE_FIELD);
        map.put("SecureMessagingIntegrityKeyCheckValue", SECURE_MESSAGING_INTEGRITY_KEY_CHECK_VALUE_FIELD);
        map.put("SecureMessagingConfidentialityKeyCheckValue", SECURE_MESSAGING_CONFIDENTIALITY_KEY_CHECK_VALUE_FIELD);
        map.put("VisaAmexDerivationOutputs", VISA_AMEX_DERIVATION_OUTPUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMacEmvPinChangeResponse, T> g) {
        return obj -> g.apply((GenerateMacEmvPinChangeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateMacEmvPinChangeResponse> {
        /**
         * <p>
         * Returns the <code>keyArn</code> of the PEK protecting the incoming new encrypted PIN block.
         * </p>
         * 
         * @param newPinPekArn
         *        Returns the <code>keyArn</code> of the PEK protecting the incoming new encrypted PIN block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPinPekArn(String newPinPekArn);

        /**
         * <p>
         * Returns the <code>keyArn</code> of the IMK-SMI used by the operation.
         * </p>
         * 
         * @param secureMessagingIntegrityKeyArn
         *        Returns the <code>keyArn</code> of the IMK-SMI used by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secureMessagingIntegrityKeyArn(String secureMessagingIntegrityKeyArn);

        /**
         * <p>
         * Returns the <code>keyArn</code> of the IMK-SMC used by the operation.
         * </p>
         * 
         * @param secureMessagingConfidentialityKeyArn
         *        Returns the <code>keyArn</code> of the IMK-SMC used by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secureMessagingConfidentialityKeyArn(String secureMessagingConfidentialityKeyArn);

        /**
         * <p>
         * Returns the mac of the issuer script containing message data and appended target encrypted pin block in ISO2
         * format.
         * </p>
         * 
         * @param mac
         *        Returns the mac of the issuer script containing message data and appended target encrypted pin block
         *        in ISO2 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mac(String mac);

        /**
         * <p>
         * Returns the incoming new encrpted PIN block.
         * </p>
         * 
         * @param encryptedPinBlock
         *        Returns the incoming new encrpted PIN block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptedPinBlock(String encryptedPinBlock);

        /**
         * <p>
         * The key check value (KCV) of the PEK uprotecting the incoming new encrypted PIN block.
         * </p>
         * 
         * @param newPinPekKeyCheckValue
         *        The key check value (KCV) of the PEK uprotecting the incoming new encrypted PIN block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPinPekKeyCheckValue(String newPinPekKeyCheckValue);

        /**
         * <p>
         * The key check value (KCV) of the SMI issuer master key used by the operation.
         * </p>
         * 
         * @param secureMessagingIntegrityKeyCheckValue
         *        The key check value (KCV) of the SMI issuer master key used by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secureMessagingIntegrityKeyCheckValue(String secureMessagingIntegrityKeyCheckValue);

        /**
         * <p>
         * The key check value (KCV) of the SMC issuer master key used by the operation.
         * </p>
         * 
         * @param secureMessagingConfidentialityKeyCheckValue
         *        The key check value (KCV) of the SMC issuer master key used by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secureMessagingConfidentialityKeyCheckValue(String secureMessagingConfidentialityKeyCheckValue);

        /**
         * <p>
         * The attribute values used for Amex and Visa derivation methods.
         * </p>
         * 
         * @param visaAmexDerivationOutputs
         *        The attribute values used for Amex and Visa derivation methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visaAmexDerivationOutputs(VisaAmexDerivationOutputs visaAmexDerivationOutputs);

        /**
         * <p>
         * The attribute values used for Amex and Visa derivation methods.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisaAmexDerivationOutputs.Builder}
         * avoiding the need to create one manually via {@link VisaAmexDerivationOutputs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisaAmexDerivationOutputs.Builder#build()} is called immediately
         * and its result is passed to {@link #visaAmexDerivationOutputs(VisaAmexDerivationOutputs)}.
         * 
         * @param visaAmexDerivationOutputs
         *        a consumer that will call methods on {@link VisaAmexDerivationOutputs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visaAmexDerivationOutputs(VisaAmexDerivationOutputs)
         */
        default Builder visaAmexDerivationOutputs(Consumer<VisaAmexDerivationOutputs.Builder> visaAmexDerivationOutputs) {
            return visaAmexDerivationOutputs(VisaAmexDerivationOutputs.builder().applyMutation(visaAmexDerivationOutputs).build());
        }
    }

    static final class BuilderImpl extends PaymentCryptographyDataResponse.BuilderImpl implements Builder {
        private String newPinPekArn;

        private String secureMessagingIntegrityKeyArn;

        private String secureMessagingConfidentialityKeyArn;

        private String mac;

        private String encryptedPinBlock;

        private String newPinPekKeyCheckValue;

        private String secureMessagingIntegrityKeyCheckValue;

        private String secureMessagingConfidentialityKeyCheckValue;

        private VisaAmexDerivationOutputs visaAmexDerivationOutputs;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMacEmvPinChangeResponse model) {
            super(model);
            newPinPekArn(model.newPinPekArn);
            secureMessagingIntegrityKeyArn(model.secureMessagingIntegrityKeyArn);
            secureMessagingConfidentialityKeyArn(model.secureMessagingConfidentialityKeyArn);
            mac(model.mac);
            encryptedPinBlock(model.encryptedPinBlock);
            newPinPekKeyCheckValue(model.newPinPekKeyCheckValue);
            secureMessagingIntegrityKeyCheckValue(model.secureMessagingIntegrityKeyCheckValue);
            secureMessagingConfidentialityKeyCheckValue(model.secureMessagingConfidentialityKeyCheckValue);
            visaAmexDerivationOutputs(model.visaAmexDerivationOutputs);
        }

        public final String getNewPinPekArn() {
            return newPinPekArn;
        }

        public final void setNewPinPekArn(String newPinPekArn) {
            this.newPinPekArn = newPinPekArn;
        }

        @Override
        public final Builder newPinPekArn(String newPinPekArn) {
            this.newPinPekArn = newPinPekArn;
            return this;
        }

        public final String getSecureMessagingIntegrityKeyArn() {
            return secureMessagingIntegrityKeyArn;
        }

        public final void setSecureMessagingIntegrityKeyArn(String secureMessagingIntegrityKeyArn) {
            this.secureMessagingIntegrityKeyArn = secureMessagingIntegrityKeyArn;
        }

        @Override
        public final Builder secureMessagingIntegrityKeyArn(String secureMessagingIntegrityKeyArn) {
            this.secureMessagingIntegrityKeyArn = secureMessagingIntegrityKeyArn;
            return this;
        }

        public final String getSecureMessagingConfidentialityKeyArn() {
            return secureMessagingConfidentialityKeyArn;
        }

        public final void setSecureMessagingConfidentialityKeyArn(String secureMessagingConfidentialityKeyArn) {
            this.secureMessagingConfidentialityKeyArn = secureMessagingConfidentialityKeyArn;
        }

        @Override
        public final Builder secureMessagingConfidentialityKeyArn(String secureMessagingConfidentialityKeyArn) {
            this.secureMessagingConfidentialityKeyArn = secureMessagingConfidentialityKeyArn;
            return this;
        }

        public final String getMac() {
            return mac;
        }

        public final void setMac(String mac) {
            this.mac = mac;
        }

        @Override
        public final Builder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public final String getEncryptedPinBlock() {
            return encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final String getNewPinPekKeyCheckValue() {
            return newPinPekKeyCheckValue;
        }

        public final void setNewPinPekKeyCheckValue(String newPinPekKeyCheckValue) {
            this.newPinPekKeyCheckValue = newPinPekKeyCheckValue;
        }

        @Override
        public final Builder newPinPekKeyCheckValue(String newPinPekKeyCheckValue) {
            this.newPinPekKeyCheckValue = newPinPekKeyCheckValue;
            return this;
        }

        public final String getSecureMessagingIntegrityKeyCheckValue() {
            return secureMessagingIntegrityKeyCheckValue;
        }

        public final void setSecureMessagingIntegrityKeyCheckValue(String secureMessagingIntegrityKeyCheckValue) {
            this.secureMessagingIntegrityKeyCheckValue = secureMessagingIntegrityKeyCheckValue;
        }

        @Override
        public final Builder secureMessagingIntegrityKeyCheckValue(String secureMessagingIntegrityKeyCheckValue) {
            this.secureMessagingIntegrityKeyCheckValue = secureMessagingIntegrityKeyCheckValue;
            return this;
        }

        public final String getSecureMessagingConfidentialityKeyCheckValue() {
            return secureMessagingConfidentialityKeyCheckValue;
        }

        public final void setSecureMessagingConfidentialityKeyCheckValue(String secureMessagingConfidentialityKeyCheckValue) {
            this.secureMessagingConfidentialityKeyCheckValue = secureMessagingConfidentialityKeyCheckValue;
        }

        @Override
        public final Builder secureMessagingConfidentialityKeyCheckValue(String secureMessagingConfidentialityKeyCheckValue) {
            this.secureMessagingConfidentialityKeyCheckValue = secureMessagingConfidentialityKeyCheckValue;
            return this;
        }

        public final VisaAmexDerivationOutputs.Builder getVisaAmexDerivationOutputs() {
            return visaAmexDerivationOutputs != null ? visaAmexDerivationOutputs.toBuilder() : null;
        }

        public final void setVisaAmexDerivationOutputs(VisaAmexDerivationOutputs.BuilderImpl visaAmexDerivationOutputs) {
            this.visaAmexDerivationOutputs = visaAmexDerivationOutputs != null ? visaAmexDerivationOutputs.build() : null;
        }

        @Override
        public final Builder visaAmexDerivationOutputs(VisaAmexDerivationOutputs visaAmexDerivationOutputs) {
            this.visaAmexDerivationOutputs = visaAmexDerivationOutputs;
            return this;
        }

        @Override
        public GenerateMacEmvPinChangeResponse build() {
            return new GenerateMacEmvPinChangeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
