/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateCardValidationDataRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<GenerateCardValidationDataRequest.Builder, GenerateCardValidationDataRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdentifier").getter(getter(GenerateCardValidationDataRequest::keyIdentifier))
            .setter(setter(Builder::keyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()).build();

    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(GenerateCardValidationDataRequest::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final SdkField<CardGenerationAttributes> GENERATION_ATTRIBUTES_FIELD = SdkField
            .<CardGenerationAttributes> builder(MarshallingType.SDK_POJO).memberName("GenerationAttributes")
            .getter(getter(GenerateCardValidationDataRequest::generationAttributes))
            .setter(setter(Builder::generationAttributes)).constructor(CardGenerationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationAttributes").build())
            .build();

    private static final SdkField<Integer> VALIDATION_DATA_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValidationDataLength").getter(getter(GenerateCardValidationDataRequest::validationDataLength))
            .setter(setter(Builder::validationDataLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationDataLength").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD,
            PRIMARY_ACCOUNT_NUMBER_FIELD, GENERATION_ATTRIBUTES_FIELD, VALIDATION_DATA_LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyIdentifier;

    private final String primaryAccountNumber;

    private final CardGenerationAttributes generationAttributes;

    private final Integer validationDataLength;

    private GenerateCardValidationDataRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.generationAttributes = builder.generationAttributes;
        this.validationDataLength = builder.validationDataLength;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to generate
     * card data.
     * </p>
     * 
     * @return The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to
     *         generate card data.
     */
    public final String keyIdentifier() {
        return keyIdentifier;
    }

    /**
     * <p>
     * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the card
     * with a specific account holder.
     * </p>
     * 
     * @return The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates
     *         the card with a specific account holder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    /**
     * <p>
     * The algorithm for generating CVV or CSC values for the card within Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The algorithm for generating CVV or CSC values for the card within Amazon Web Services Payment
     *         Cryptography.
     */
    public final CardGenerationAttributes generationAttributes() {
        return generationAttributes;
    }

    /**
     * <p>
     * The length of the CVV or CSC to be generated. The default value is 3.
     * </p>
     * 
     * @return The length of the CVV or CSC to be generated. The default value is 3.
     */
    public final Integer validationDataLength() {
        return validationDataLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(generationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(validationDataLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateCardValidationDataRequest)) {
            return false;
        }
        GenerateCardValidationDataRequest other = (GenerateCardValidationDataRequest) obj;
        return Objects.equals(keyIdentifier(), other.keyIdentifier())
                && Objects.equals(primaryAccountNumber(), other.primaryAccountNumber())
                && Objects.equals(generationAttributes(), other.generationAttributes())
                && Objects.equals(validationDataLength(), other.validationDataLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateCardValidationDataRequest").add("KeyIdentifier", keyIdentifier())
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GenerationAttributes", generationAttributes()).add("ValidationDataLength", validationDataLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyIdentifier":
            return Optional.ofNullable(clazz.cast(keyIdentifier()));
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        case "GenerationAttributes":
            return Optional.ofNullable(clazz.cast(generationAttributes()));
        case "ValidationDataLength":
            return Optional.ofNullable(clazz.cast(validationDataLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyIdentifier", KEY_IDENTIFIER_FIELD);
        map.put("PrimaryAccountNumber", PRIMARY_ACCOUNT_NUMBER_FIELD);
        map.put("GenerationAttributes", GENERATION_ATTRIBUTES_FIELD);
        map.put("ValidationDataLength", VALIDATION_DATA_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateCardValidationDataRequest, T> g) {
        return obj -> g.apply((GenerateCardValidationDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateCardValidationDataRequest> {
        /**
         * <p>
         * The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to
         * generate card data.
         * </p>
         * 
         * @param keyIdentifier
         *        The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses
         *        to generate card data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdentifier(String keyIdentifier);

        /**
         * <p>
         * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the
         * card with a specific account holder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that
         *        associates the card with a specific account holder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        /**
         * <p>
         * The algorithm for generating CVV or CSC values for the card within Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param generationAttributes
         *        The algorithm for generating CVV or CSC values for the card within Amazon Web Services Payment
         *        Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationAttributes(CardGenerationAttributes generationAttributes);

        /**
         * <p>
         * The algorithm for generating CVV or CSC values for the card within Amazon Web Services Payment Cryptography.
         * </p>
         * This is a convenience method that creates an instance of the {@link CardGenerationAttributes.Builder}
         * avoiding the need to create one manually via {@link CardGenerationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CardGenerationAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #generationAttributes(CardGenerationAttributes)}.
         * 
         * @param generationAttributes
         *        a consumer that will call methods on {@link CardGenerationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationAttributes(CardGenerationAttributes)
         */
        default Builder generationAttributes(Consumer<CardGenerationAttributes.Builder> generationAttributes) {
            return generationAttributes(CardGenerationAttributes.builder().applyMutation(generationAttributes).build());
        }

        /**
         * <p>
         * The length of the CVV or CSC to be generated. The default value is 3.
         * </p>
         * 
         * @param validationDataLength
         *        The length of the CVV or CSC to be generated. The default value is 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationDataLength(Integer validationDataLength);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String keyIdentifier;

        private String primaryAccountNumber;

        private CardGenerationAttributes generationAttributes;

        private Integer validationDataLength;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateCardValidationDataRequest model) {
            super(model);
            keyIdentifier(model.keyIdentifier);
            primaryAccountNumber(model.primaryAccountNumber);
            generationAttributes(model.generationAttributes);
            validationDataLength(model.validationDataLength);
        }

        public final String getKeyIdentifier() {
            return keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final CardGenerationAttributes.Builder getGenerationAttributes() {
            return generationAttributes != null ? generationAttributes.toBuilder() : null;
        }

        public final void setGenerationAttributes(CardGenerationAttributes.BuilderImpl generationAttributes) {
            this.generationAttributes = generationAttributes != null ? generationAttributes.build() : null;
        }

        @Override
        public final Builder generationAttributes(CardGenerationAttributes generationAttributes) {
            this.generationAttributes = generationAttributes;
            return this;
        }

        public final Integer getValidationDataLength() {
            return validationDataLength;
        }

        public final void setValidationDataLength(Integer validationDataLength) {
            this.validationDataLength = validationDataLength;
        }

        @Override
        public final Builder validationDataLength(Integer validationDataLength) {
            this.validationDataLength = validationDataLength;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateCardValidationDataRequest build() {
            return new GenerateCardValidationDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
