/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters required to establish ECDH based key exchange.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcdhDerivationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<EcdhDerivationAttributes.Builder, EcdhDerivationAttributes> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityPublicKeyIdentifier")
            .getter(getter(EcdhDerivationAttributes::certificateAuthorityPublicKeyIdentifier))
            .setter(setter(Builder::certificateAuthorityPublicKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CertificateAuthorityPublicKeyIdentifier").build()).build();

    private static final SdkField<String> PUBLIC_KEY_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKeyCertificate").getter(getter(EcdhDerivationAttributes::publicKeyCertificate))
            .setter(setter(Builder::publicKeyCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyCertificate").build())
            .build();

    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyAlgorithm").getter(getter(EcdhDerivationAttributes::keyAlgorithmAsString))
            .setter(setter(Builder::keyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()).build();

    private static final SdkField<String> KEY_DERIVATION_FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyDerivationFunction").getter(getter(EcdhDerivationAttributes::keyDerivationFunctionAsString))
            .setter(setter(Builder::keyDerivationFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDerivationFunction").build())
            .build();

    private static final SdkField<String> KEY_DERIVATION_HASH_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyDerivationHashAlgorithm")
            .getter(getter(EcdhDerivationAttributes::keyDerivationHashAlgorithmAsString))
            .setter(setter(Builder::keyDerivationHashAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDerivationHashAlgorithm").build())
            .build();

    private static final SdkField<String> SHARED_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedInformation").getter(getter(EcdhDerivationAttributes::sharedInformation))
            .setter(setter(Builder::sharedInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedInformation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, PUBLIC_KEY_CERTIFICATE_FIELD, KEY_ALGORITHM_FIELD,
            KEY_DERIVATION_FUNCTION_FIELD, KEY_DERIVATION_HASH_ALGORITHM_FIELD, SHARED_INFORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateAuthorityPublicKeyIdentifier;

    private final String publicKeyCertificate;

    private final String keyAlgorithm;

    private final String keyDerivationFunction;

    private final String keyDerivationHashAlgorithm;

    private final String sharedInformation;

    private EcdhDerivationAttributes(BuilderImpl builder) {
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.publicKeyCertificate = builder.publicKeyCertificate;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.keyDerivationFunction = builder.keyDerivationFunction;
        this.keyDerivationHashAlgorithm = builder.keyDerivationHashAlgorithm;
        this.sharedInformation = builder.sharedInformation;
    }

    /**
     * <p>
     * The <code>keyArn</code> of the certificate that signed the client's <code>PublicKeyCertificate</code>.
     * </p>
     * 
     * @return The <code>keyArn</code> of the certificate that signed the client's <code>PublicKeyCertificate</code>.
     */
    public final String certificateAuthorityPublicKeyIdentifier() {
        return certificateAuthorityPublicKeyIdentifier;
    }

    /**
     * <p>
     * The client's public key certificate in PEM format (base64 encoded) to use for ECDH key derivation.
     * </p>
     * 
     * @return The client's public key certificate in PEM format (base64 encoded) to use for ECDH key derivation.
     */
    public final String publicKeyCertificate() {
        return publicKeyCertificate;
    }

    /**
     * <p>
     * The key algorithm of the derived ECDH key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyAlgorithm} will
     * return {@link SymmetricKeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyAlgorithmAsString}.
     * </p>
     * 
     * @return The key algorithm of the derived ECDH key.
     * @see SymmetricKeyAlgorithm
     */
    public final SymmetricKeyAlgorithm keyAlgorithm() {
        return SymmetricKeyAlgorithm.fromValue(keyAlgorithm);
    }

    /**
     * <p>
     * The key algorithm of the derived ECDH key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyAlgorithm} will
     * return {@link SymmetricKeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyAlgorithmAsString}.
     * </p>
     * 
     * @return The key algorithm of the derived ECDH key.
     * @see SymmetricKeyAlgorithm
     */
    public final String keyAlgorithmAsString() {
        return keyAlgorithm;
    }

    /**
     * <p>
     * The key derivation function to use for deriving a key using ECDH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyDerivationFunction} will return {@link KeyDerivationFunction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #keyDerivationFunctionAsString}.
     * </p>
     * 
     * @return The key derivation function to use for deriving a key using ECDH.
     * @see KeyDerivationFunction
     */
    public final KeyDerivationFunction keyDerivationFunction() {
        return KeyDerivationFunction.fromValue(keyDerivationFunction);
    }

    /**
     * <p>
     * The key derivation function to use for deriving a key using ECDH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyDerivationFunction} will return {@link KeyDerivationFunction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #keyDerivationFunctionAsString}.
     * </p>
     * 
     * @return The key derivation function to use for deriving a key using ECDH.
     * @see KeyDerivationFunction
     */
    public final String keyDerivationFunctionAsString() {
        return keyDerivationFunction;
    }

    /**
     * <p>
     * The hash type to use for deriving a key using ECDH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyDerivationHashAlgorithm} will return {@link KeyDerivationHashAlgorithm#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #keyDerivationHashAlgorithmAsString}.
     * </p>
     * 
     * @return The hash type to use for deriving a key using ECDH.
     * @see KeyDerivationHashAlgorithm
     */
    public final KeyDerivationHashAlgorithm keyDerivationHashAlgorithm() {
        return KeyDerivationHashAlgorithm.fromValue(keyDerivationHashAlgorithm);
    }

    /**
     * <p>
     * The hash type to use for deriving a key using ECDH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyDerivationHashAlgorithm} will return {@link KeyDerivationHashAlgorithm#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #keyDerivationHashAlgorithmAsString}.
     * </p>
     * 
     * @return The hash type to use for deriving a key using ECDH.
     * @see KeyDerivationHashAlgorithm
     */
    public final String keyDerivationHashAlgorithmAsString() {
        return keyDerivationHashAlgorithm;
    }

    /**
     * <p>
     * A byte string containing information that binds the ECDH derived key to the two parties involved or to the
     * context of the key.
     * </p>
     * <p>
     * It may include details like identities of the two parties deriving the key, context of the operation, session
     * IDs, and optionally a nonce. It must not contain zero bytes, and re-using shared information for multiple ECDH
     * key derivations is not recommended.
     * </p>
     * 
     * @return A byte string containing information that binds the ECDH derived key to the two parties involved or to
     *         the context of the key.</p>
     *         <p>
     *         It may include details like identities of the two parties deriving the key, context of the operation,
     *         session IDs, and optionally a nonce. It must not contain zero bytes, and re-using shared information for
     *         multiple ECDH key derivations is not recommended.
     */
    public final String sharedInformation() {
        return sharedInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyDerivationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyDerivationHashAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sharedInformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcdhDerivationAttributes)) {
            return false;
        }
        EcdhDerivationAttributes other = (EcdhDerivationAttributes) obj;
        return Objects.equals(certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier())
                && Objects.equals(publicKeyCertificate(), other.publicKeyCertificate())
                && Objects.equals(keyAlgorithmAsString(), other.keyAlgorithmAsString())
                && Objects.equals(keyDerivationFunctionAsString(), other.keyDerivationFunctionAsString())
                && Objects.equals(keyDerivationHashAlgorithmAsString(), other.keyDerivationHashAlgorithmAsString())
                && Objects.equals(sharedInformation(), other.sharedInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcdhDerivationAttributes")
                .add("CertificateAuthorityPublicKeyIdentifier", certificateAuthorityPublicKeyIdentifier())
                .add("PublicKeyCertificate", publicKeyCertificate()).add("KeyAlgorithm", keyAlgorithmAsString())
                .add("KeyDerivationFunction", keyDerivationFunctionAsString())
                .add("KeyDerivationHashAlgorithm", keyDerivationHashAlgorithmAsString())
                .add("SharedInformation", sharedInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityPublicKeyIdentifier":
            return Optional.ofNullable(clazz.cast(certificateAuthorityPublicKeyIdentifier()));
        case "PublicKeyCertificate":
            return Optional.ofNullable(clazz.cast(publicKeyCertificate()));
        case "KeyAlgorithm":
            return Optional.ofNullable(clazz.cast(keyAlgorithmAsString()));
        case "KeyDerivationFunction":
            return Optional.ofNullable(clazz.cast(keyDerivationFunctionAsString()));
        case "KeyDerivationHashAlgorithm":
            return Optional.ofNullable(clazz.cast(keyDerivationHashAlgorithmAsString()));
        case "SharedInformation":
            return Optional.ofNullable(clazz.cast(sharedInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateAuthorityPublicKeyIdentifier", CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD);
        map.put("PublicKeyCertificate", PUBLIC_KEY_CERTIFICATE_FIELD);
        map.put("KeyAlgorithm", KEY_ALGORITHM_FIELD);
        map.put("KeyDerivationFunction", KEY_DERIVATION_FUNCTION_FIELD);
        map.put("KeyDerivationHashAlgorithm", KEY_DERIVATION_HASH_ALGORITHM_FIELD);
        map.put("SharedInformation", SHARED_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcdhDerivationAttributes, T> g) {
        return obj -> g.apply((EcdhDerivationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcdhDerivationAttributes> {
        /**
         * <p>
         * The <code>keyArn</code> of the certificate that signed the client's <code>PublicKeyCertificate</code>.
         * </p>
         * 
         * @param certificateAuthorityPublicKeyIdentifier
         *        The <code>keyArn</code> of the certificate that signed the client's <code>PublicKeyCertificate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier);

        /**
         * <p>
         * The client's public key certificate in PEM format (base64 encoded) to use for ECDH key derivation.
         * </p>
         * 
         * @param publicKeyCertificate
         *        The client's public key certificate in PEM format (base64 encoded) to use for ECDH key derivation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyCertificate(String publicKeyCertificate);

        /**
         * <p>
         * The key algorithm of the derived ECDH key.
         * </p>
         * 
         * @param keyAlgorithm
         *        The key algorithm of the derived ECDH key.
         * @see SymmetricKeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SymmetricKeyAlgorithm
         */
        Builder keyAlgorithm(String keyAlgorithm);

        /**
         * <p>
         * The key algorithm of the derived ECDH key.
         * </p>
         * 
         * @param keyAlgorithm
         *        The key algorithm of the derived ECDH key.
         * @see SymmetricKeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SymmetricKeyAlgorithm
         */
        Builder keyAlgorithm(SymmetricKeyAlgorithm keyAlgorithm);

        /**
         * <p>
         * The key derivation function to use for deriving a key using ECDH.
         * </p>
         * 
         * @param keyDerivationFunction
         *        The key derivation function to use for deriving a key using ECDH.
         * @see KeyDerivationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyDerivationFunction
         */
        Builder keyDerivationFunction(String keyDerivationFunction);

        /**
         * <p>
         * The key derivation function to use for deriving a key using ECDH.
         * </p>
         * 
         * @param keyDerivationFunction
         *        The key derivation function to use for deriving a key using ECDH.
         * @see KeyDerivationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyDerivationFunction
         */
        Builder keyDerivationFunction(KeyDerivationFunction keyDerivationFunction);

        /**
         * <p>
         * The hash type to use for deriving a key using ECDH.
         * </p>
         * 
         * @param keyDerivationHashAlgorithm
         *        The hash type to use for deriving a key using ECDH.
         * @see KeyDerivationHashAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyDerivationHashAlgorithm
         */
        Builder keyDerivationHashAlgorithm(String keyDerivationHashAlgorithm);

        /**
         * <p>
         * The hash type to use for deriving a key using ECDH.
         * </p>
         * 
         * @param keyDerivationHashAlgorithm
         *        The hash type to use for deriving a key using ECDH.
         * @see KeyDerivationHashAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyDerivationHashAlgorithm
         */
        Builder keyDerivationHashAlgorithm(KeyDerivationHashAlgorithm keyDerivationHashAlgorithm);

        /**
         * <p>
         * A byte string containing information that binds the ECDH derived key to the two parties involved or to the
         * context of the key.
         * </p>
         * <p>
         * It may include details like identities of the two parties deriving the key, context of the operation, session
         * IDs, and optionally a nonce. It must not contain zero bytes, and re-using shared information for multiple
         * ECDH key derivations is not recommended.
         * </p>
         * 
         * @param sharedInformation
         *        A byte string containing information that binds the ECDH derived key to the two parties involved or to
         *        the context of the key.</p>
         *        <p>
         *        It may include details like identities of the two parties deriving the key, context of the operation,
         *        session IDs, and optionally a nonce. It must not contain zero bytes, and re-using shared information
         *        for multiple ECDH key derivations is not recommended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedInformation(String sharedInformation);
    }

    static final class BuilderImpl implements Builder {
        private String certificateAuthorityPublicKeyIdentifier;

        private String publicKeyCertificate;

        private String keyAlgorithm;

        private String keyDerivationFunction;

        private String keyDerivationHashAlgorithm;

        private String sharedInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(EcdhDerivationAttributes model) {
            certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            publicKeyCertificate(model.publicKeyCertificate);
            keyAlgorithm(model.keyAlgorithm);
            keyDerivationFunction(model.keyDerivationFunction);
            keyDerivationHashAlgorithm(model.keyDerivationHashAlgorithm);
            sharedInformation(model.sharedInformation);
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final String getPublicKeyCertificate() {
            return publicKeyCertificate;
        }

        public final void setPublicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
        }

        @Override
        public final Builder publicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
            return this;
        }

        public final String getKeyAlgorithm() {
            return keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(SymmetricKeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm == null ? null : keyAlgorithm.toString());
            return this;
        }

        public final String getKeyDerivationFunction() {
            return keyDerivationFunction;
        }

        public final void setKeyDerivationFunction(String keyDerivationFunction) {
            this.keyDerivationFunction = keyDerivationFunction;
        }

        @Override
        public final Builder keyDerivationFunction(String keyDerivationFunction) {
            this.keyDerivationFunction = keyDerivationFunction;
            return this;
        }

        @Override
        public final Builder keyDerivationFunction(KeyDerivationFunction keyDerivationFunction) {
            this.keyDerivationFunction(keyDerivationFunction == null ? null : keyDerivationFunction.toString());
            return this;
        }

        public final String getKeyDerivationHashAlgorithm() {
            return keyDerivationHashAlgorithm;
        }

        public final void setKeyDerivationHashAlgorithm(String keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm = keyDerivationHashAlgorithm;
        }

        @Override
        public final Builder keyDerivationHashAlgorithm(String keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm = keyDerivationHashAlgorithm;
            return this;
        }

        @Override
        public final Builder keyDerivationHashAlgorithm(KeyDerivationHashAlgorithm keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm(keyDerivationHashAlgorithm == null ? null : keyDerivationHashAlgorithm.toString());
            return this;
        }

        public final String getSharedInformation() {
            return sharedInformation;
        }

        public final void setSharedInformation(String sharedInformation) {
            this.sharedInformation = sharedInformation;
        }

        @Override
        public final Builder sharedInformation(String sharedInformation) {
            this.sharedInformation = sharedInformation;
            return this;
        }

        @Override
        public EcdhDerivationAttributes build() {
            return new EcdhDerivationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
