/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters required for encryption or decryption of data using DUKPT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DukptDerivationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DukptDerivationAttributes.Builder, DukptDerivationAttributes> {
    private static final SdkField<String> KEY_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeySerialNumber").getter(getter(DukptDerivationAttributes::keySerialNumber))
            .setter(setter(Builder::keySerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySerialNumber").build()).build();

    private static final SdkField<String> DUKPT_KEY_DERIVATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DukptKeyDerivationType").getter(getter(DukptDerivationAttributes::dukptKeyDerivationTypeAsString))
            .setter(setter(Builder::dukptKeyDerivationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptKeyDerivationType").build())
            .build();

    private static final SdkField<String> DUKPT_KEY_VARIANT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DukptKeyVariant").getter(getter(DukptDerivationAttributes::dukptKeyVariantAsString))
            .setter(setter(Builder::dukptKeyVariant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptKeyVariant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_SERIAL_NUMBER_FIELD,
            DUKPT_KEY_DERIVATION_TYPE_FIELD, DUKPT_KEY_VARIANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keySerialNumber;

    private final String dukptKeyDerivationType;

    private final String dukptKeyVariant;

    private DukptDerivationAttributes(BuilderImpl builder) {
        this.keySerialNumber = builder.keySerialNumber;
        this.dukptKeyDerivationType = builder.dukptKeyDerivationType;
        this.dukptKeyVariant = builder.dukptKeyVariant;
    }

    /**
     * <p>
     * The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT
     * encryption method. The KSN is derived from the encrypting device unique identifier and an internal transaction
     * counter.
     * </p>
     * 
     * @return The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT
     *         encryption method. The KSN is derived from the encrypting device unique identifier and an internal
     *         transaction counter.
     */
    public final String keySerialNumber() {
        return keySerialNumber;
    }

    /**
     * <p>
     * The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be less
     * than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a derivation type
     * for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dukptKeyDerivationType} will return {@link DukptDerivationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dukptKeyDerivationTypeAsString}.
     * </p>
     * 
     * @return The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must
     *         be less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a
     *         derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>
     * @see DukptDerivationType
     */
    public final DukptDerivationType dukptKeyDerivationType() {
        return DukptDerivationType.fromValue(dukptKeyDerivationType);
    }

    /**
     * <p>
     * The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be less
     * than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a derivation type
     * for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dukptKeyDerivationType} will return {@link DukptDerivationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dukptKeyDerivationTypeAsString}.
     * </p>
     * 
     * @return The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must
     *         be less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a
     *         derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>
     * @see DukptDerivationType
     */
    public final String dukptKeyDerivationTypeAsString() {
        return dukptKeyDerivationType;
    }

    /**
     * <p>
     * The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dukptKeyVariant}
     * will return {@link DukptKeyVariant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dukptKeyVariantAsString}.
     * </p>
     * 
     * @return The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or both.
     * @see DukptKeyVariant
     */
    public final DukptKeyVariant dukptKeyVariant() {
        return DukptKeyVariant.fromValue(dukptKeyVariant);
    }

    /**
     * <p>
     * The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dukptKeyVariant}
     * will return {@link DukptKeyVariant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dukptKeyVariantAsString}.
     * </p>
     * 
     * @return The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or both.
     * @see DukptKeyVariant
     */
    public final String dukptKeyVariantAsString() {
        return dukptKeyVariant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keySerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(dukptKeyDerivationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dukptKeyVariantAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DukptDerivationAttributes)) {
            return false;
        }
        DukptDerivationAttributes other = (DukptDerivationAttributes) obj;
        return Objects.equals(keySerialNumber(), other.keySerialNumber())
                && Objects.equals(dukptKeyDerivationTypeAsString(), other.dukptKeyDerivationTypeAsString())
                && Objects.equals(dukptKeyVariantAsString(), other.dukptKeyVariantAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DukptDerivationAttributes").add("KeySerialNumber", keySerialNumber())
                .add("DukptKeyDerivationType", dukptKeyDerivationTypeAsString())
                .add("DukptKeyVariant", dukptKeyVariantAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeySerialNumber":
            return Optional.ofNullable(clazz.cast(keySerialNumber()));
        case "DukptKeyDerivationType":
            return Optional.ofNullable(clazz.cast(dukptKeyDerivationTypeAsString()));
        case "DukptKeyVariant":
            return Optional.ofNullable(clazz.cast(dukptKeyVariantAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeySerialNumber", KEY_SERIAL_NUMBER_FIELD);
        map.put("DukptKeyDerivationType", DUKPT_KEY_DERIVATION_TYPE_FIELD);
        map.put("DukptKeyVariant", DUKPT_KEY_VARIANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DukptDerivationAttributes, T> g) {
        return obj -> g.apply((DukptDerivationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DukptDerivationAttributes> {
        /**
         * <p>
         * The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT
         * encryption method. The KSN is derived from the encrypting device unique identifier and an internal
         * transaction counter.
         * </p>
         * 
         * @param keySerialNumber
         *        The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using
         *        DUKPT encryption method. The KSN is derived from the encrypting device unique identifier and an
         *        internal transaction counter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySerialNumber(String keySerialNumber);

        /**
         * <p>
         * The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be
         * less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a
         * derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>
         * </p>
         * 
         * @param dukptKeyDerivationType
         *        The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This
         *        must be less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code>
         *        as a derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>
         * @see DukptDerivationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DukptDerivationType
         */
        Builder dukptKeyDerivationType(String dukptKeyDerivationType);

        /**
         * <p>
         * The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be
         * less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a
         * derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>
         * </p>
         * 
         * @param dukptKeyDerivationType
         *        The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This
         *        must be less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code>
         *        as a derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>
         * @see DukptDerivationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DukptDerivationType
         */
        Builder dukptKeyDerivationType(DukptDerivationType dukptKeyDerivationType);

        /**
         * <p>
         * The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or both.
         * </p>
         * 
         * @param dukptKeyVariant
         *        The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or
         *        both.
         * @see DukptKeyVariant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DukptKeyVariant
         */
        Builder dukptKeyVariant(String dukptKeyVariant);

        /**
         * <p>
         * The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or both.
         * </p>
         * 
         * @param dukptKeyVariant
         *        The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or
         *        both.
         * @see DukptKeyVariant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DukptKeyVariant
         */
        Builder dukptKeyVariant(DukptKeyVariant dukptKeyVariant);
    }

    static final class BuilderImpl implements Builder {
        private String keySerialNumber;

        private String dukptKeyDerivationType;

        private String dukptKeyVariant;

        private BuilderImpl() {
        }

        private BuilderImpl(DukptDerivationAttributes model) {
            keySerialNumber(model.keySerialNumber);
            dukptKeyDerivationType(model.dukptKeyDerivationType);
            dukptKeyVariant(model.dukptKeyVariant);
        }

        public final String getKeySerialNumber() {
            return keySerialNumber;
        }

        public final void setKeySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
        }

        @Override
        public final Builder keySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
            return this;
        }

        public final String getDukptKeyDerivationType() {
            return dukptKeyDerivationType;
        }

        public final void setDukptKeyDerivationType(String dukptKeyDerivationType) {
            this.dukptKeyDerivationType = dukptKeyDerivationType;
        }

        @Override
        public final Builder dukptKeyDerivationType(String dukptKeyDerivationType) {
            this.dukptKeyDerivationType = dukptKeyDerivationType;
            return this;
        }

        @Override
        public final Builder dukptKeyDerivationType(DukptDerivationType dukptKeyDerivationType) {
            this.dukptKeyDerivationType(dukptKeyDerivationType == null ? null : dukptKeyDerivationType.toString());
            return this;
        }

        public final String getDukptKeyVariant() {
            return dukptKeyVariant;
        }

        public final void setDukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
        }

        @Override
        public final Builder dukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
            return this;
        }

        @Override
        public final Builder dukptKeyVariant(DukptKeyVariant dukptKeyVariant) {
            this.dukptKeyVariant(dukptKeyVariant == null ? null : dukptKeyVariant.toString());
            return this;
        }

        @Override
        public DukptDerivationAttributes build() {
            return new DukptDerivationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
