/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required to generate or verify dCVC (Dynamic Card Verification Code).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoverDynamicCardVerificationCode implements SdkPojo, Serializable,
        ToCopyableBuilder<DiscoverDynamicCardVerificationCode.Builder, DiscoverDynamicCardVerificationCode> {
    private static final SdkField<String> CARD_EXPIRY_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CardExpiryDate").getter(getter(DiscoverDynamicCardVerificationCode::cardExpiryDate))
            .setter(setter(Builder::cardExpiryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardExpiryDate").build()).build();

    private static final SdkField<String> UNPREDICTABLE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnpredictableNumber").getter(getter(DiscoverDynamicCardVerificationCode::unpredictableNumber))
            .setter(setter(Builder::unpredictableNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpredictableNumber").build())
            .build();

    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationTransactionCounter")
            .getter(getter(DiscoverDynamicCardVerificationCode::applicationTransactionCounter))
            .setter(setter(Builder::applicationTransactionCounter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_EXPIRY_DATE_FIELD,
            UNPREDICTABLE_NUMBER_FIELD, APPLICATION_TRANSACTION_COUNTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cardExpiryDate;

    private final String unpredictableNumber;

    private final String applicationTransactionCounter;

    private DiscoverDynamicCardVerificationCode(BuilderImpl builder) {
        this.cardExpiryDate = builder.cardExpiryDate;
        this.unpredictableNumber = builder.unpredictableNumber;
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
    }

    /**
     * <p>
     * The expiry date of a payment card.
     * </p>
     * 
     * @return The expiry date of a payment card.
     */
    public final String cardExpiryDate() {
        return cardExpiryDate;
    }

    /**
     * <p>
     * A random number that is generated by the issuer.
     * </p>
     * 
     * @return A random number that is generated by the issuer.
     */
    public final String unpredictableNumber() {
        return unpredictableNumber;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @return The transaction counter value that comes from the terminal.
     */
    public final String applicationTransactionCounter() {
        return applicationTransactionCounter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cardExpiryDate());
        hashCode = 31 * hashCode + Objects.hashCode(unpredictableNumber());
        hashCode = 31 * hashCode + Objects.hashCode(applicationTransactionCounter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverDynamicCardVerificationCode)) {
            return false;
        }
        DiscoverDynamicCardVerificationCode other = (DiscoverDynamicCardVerificationCode) obj;
        return Objects.equals(cardExpiryDate(), other.cardExpiryDate())
                && Objects.equals(unpredictableNumber(), other.unpredictableNumber())
                && Objects.equals(applicationTransactionCounter(), other.applicationTransactionCounter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoverDynamicCardVerificationCode")
                .add("CardExpiryDate", cardExpiryDate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UnpredictableNumber", unpredictableNumber())
                .add("ApplicationTransactionCounter", applicationTransactionCounter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CardExpiryDate":
            return Optional.ofNullable(clazz.cast(cardExpiryDate()));
        case "UnpredictableNumber":
            return Optional.ofNullable(clazz.cast(unpredictableNumber()));
        case "ApplicationTransactionCounter":
            return Optional.ofNullable(clazz.cast(applicationTransactionCounter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CardExpiryDate", CARD_EXPIRY_DATE_FIELD);
        map.put("UnpredictableNumber", UNPREDICTABLE_NUMBER_FIELD);
        map.put("ApplicationTransactionCounter", APPLICATION_TRANSACTION_COUNTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoverDynamicCardVerificationCode, T> g) {
        return obj -> g.apply((DiscoverDynamicCardVerificationCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiscoverDynamicCardVerificationCode> {
        /**
         * <p>
         * The expiry date of a payment card.
         * </p>
         * 
         * @param cardExpiryDate
         *        The expiry date of a payment card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardExpiryDate(String cardExpiryDate);

        /**
         * <p>
         * A random number that is generated by the issuer.
         * </p>
         * 
         * @param unpredictableNumber
         *        A random number that is generated by the issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpredictableNumber(String unpredictableNumber);

        /**
         * <p>
         * The transaction counter value that comes from the terminal.
         * </p>
         * 
         * @param applicationTransactionCounter
         *        The transaction counter value that comes from the terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTransactionCounter(String applicationTransactionCounter);
    }

    static final class BuilderImpl implements Builder {
        private String cardExpiryDate;

        private String unpredictableNumber;

        private String applicationTransactionCounter;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverDynamicCardVerificationCode model) {
            cardExpiryDate(model.cardExpiryDate);
            unpredictableNumber(model.unpredictableNumber);
            applicationTransactionCounter(model.applicationTransactionCounter);
        }

        public final String getCardExpiryDate() {
            return cardExpiryDate;
        }

        public final void setCardExpiryDate(String cardExpiryDate) {
            this.cardExpiryDate = cardExpiryDate;
        }

        @Override
        public final Builder cardExpiryDate(String cardExpiryDate) {
            this.cardExpiryDate = cardExpiryDate;
            return this;
        }

        public final String getUnpredictableNumber() {
            return unpredictableNumber;
        }

        public final void setUnpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
        }

        @Override
        public final Builder unpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
            return this;
        }

        public final String getApplicationTransactionCounter() {
            return applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
            return this;
        }

        @Override
        public DiscoverDynamicCardVerificationCode build() {
            return new DiscoverDynamicCardVerificationCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
