/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required for Authorization Response Cryptogram (ARPC) generation after Authorization Request
 * Cryptogram (ARQC) verification is successful.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CryptogramAuthResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CryptogramAuthResponse.Builder, CryptogramAuthResponse> {
    private static final SdkField<CryptogramVerificationArpcMethod1> ARPC_METHOD1_FIELD = SdkField
            .<CryptogramVerificationArpcMethod1> builder(MarshallingType.SDK_POJO).memberName("ArpcMethod1")
            .getter(getter(CryptogramAuthResponse::arpcMethod1)).setter(setter(Builder::arpcMethod1))
            .constructor(CryptogramVerificationArpcMethod1::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArpcMethod1").build()).build();

    private static final SdkField<CryptogramVerificationArpcMethod2> ARPC_METHOD2_FIELD = SdkField
            .<CryptogramVerificationArpcMethod2> builder(MarshallingType.SDK_POJO).memberName("ArpcMethod2")
            .getter(getter(CryptogramAuthResponse::arpcMethod2)).setter(setter(Builder::arpcMethod2))
            .constructor(CryptogramVerificationArpcMethod2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArpcMethod2").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARPC_METHOD1_FIELD,
            ARPC_METHOD2_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CryptogramVerificationArpcMethod1 arpcMethod1;

    private final CryptogramVerificationArpcMethod2 arpcMethod2;

    private final Type type;

    private CryptogramAuthResponse(BuilderImpl builder) {
        this.arpcMethod1 = builder.arpcMethod1;
        this.arpcMethod2 = builder.arpcMethod2;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameters that are required for ARPC response generation using method1 after ARQC verification is successful.
     * </p>
     * 
     * @return Parameters that are required for ARPC response generation using method1 after ARQC verification is
     *         successful.
     */
    public final CryptogramVerificationArpcMethod1 arpcMethod1() {
        return arpcMethod1;
    }

    /**
     * <p>
     * Parameters that are required for ARPC response generation using method2 after ARQC verification is successful.
     * </p>
     * 
     * @return Parameters that are required for ARPC response generation using method2 after ARQC verification is
     *         successful.
     */
    public final CryptogramVerificationArpcMethod2 arpcMethod2() {
        return arpcMethod2;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arpcMethod1());
        hashCode = 31 * hashCode + Objects.hashCode(arpcMethod2());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CryptogramAuthResponse)) {
            return false;
        }
        CryptogramAuthResponse other = (CryptogramAuthResponse) obj;
        return Objects.equals(arpcMethod1(), other.arpcMethod1()) && Objects.equals(arpcMethod2(), other.arpcMethod2());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CryptogramAuthResponse").add("ArpcMethod1", arpcMethod1()).add("ArpcMethod2", arpcMethod2())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArpcMethod1":
            return Optional.ofNullable(clazz.cast(arpcMethod1()));
        case "ArpcMethod2":
            return Optional.ofNullable(clazz.cast(arpcMethod2()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #arpcMethod1()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ARPC response generation using method1 after ARQC verification is successful.
     * </p>
     * 
     * @param arpcMethod1
     *        Parameters that are required for ARPC response generation using method1 after ARQC verification is
     *        successful.
     */
    public static CryptogramAuthResponse fromArpcMethod1(CryptogramVerificationArpcMethod1 arpcMethod1) {
        return builder().arpcMethod1(arpcMethod1).build();
    }

    /**
     * Create an instance of this class with {@link #arpcMethod1()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ARPC response generation using method1 after ARQC verification is successful.
     * </p>
     * 
     * @param arpcMethod1
     *        Parameters that are required for ARPC response generation using method1 after ARQC verification is
     *        successful.
     */
    public static CryptogramAuthResponse fromArpcMethod1(Consumer<CryptogramVerificationArpcMethod1.Builder> arpcMethod1) {
        CryptogramVerificationArpcMethod1.Builder builder = CryptogramVerificationArpcMethod1.builder();
        arpcMethod1.accept(builder);
        return fromArpcMethod1(builder.build());
    }

    /**
     * Create an instance of this class with {@link #arpcMethod2()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ARPC response generation using method2 after ARQC verification is successful.
     * </p>
     * 
     * @param arpcMethod2
     *        Parameters that are required for ARPC response generation using method2 after ARQC verification is
     *        successful.
     */
    public static CryptogramAuthResponse fromArpcMethod2(CryptogramVerificationArpcMethod2 arpcMethod2) {
        return builder().arpcMethod2(arpcMethod2).build();
    }

    /**
     * Create an instance of this class with {@link #arpcMethod2()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ARPC response generation using method2 after ARQC verification is successful.
     * </p>
     * 
     * @param arpcMethod2
     *        Parameters that are required for ARPC response generation using method2 after ARQC verification is
     *        successful.
     */
    public static CryptogramAuthResponse fromArpcMethod2(Consumer<CryptogramVerificationArpcMethod2.Builder> arpcMethod2) {
        CryptogramVerificationArpcMethod2.Builder builder = CryptogramVerificationArpcMethod2.builder();
        arpcMethod2.accept(builder);
        return fromArpcMethod2(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArpcMethod1", ARPC_METHOD1_FIELD);
        map.put("ArpcMethod2", ARPC_METHOD2_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CryptogramAuthResponse, T> g) {
        return obj -> g.apply((CryptogramAuthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CryptogramAuthResponse> {
        /**
         * <p>
         * Parameters that are required for ARPC response generation using method1 after ARQC verification is
         * successful.
         * </p>
         * 
         * @param arpcMethod1
         *        Parameters that are required for ARPC response generation using method1 after ARQC verification is
         *        successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arpcMethod1(CryptogramVerificationArpcMethod1 arpcMethod1);

        /**
         * <p>
         * Parameters that are required for ARPC response generation using method1 after ARQC verification is
         * successful.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CryptogramVerificationArpcMethod1.Builder} avoiding the need to create one manually via
         * {@link CryptogramVerificationArpcMethod1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CryptogramVerificationArpcMethod1.Builder#build()} is called
         * immediately and its result is passed to {@link #arpcMethod1(CryptogramVerificationArpcMethod1)}.
         * 
         * @param arpcMethod1
         *        a consumer that will call methods on {@link CryptogramVerificationArpcMethod1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arpcMethod1(CryptogramVerificationArpcMethod1)
         */
        default Builder arpcMethod1(Consumer<CryptogramVerificationArpcMethod1.Builder> arpcMethod1) {
            return arpcMethod1(CryptogramVerificationArpcMethod1.builder().applyMutation(arpcMethod1).build());
        }

        /**
         * <p>
         * Parameters that are required for ARPC response generation using method2 after ARQC verification is
         * successful.
         * </p>
         * 
         * @param arpcMethod2
         *        Parameters that are required for ARPC response generation using method2 after ARQC verification is
         *        successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arpcMethod2(CryptogramVerificationArpcMethod2 arpcMethod2);

        /**
         * <p>
         * Parameters that are required for ARPC response generation using method2 after ARQC verification is
         * successful.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CryptogramVerificationArpcMethod2.Builder} avoiding the need to create one manually via
         * {@link CryptogramVerificationArpcMethod2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CryptogramVerificationArpcMethod2.Builder#build()} is called
         * immediately and its result is passed to {@link #arpcMethod2(CryptogramVerificationArpcMethod2)}.
         * 
         * @param arpcMethod2
         *        a consumer that will call methods on {@link CryptogramVerificationArpcMethod2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arpcMethod2(CryptogramVerificationArpcMethod2)
         */
        default Builder arpcMethod2(Consumer<CryptogramVerificationArpcMethod2.Builder> arpcMethod2) {
            return arpcMethod2(CryptogramVerificationArpcMethod2.builder().applyMutation(arpcMethod2).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CryptogramVerificationArpcMethod1 arpcMethod1;

        private CryptogramVerificationArpcMethod2 arpcMethod2;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CryptogramAuthResponse model) {
            arpcMethod1(model.arpcMethod1);
            arpcMethod2(model.arpcMethod2);
        }

        public final CryptogramVerificationArpcMethod1.Builder getArpcMethod1() {
            return arpcMethod1 != null ? arpcMethod1.toBuilder() : null;
        }

        public final void setArpcMethod1(CryptogramVerificationArpcMethod1.BuilderImpl arpcMethod1) {
            Object oldValue = this.arpcMethod1;
            this.arpcMethod1 = arpcMethod1 != null ? arpcMethod1.build() : null;
            handleUnionValueChange(Type.ARPC_METHOD1, oldValue, this.arpcMethod1);
        }

        @Override
        public final Builder arpcMethod1(CryptogramVerificationArpcMethod1 arpcMethod1) {
            Object oldValue = this.arpcMethod1;
            this.arpcMethod1 = arpcMethod1;
            handleUnionValueChange(Type.ARPC_METHOD1, oldValue, this.arpcMethod1);
            return this;
        }

        public final CryptogramVerificationArpcMethod2.Builder getArpcMethod2() {
            return arpcMethod2 != null ? arpcMethod2.toBuilder() : null;
        }

        public final void setArpcMethod2(CryptogramVerificationArpcMethod2.BuilderImpl arpcMethod2) {
            Object oldValue = this.arpcMethod2;
            this.arpcMethod2 = arpcMethod2 != null ? arpcMethod2.build() : null;
            handleUnionValueChange(Type.ARPC_METHOD2, oldValue, this.arpcMethod2);
        }

        @Override
        public final Builder arpcMethod2(CryptogramVerificationArpcMethod2 arpcMethod2) {
            Object oldValue = this.arpcMethod2;
            this.arpcMethod2 = arpcMethod2;
            handleUnionValueChange(Type.ARPC_METHOD2, oldValue, this.arpcMethod2);
            return this;
        }

        @Override
        public CryptogramAuthResponse build() {
            return new CryptogramAuthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CryptogramAuthResponse#type()
     */
    public enum Type {
        ARPC_METHOD1,

        ARPC_METHOD2,

        UNKNOWN_TO_SDK_VERSION
    }
}
