/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.CurrentPinAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VisaAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VisaAttributes> {
    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorKeyDerivationMode").getter(VisaAttributes.getter(VisaAttributes::majorKeyDerivationModeAsString)).setter(VisaAttributes.setter(Builder::majorKeyDerivationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(VisaAttributes.getter(VisaAttributes::primaryAccountNumber)).setter(VisaAttributes.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PanSequenceNumber").getter(VisaAttributes.getter(VisaAttributes::panSequenceNumber)).setter(VisaAttributes.setter(Builder::panSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()}).build();
    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationTransactionCounter").getter(VisaAttributes.getter(VisaAttributes::applicationTransactionCounter)).setter(VisaAttributes.setter(Builder::applicationTransactionCounter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter").build()}).build();
    private static final SdkField<String> AUTHORIZATION_REQUEST_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationRequestKeyIdentifier").getter(VisaAttributes.getter(VisaAttributes::authorizationRequestKeyIdentifier)).setter(VisaAttributes.setter(Builder::authorizationRequestKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationRequestKeyIdentifier").build()}).build();
    private static final SdkField<CurrentPinAttributes> CURRENT_PIN_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentPinAttributes").getter(VisaAttributes.getter(VisaAttributes::currentPinAttributes)).setter(VisaAttributes.setter(Builder::currentPinAttributes)).constructor(CurrentPinAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPinAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAJOR_KEY_DERIVATION_MODE_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, PAN_SEQUENCE_NUMBER_FIELD, APPLICATION_TRANSACTION_COUNTER_FIELD, AUTHORIZATION_REQUEST_KEY_IDENTIFIER_FIELD, CURRENT_PIN_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String majorKeyDerivationMode;
    private final String primaryAccountNumber;
    private final String panSequenceNumber;
    private final String applicationTransactionCounter;
    private final String authorizationRequestKeyIdentifier;
    private final CurrentPinAttributes currentPinAttributes;

    private VisaAttributes(BuilderImpl builder) {
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
        this.authorizationRequestKeyIdentifier = builder.authorizationRequestKeyIdentifier;
        this.currentPinAttributes = builder.currentPinAttributes;
    }

    public final MajorKeyDerivationMode majorKeyDerivationMode() {
        return MajorKeyDerivationMode.fromValue(this.majorKeyDerivationMode);
    }

    public final String majorKeyDerivationModeAsString() {
        return this.majorKeyDerivationMode;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final String panSequenceNumber() {
        return this.panSequenceNumber;
    }

    public final String applicationTransactionCounter() {
        return this.applicationTransactionCounter;
    }

    public final String authorizationRequestKeyIdentifier() {
        return this.authorizationRequestKeyIdentifier;
    }

    public final CurrentPinAttributes currentPinAttributes() {
        return this.currentPinAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTransactionCounter());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationRequestKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPinAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisaAttributes)) {
            return false;
        }
        VisaAttributes other = (VisaAttributes)obj;
        return Objects.equals(this.majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.panSequenceNumber(), other.panSequenceNumber()) && Objects.equals(this.applicationTransactionCounter(), other.applicationTransactionCounter()) && Objects.equals(this.authorizationRequestKeyIdentifier(), other.authorizationRequestKeyIdentifier()) && Objects.equals(this.currentPinAttributes(), other.currentPinAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"VisaAttributes").add("MajorKeyDerivationMode", (Object)this.majorKeyDerivationModeAsString()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PanSequenceNumber", (Object)this.panSequenceNumber()).add("ApplicationTransactionCounter", (Object)this.applicationTransactionCounter()).add("AuthorizationRequestKeyIdentifier", (Object)this.authorizationRequestKeyIdentifier()).add("CurrentPinAttributes", (Object)this.currentPinAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MajorKeyDerivationMode": {
                return Optional.ofNullable(clazz.cast(this.majorKeyDerivationModeAsString()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "PanSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.panSequenceNumber()));
            }
            case "ApplicationTransactionCounter": {
                return Optional.ofNullable(clazz.cast(this.applicationTransactionCounter()));
            }
            case "AuthorizationRequestKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.authorizationRequestKeyIdentifier()));
            }
            case "CurrentPinAttributes": {
                return Optional.ofNullable(clazz.cast(this.currentPinAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VisaAttributes, T> g) {
        return obj -> g.apply((VisaAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String majorKeyDerivationMode;
        private String primaryAccountNumber;
        private String panSequenceNumber;
        private String applicationTransactionCounter;
        private String authorizationRequestKeyIdentifier;
        private CurrentPinAttributes currentPinAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VisaAttributes model) {
            this.majorKeyDerivationMode(model.majorKeyDerivationMode);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.panSequenceNumber(model.panSequenceNumber);
            this.applicationTransactionCounter(model.applicationTransactionCounter);
            this.authorizationRequestKeyIdentifier(model.authorizationRequestKeyIdentifier);
            this.currentPinAttributes(model.currentPinAttributes);
        }

        public final String getMajorKeyDerivationMode() {
            return this.majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPanSequenceNumber() {
            return this.panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getApplicationTransactionCounter() {
            return this.applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
            return this;
        }

        public final String getAuthorizationRequestKeyIdentifier() {
            return this.authorizationRequestKeyIdentifier;
        }

        public final void setAuthorizationRequestKeyIdentifier(String authorizationRequestKeyIdentifier) {
            this.authorizationRequestKeyIdentifier = authorizationRequestKeyIdentifier;
        }

        @Override
        public final Builder authorizationRequestKeyIdentifier(String authorizationRequestKeyIdentifier) {
            this.authorizationRequestKeyIdentifier = authorizationRequestKeyIdentifier;
            return this;
        }

        public final CurrentPinAttributes.Builder getCurrentPinAttributes() {
            return this.currentPinAttributes != null ? this.currentPinAttributes.toBuilder() : null;
        }

        public final void setCurrentPinAttributes(CurrentPinAttributes.BuilderImpl currentPinAttributes) {
            this.currentPinAttributes = currentPinAttributes != null ? currentPinAttributes.build() : null;
        }

        @Override
        public final Builder currentPinAttributes(CurrentPinAttributes currentPinAttributes) {
            this.currentPinAttributes = currentPinAttributes;
            return this;
        }

        public VisaAttributes build() {
            return new VisaAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VisaAttributes> {
        public Builder majorKeyDerivationMode(String var1);

        public Builder majorKeyDerivationMode(MajorKeyDerivationMode var1);

        public Builder primaryAccountNumber(String var1);

        public Builder panSequenceNumber(String var1);

        public Builder applicationTransactionCounter(String var1);

        public Builder authorizationRequestKeyIdentifier(String var1);

        public Builder currentPinAttributes(CurrentPinAttributes var1);

        default public Builder currentPinAttributes(Consumer<CurrentPinAttributes.Builder> currentPinAttributes) {
            return this.currentPinAttributes((CurrentPinAttributes)((CurrentPinAttributes.Builder)CurrentPinAttributes.builder().applyMutation(currentPinAttributes)).build());
        }
    }
}

