/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptographydata.model.AmexAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.Emv2000Attributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.EmvCommonAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.MasterCardAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.VisaAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DerivationMethodAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DerivationMethodAttributes> {
    private static final SdkField<EmvCommonAttributes> EMV_COMMON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmvCommon").getter(DerivationMethodAttributes.getter(DerivationMethodAttributes::emvCommon)).setter(DerivationMethodAttributes.setter(Builder::emvCommon)).constructor(EmvCommonAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmvCommon").build()}).build();
    private static final SdkField<AmexAttributes> AMEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Amex").getter(DerivationMethodAttributes.getter(DerivationMethodAttributes::amex)).setter(DerivationMethodAttributes.setter(Builder::amex)).constructor(AmexAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amex").build()}).build();
    private static final SdkField<VisaAttributes> VISA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Visa").getter(DerivationMethodAttributes.getter(DerivationMethodAttributes::visa)).setter(DerivationMethodAttributes.setter(Builder::visa)).constructor(VisaAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visa").build()}).build();
    private static final SdkField<Emv2000Attributes> EMV2000_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Emv2000").getter(DerivationMethodAttributes.getter(DerivationMethodAttributes::emv2000)).setter(DerivationMethodAttributes.setter(Builder::emv2000)).constructor(Emv2000Attributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emv2000").build()}).build();
    private static final SdkField<MasterCardAttributes> MASTERCARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mastercard").getter(DerivationMethodAttributes.getter(DerivationMethodAttributes::mastercard)).setter(DerivationMethodAttributes.setter(Builder::mastercard)).constructor(MasterCardAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mastercard").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMV_COMMON_FIELD, AMEX_FIELD, VISA_FIELD, EMV2000_FIELD, MASTERCARD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EmvCommon", EMV_COMMON_FIELD);
            this.put("Amex", AMEX_FIELD);
            this.put("Visa", VISA_FIELD);
            this.put("Emv2000", EMV2000_FIELD);
            this.put("Mastercard", MASTERCARD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final EmvCommonAttributes emvCommon;
    private final AmexAttributes amex;
    private final VisaAttributes visa;
    private final Emv2000Attributes emv2000;
    private final MasterCardAttributes mastercard;
    private final Type type;

    private DerivationMethodAttributes(BuilderImpl builder) {
        this.emvCommon = builder.emvCommon;
        this.amex = builder.amex;
        this.visa = builder.visa;
        this.emv2000 = builder.emv2000;
        this.mastercard = builder.mastercard;
        this.type = builder.type;
    }

    public final EmvCommonAttributes emvCommon() {
        return this.emvCommon;
    }

    public final AmexAttributes amex() {
        return this.amex;
    }

    public final VisaAttributes visa() {
        return this.visa;
    }

    public final Emv2000Attributes emv2000() {
        return this.emv2000;
    }

    public final MasterCardAttributes mastercard() {
        return this.mastercard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emvCommon());
        hashCode = 31 * hashCode + Objects.hashCode(this.amex());
        hashCode = 31 * hashCode + Objects.hashCode(this.visa());
        hashCode = 31 * hashCode + Objects.hashCode(this.emv2000());
        hashCode = 31 * hashCode + Objects.hashCode(this.mastercard());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DerivationMethodAttributes)) {
            return false;
        }
        DerivationMethodAttributes other = (DerivationMethodAttributes)obj;
        return Objects.equals(this.emvCommon(), other.emvCommon()) && Objects.equals(this.amex(), other.amex()) && Objects.equals(this.visa(), other.visa()) && Objects.equals(this.emv2000(), other.emv2000()) && Objects.equals(this.mastercard(), other.mastercard());
    }

    public final String toString() {
        return ToString.builder((String)"DerivationMethodAttributes").add("EmvCommon", (Object)this.emvCommon()).add("Amex", (Object)this.amex()).add("Visa", (Object)this.visa()).add("Emv2000", (Object)this.emv2000()).add("Mastercard", (Object)this.mastercard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmvCommon": {
                return Optional.ofNullable(clazz.cast(this.emvCommon()));
            }
            case "Amex": {
                return Optional.ofNullable(clazz.cast(this.amex()));
            }
            case "Visa": {
                return Optional.ofNullable(clazz.cast(this.visa()));
            }
            case "Emv2000": {
                return Optional.ofNullable(clazz.cast(this.emv2000()));
            }
            case "Mastercard": {
                return Optional.ofNullable(clazz.cast(this.mastercard()));
            }
        }
        return Optional.empty();
    }

    public static DerivationMethodAttributes fromEmvCommon(EmvCommonAttributes emvCommon) {
        return (DerivationMethodAttributes)DerivationMethodAttributes.builder().emvCommon(emvCommon).build();
    }

    public static DerivationMethodAttributes fromEmvCommon(Consumer<EmvCommonAttributes.Builder> emvCommon) {
        EmvCommonAttributes.Builder builder = EmvCommonAttributes.builder();
        emvCommon.accept(builder);
        return DerivationMethodAttributes.fromEmvCommon((EmvCommonAttributes)builder.build());
    }

    public static DerivationMethodAttributes fromAmex(AmexAttributes amex) {
        return (DerivationMethodAttributes)DerivationMethodAttributes.builder().amex(amex).build();
    }

    public static DerivationMethodAttributes fromAmex(Consumer<AmexAttributes.Builder> amex) {
        AmexAttributes.Builder builder = AmexAttributes.builder();
        amex.accept(builder);
        return DerivationMethodAttributes.fromAmex((AmexAttributes)builder.build());
    }

    public static DerivationMethodAttributes fromVisa(VisaAttributes visa) {
        return (DerivationMethodAttributes)DerivationMethodAttributes.builder().visa(visa).build();
    }

    public static DerivationMethodAttributes fromVisa(Consumer<VisaAttributes.Builder> visa) {
        VisaAttributes.Builder builder = VisaAttributes.builder();
        visa.accept(builder);
        return DerivationMethodAttributes.fromVisa((VisaAttributes)builder.build());
    }

    public static DerivationMethodAttributes fromEmv2000(Emv2000Attributes emv2000) {
        return (DerivationMethodAttributes)DerivationMethodAttributes.builder().emv2000(emv2000).build();
    }

    public static DerivationMethodAttributes fromEmv2000(Consumer<Emv2000Attributes.Builder> emv2000) {
        Emv2000Attributes.Builder builder = Emv2000Attributes.builder();
        emv2000.accept(builder);
        return DerivationMethodAttributes.fromEmv2000((Emv2000Attributes)builder.build());
    }

    public static DerivationMethodAttributes fromMastercard(MasterCardAttributes mastercard) {
        return (DerivationMethodAttributes)DerivationMethodAttributes.builder().mastercard(mastercard).build();
    }

    public static DerivationMethodAttributes fromMastercard(Consumer<MasterCardAttributes.Builder> mastercard) {
        MasterCardAttributes.Builder builder = MasterCardAttributes.builder();
        mastercard.accept(builder);
        return DerivationMethodAttributes.fromMastercard((MasterCardAttributes)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DerivationMethodAttributes, T> g) {
        return obj -> g.apply((DerivationMethodAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EMV_COMMON,
        AMEX,
        VISA,
        EMV2000,
        MASTERCARD,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EmvCommonAttributes emvCommon;
        private AmexAttributes amex;
        private VisaAttributes visa;
        private Emv2000Attributes emv2000;
        private MasterCardAttributes mastercard;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DerivationMethodAttributes model) {
            this.emvCommon(model.emvCommon);
            this.amex(model.amex);
            this.visa(model.visa);
            this.emv2000(model.emv2000);
            this.mastercard(model.mastercard);
        }

        public final EmvCommonAttributes.Builder getEmvCommon() {
            return this.emvCommon != null ? this.emvCommon.toBuilder() : null;
        }

        public final void setEmvCommon(EmvCommonAttributes.BuilderImpl emvCommon) {
            EmvCommonAttributes oldValue = this.emvCommon;
            this.emvCommon = emvCommon != null ? emvCommon.build() : null;
            this.handleUnionValueChange(Type.EMV_COMMON, oldValue, this.emvCommon);
        }

        @Override
        public final Builder emvCommon(EmvCommonAttributes emvCommon) {
            EmvCommonAttributes oldValue = this.emvCommon;
            this.emvCommon = emvCommon;
            this.handleUnionValueChange(Type.EMV_COMMON, oldValue, this.emvCommon);
            return this;
        }

        public final AmexAttributes.Builder getAmex() {
            return this.amex != null ? this.amex.toBuilder() : null;
        }

        public final void setAmex(AmexAttributes.BuilderImpl amex) {
            AmexAttributes oldValue = this.amex;
            this.amex = amex != null ? amex.build() : null;
            this.handleUnionValueChange(Type.AMEX, oldValue, this.amex);
        }

        @Override
        public final Builder amex(AmexAttributes amex) {
            AmexAttributes oldValue = this.amex;
            this.amex = amex;
            this.handleUnionValueChange(Type.AMEX, oldValue, this.amex);
            return this;
        }

        public final VisaAttributes.Builder getVisa() {
            return this.visa != null ? this.visa.toBuilder() : null;
        }

        public final void setVisa(VisaAttributes.BuilderImpl visa) {
            VisaAttributes oldValue = this.visa;
            this.visa = visa != null ? visa.build() : null;
            this.handleUnionValueChange(Type.VISA, oldValue, this.visa);
        }

        @Override
        public final Builder visa(VisaAttributes visa) {
            VisaAttributes oldValue = this.visa;
            this.visa = visa;
            this.handleUnionValueChange(Type.VISA, oldValue, this.visa);
            return this;
        }

        public final Emv2000Attributes.Builder getEmv2000() {
            return this.emv2000 != null ? this.emv2000.toBuilder() : null;
        }

        public final void setEmv2000(Emv2000Attributes.BuilderImpl emv2000) {
            Emv2000Attributes oldValue = this.emv2000;
            this.emv2000 = emv2000 != null ? emv2000.build() : null;
            this.handleUnionValueChange(Type.EMV2000, oldValue, this.emv2000);
        }

        @Override
        public final Builder emv2000(Emv2000Attributes emv2000) {
            Emv2000Attributes oldValue = this.emv2000;
            this.emv2000 = emv2000;
            this.handleUnionValueChange(Type.EMV2000, oldValue, this.emv2000);
            return this;
        }

        public final MasterCardAttributes.Builder getMastercard() {
            return this.mastercard != null ? this.mastercard.toBuilder() : null;
        }

        public final void setMastercard(MasterCardAttributes.BuilderImpl mastercard) {
            MasterCardAttributes oldValue = this.mastercard;
            this.mastercard = mastercard != null ? mastercard.build() : null;
            this.handleUnionValueChange(Type.MASTERCARD, oldValue, this.mastercard);
        }

        @Override
        public final Builder mastercard(MasterCardAttributes mastercard) {
            MasterCardAttributes oldValue = this.mastercard;
            this.mastercard = mastercard;
            this.handleUnionValueChange(Type.MASTERCARD, oldValue, this.mastercard);
            return this;
        }

        public DerivationMethodAttributes build() {
            return new DerivationMethodAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DerivationMethodAttributes> {
        public Builder emvCommon(EmvCommonAttributes var1);

        default public Builder emvCommon(Consumer<EmvCommonAttributes.Builder> emvCommon) {
            return this.emvCommon((EmvCommonAttributes)((EmvCommonAttributes.Builder)EmvCommonAttributes.builder().applyMutation(emvCommon)).build());
        }

        public Builder amex(AmexAttributes var1);

        default public Builder amex(Consumer<AmexAttributes.Builder> amex) {
            return this.amex((AmexAttributes)((AmexAttributes.Builder)AmexAttributes.builder().applyMutation(amex)).build());
        }

        public Builder visa(VisaAttributes var1);

        default public Builder visa(Consumer<VisaAttributes.Builder> visa) {
            return this.visa((VisaAttributes)((VisaAttributes.Builder)VisaAttributes.builder().applyMutation(visa)).build());
        }

        public Builder emv2000(Emv2000Attributes var1);

        default public Builder emv2000(Consumer<Emv2000Attributes.Builder> emv2000) {
            return this.emv2000((Emv2000Attributes)((Emv2000Attributes.Builder)Emv2000Attributes.builder().applyMutation(emv2000)).build());
        }

        public Builder mastercard(MasterCardAttributes var1);

        default public Builder mastercard(Consumer<MasterCardAttributes.Builder> mastercard) {
            return this.mastercard((MasterCardAttributes)((MasterCardAttributes.Builder)MasterCardAttributes.builder().applyMutation(mastercard)).build());
        }
    }
}

