/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.DerivationMethodAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForEmvPinChange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateMacEmvPinChangeRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, GenerateMacEmvPinChangeRequest> {
    private static final SdkField<String> NEW_PIN_PEK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewPinPekIdentifier").getter(GenerateMacEmvPinChangeRequest.getter(GenerateMacEmvPinChangeRequest::newPinPekIdentifier)).setter(GenerateMacEmvPinChangeRequest.setter(Builder::newPinPekIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPinPekIdentifier").build()}).build();
    private static final SdkField<String> NEW_ENCRYPTED_PIN_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewEncryptedPinBlock").getter(GenerateMacEmvPinChangeRequest.getter(GenerateMacEmvPinChangeRequest::newEncryptedPinBlock)).setter(GenerateMacEmvPinChangeRequest.setter(Builder::newEncryptedPinBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewEncryptedPinBlock").build()}).build();
    private static final SdkField<String> PIN_BLOCK_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinBlockFormat").getter(GenerateMacEmvPinChangeRequest.getter(GenerateMacEmvPinChangeRequest::pinBlockFormatAsString)).setter(GenerateMacEmvPinChangeRequest.setter(Builder::pinBlockFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockFormat").build()}).build();
    private static final SdkField<String> SECURE_MESSAGING_INTEGRITY_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecureMessagingIntegrityKeyIdentifier").getter(GenerateMacEmvPinChangeRequest.getter(GenerateMacEmvPinChangeRequest::secureMessagingIntegrityKeyIdentifier)).setter(GenerateMacEmvPinChangeRequest.setter(Builder::secureMessagingIntegrityKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecureMessagingIntegrityKeyIdentifier").build()}).build();
    private static final SdkField<String> SECURE_MESSAGING_CONFIDENTIALITY_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecureMessagingConfidentialityKeyIdentifier").getter(GenerateMacEmvPinChangeRequest.getter(GenerateMacEmvPinChangeRequest::secureMessagingConfidentialityKeyIdentifier)).setter(GenerateMacEmvPinChangeRequest.setter(Builder::secureMessagingConfidentialityKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecureMessagingConfidentialityKeyIdentifier").build()}).build();
    private static final SdkField<String> MESSAGE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageData").getter(GenerateMacEmvPinChangeRequest.getter(GenerateMacEmvPinChangeRequest::messageData)).setter(GenerateMacEmvPinChangeRequest.setter(Builder::messageData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageData").build()}).build();
    private static final SdkField<DerivationMethodAttributes> DERIVATION_METHOD_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DerivationMethodAttributes").getter(GenerateMacEmvPinChangeRequest.getter(GenerateMacEmvPinChangeRequest::derivationMethodAttributes)).setter(GenerateMacEmvPinChangeRequest.setter(Builder::derivationMethodAttributes)).constructor(DerivationMethodAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DerivationMethodAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_PIN_PEK_IDENTIFIER_FIELD, NEW_ENCRYPTED_PIN_BLOCK_FIELD, PIN_BLOCK_FORMAT_FIELD, SECURE_MESSAGING_INTEGRITY_KEY_IDENTIFIER_FIELD, SECURE_MESSAGING_CONFIDENTIALITY_KEY_IDENTIFIER_FIELD, MESSAGE_DATA_FIELD, DERIVATION_METHOD_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NewPinPekIdentifier", NEW_PIN_PEK_IDENTIFIER_FIELD);
            this.put("NewEncryptedPinBlock", NEW_ENCRYPTED_PIN_BLOCK_FIELD);
            this.put("PinBlockFormat", PIN_BLOCK_FORMAT_FIELD);
            this.put("SecureMessagingIntegrityKeyIdentifier", SECURE_MESSAGING_INTEGRITY_KEY_IDENTIFIER_FIELD);
            this.put("SecureMessagingConfidentialityKeyIdentifier", SECURE_MESSAGING_CONFIDENTIALITY_KEY_IDENTIFIER_FIELD);
            this.put("MessageData", MESSAGE_DATA_FIELD);
            this.put("DerivationMethodAttributes", DERIVATION_METHOD_ATTRIBUTES_FIELD);
        }
    });
    private final String newPinPekIdentifier;
    private final String newEncryptedPinBlock;
    private final String pinBlockFormat;
    private final String secureMessagingIntegrityKeyIdentifier;
    private final String secureMessagingConfidentialityKeyIdentifier;
    private final String messageData;
    private final DerivationMethodAttributes derivationMethodAttributes;

    private GenerateMacEmvPinChangeRequest(BuilderImpl builder) {
        super(builder);
        this.newPinPekIdentifier = builder.newPinPekIdentifier;
        this.newEncryptedPinBlock = builder.newEncryptedPinBlock;
        this.pinBlockFormat = builder.pinBlockFormat;
        this.secureMessagingIntegrityKeyIdentifier = builder.secureMessagingIntegrityKeyIdentifier;
        this.secureMessagingConfidentialityKeyIdentifier = builder.secureMessagingConfidentialityKeyIdentifier;
        this.messageData = builder.messageData;
        this.derivationMethodAttributes = builder.derivationMethodAttributes;
    }

    public final String newPinPekIdentifier() {
        return this.newPinPekIdentifier;
    }

    public final String newEncryptedPinBlock() {
        return this.newEncryptedPinBlock;
    }

    public final PinBlockFormatForEmvPinChange pinBlockFormat() {
        return PinBlockFormatForEmvPinChange.fromValue(this.pinBlockFormat);
    }

    public final String pinBlockFormatAsString() {
        return this.pinBlockFormat;
    }

    public final String secureMessagingIntegrityKeyIdentifier() {
        return this.secureMessagingIntegrityKeyIdentifier;
    }

    public final String secureMessagingConfidentialityKeyIdentifier() {
        return this.secureMessagingConfidentialityKeyIdentifier;
    }

    public final String messageData() {
        return this.messageData;
    }

    public final DerivationMethodAttributes derivationMethodAttributes() {
        return this.derivationMethodAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.newPinPekIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.newEncryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secureMessagingIntegrityKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.secureMessagingConfidentialityKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageData());
        hashCode = 31 * hashCode + Objects.hashCode(this.derivationMethodAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMacEmvPinChangeRequest)) {
            return false;
        }
        GenerateMacEmvPinChangeRequest other = (GenerateMacEmvPinChangeRequest)((Object)obj);
        return Objects.equals(this.newPinPekIdentifier(), other.newPinPekIdentifier()) && Objects.equals(this.newEncryptedPinBlock(), other.newEncryptedPinBlock()) && Objects.equals(this.pinBlockFormatAsString(), other.pinBlockFormatAsString()) && Objects.equals(this.secureMessagingIntegrityKeyIdentifier(), other.secureMessagingIntegrityKeyIdentifier()) && Objects.equals(this.secureMessagingConfidentialityKeyIdentifier(), other.secureMessagingConfidentialityKeyIdentifier()) && Objects.equals(this.messageData(), other.messageData()) && Objects.equals(this.derivationMethodAttributes(), other.derivationMethodAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateMacEmvPinChangeRequest").add("NewPinPekIdentifier", (Object)this.newPinPekIdentifier()).add("NewEncryptedPinBlock", (Object)(this.newEncryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")).add("PinBlockFormat", (Object)this.pinBlockFormatAsString()).add("SecureMessagingIntegrityKeyIdentifier", (Object)this.secureMessagingIntegrityKeyIdentifier()).add("SecureMessagingConfidentialityKeyIdentifier", (Object)this.secureMessagingConfidentialityKeyIdentifier()).add("MessageData", (Object)(this.messageData() == null ? null : "*** Sensitive Data Redacted ***")).add("DerivationMethodAttributes", (Object)this.derivationMethodAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NewPinPekIdentifier": {
                return Optional.ofNullable(clazz.cast(this.newPinPekIdentifier()));
            }
            case "NewEncryptedPinBlock": {
                return Optional.ofNullable(clazz.cast(this.newEncryptedPinBlock()));
            }
            case "PinBlockFormat": {
                return Optional.ofNullable(clazz.cast(this.pinBlockFormatAsString()));
            }
            case "SecureMessagingIntegrityKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.secureMessagingIntegrityKeyIdentifier()));
            }
            case "SecureMessagingConfidentialityKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.secureMessagingConfidentialityKeyIdentifier()));
            }
            case "MessageData": {
                return Optional.ofNullable(clazz.cast(this.messageData()));
            }
            case "DerivationMethodAttributes": {
                return Optional.ofNullable(clazz.cast(this.derivationMethodAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GenerateMacEmvPinChangeRequest, T> g) {
        return obj -> g.apply((GenerateMacEmvPinChangeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String newPinPekIdentifier;
        private String newEncryptedPinBlock;
        private String pinBlockFormat;
        private String secureMessagingIntegrityKeyIdentifier;
        private String secureMessagingConfidentialityKeyIdentifier;
        private String messageData;
        private DerivationMethodAttributes derivationMethodAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMacEmvPinChangeRequest model) {
            super(model);
            this.newPinPekIdentifier(model.newPinPekIdentifier);
            this.newEncryptedPinBlock(model.newEncryptedPinBlock);
            this.pinBlockFormat(model.pinBlockFormat);
            this.secureMessagingIntegrityKeyIdentifier(model.secureMessagingIntegrityKeyIdentifier);
            this.secureMessagingConfidentialityKeyIdentifier(model.secureMessagingConfidentialityKeyIdentifier);
            this.messageData(model.messageData);
            this.derivationMethodAttributes(model.derivationMethodAttributes);
        }

        public final String getNewPinPekIdentifier() {
            return this.newPinPekIdentifier;
        }

        public final void setNewPinPekIdentifier(String newPinPekIdentifier) {
            this.newPinPekIdentifier = newPinPekIdentifier;
        }

        @Override
        public final Builder newPinPekIdentifier(String newPinPekIdentifier) {
            this.newPinPekIdentifier = newPinPekIdentifier;
            return this;
        }

        public final String getNewEncryptedPinBlock() {
            return this.newEncryptedPinBlock;
        }

        public final void setNewEncryptedPinBlock(String newEncryptedPinBlock) {
            this.newEncryptedPinBlock = newEncryptedPinBlock;
        }

        @Override
        public final Builder newEncryptedPinBlock(String newEncryptedPinBlock) {
            this.newEncryptedPinBlock = newEncryptedPinBlock;
            return this;
        }

        public final String getPinBlockFormat() {
            return this.pinBlockFormat;
        }

        public final void setPinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
        }

        @Override
        public final Builder pinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
            return this;
        }

        @Override
        public final Builder pinBlockFormat(PinBlockFormatForEmvPinChange pinBlockFormat) {
            this.pinBlockFormat(pinBlockFormat == null ? null : pinBlockFormat.toString());
            return this;
        }

        public final String getSecureMessagingIntegrityKeyIdentifier() {
            return this.secureMessagingIntegrityKeyIdentifier;
        }

        public final void setSecureMessagingIntegrityKeyIdentifier(String secureMessagingIntegrityKeyIdentifier) {
            this.secureMessagingIntegrityKeyIdentifier = secureMessagingIntegrityKeyIdentifier;
        }

        @Override
        public final Builder secureMessagingIntegrityKeyIdentifier(String secureMessagingIntegrityKeyIdentifier) {
            this.secureMessagingIntegrityKeyIdentifier = secureMessagingIntegrityKeyIdentifier;
            return this;
        }

        public final String getSecureMessagingConfidentialityKeyIdentifier() {
            return this.secureMessagingConfidentialityKeyIdentifier;
        }

        public final void setSecureMessagingConfidentialityKeyIdentifier(String secureMessagingConfidentialityKeyIdentifier) {
            this.secureMessagingConfidentialityKeyIdentifier = secureMessagingConfidentialityKeyIdentifier;
        }

        @Override
        public final Builder secureMessagingConfidentialityKeyIdentifier(String secureMessagingConfidentialityKeyIdentifier) {
            this.secureMessagingConfidentialityKeyIdentifier = secureMessagingConfidentialityKeyIdentifier;
            return this;
        }

        public final String getMessageData() {
            return this.messageData;
        }

        public final void setMessageData(String messageData) {
            this.messageData = messageData;
        }

        @Override
        public final Builder messageData(String messageData) {
            this.messageData = messageData;
            return this;
        }

        public final DerivationMethodAttributes.Builder getDerivationMethodAttributes() {
            return this.derivationMethodAttributes != null ? this.derivationMethodAttributes.toBuilder() : null;
        }

        public final void setDerivationMethodAttributes(DerivationMethodAttributes.BuilderImpl derivationMethodAttributes) {
            this.derivationMethodAttributes = derivationMethodAttributes != null ? derivationMethodAttributes.build() : null;
        }

        @Override
        public final Builder derivationMethodAttributes(DerivationMethodAttributes derivationMethodAttributes) {
            this.derivationMethodAttributes = derivationMethodAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMacEmvPinChangeRequest build() {
            return new GenerateMacEmvPinChangeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateMacEmvPinChangeRequest> {
        public Builder newPinPekIdentifier(String var1);

        public Builder newEncryptedPinBlock(String var1);

        public Builder pinBlockFormat(String var1);

        public Builder pinBlockFormat(PinBlockFormatForEmvPinChange var1);

        public Builder secureMessagingIntegrityKeyIdentifier(String var1);

        public Builder secureMessagingConfidentialityKeyIdentifier(String var1);

        public Builder messageData(String var1);

        public Builder derivationMethodAttributes(DerivationMethodAttributes var1);

        default public Builder derivationMethodAttributes(Consumer<DerivationMethodAttributes.Builder> derivationMethodAttributes) {
            return this.derivationMethodAttributes((DerivationMethodAttributes)((DerivationMethodAttributes.Builder)DerivationMethodAttributes.builder().applyMutation(derivationMethodAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

