/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.CardGenerationAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateCardValidationDataRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, GenerateCardValidationDataRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(GenerateCardValidationDataRequest.getter(GenerateCardValidationDataRequest::keyIdentifier)).setter(GenerateCardValidationDataRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(GenerateCardValidationDataRequest.getter(GenerateCardValidationDataRequest::primaryAccountNumber)).setter(GenerateCardValidationDataRequest.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<CardGenerationAttributes> GENERATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GenerationAttributes").getter(GenerateCardValidationDataRequest.getter(GenerateCardValidationDataRequest::generationAttributes)).setter(GenerateCardValidationDataRequest.setter(Builder::generationAttributes)).constructor(CardGenerationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationAttributes").build()}).build();
    private static final SdkField<Integer> VALIDATION_DATA_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ValidationDataLength").getter(GenerateCardValidationDataRequest.getter(GenerateCardValidationDataRequest::validationDataLength)).setter(GenerateCardValidationDataRequest.setter(Builder::validationDataLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationDataLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, GENERATION_ATTRIBUTES_FIELD, VALIDATION_DATA_LENGTH_FIELD));
    private final String keyIdentifier;
    private final String primaryAccountNumber;
    private final CardGenerationAttributes generationAttributes;
    private final Integer validationDataLength;

    private GenerateCardValidationDataRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.generationAttributes = builder.generationAttributes;
        this.validationDataLength = builder.validationDataLength;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final CardGenerationAttributes generationAttributes() {
        return this.generationAttributes;
    }

    public final Integer validationDataLength() {
        return this.validationDataLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDataLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateCardValidationDataRequest)) {
            return false;
        }
        GenerateCardValidationDataRequest other = (GenerateCardValidationDataRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.generationAttributes(), other.generationAttributes()) && Objects.equals(this.validationDataLength(), other.validationDataLength());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateCardValidationDataRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("GenerationAttributes", (Object)this.generationAttributes()).add("ValidationDataLength", (Object)this.validationDataLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "GenerationAttributes": {
                return Optional.ofNullable(clazz.cast(this.generationAttributes()));
            }
            case "ValidationDataLength": {
                return Optional.ofNullable(clazz.cast(this.validationDataLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateCardValidationDataRequest, T> g) {
        return obj -> g.apply((GenerateCardValidationDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private String primaryAccountNumber;
        private CardGenerationAttributes generationAttributes;
        private Integer validationDataLength;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateCardValidationDataRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.generationAttributes(model.generationAttributes);
            this.validationDataLength(model.validationDataLength);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final CardGenerationAttributes.Builder getGenerationAttributes() {
            return this.generationAttributes != null ? this.generationAttributes.toBuilder() : null;
        }

        public final void setGenerationAttributes(CardGenerationAttributes.BuilderImpl generationAttributes) {
            this.generationAttributes = generationAttributes != null ? generationAttributes.build() : null;
        }

        @Override
        public final Builder generationAttributes(CardGenerationAttributes generationAttributes) {
            this.generationAttributes = generationAttributes;
            return this;
        }

        public final Integer getValidationDataLength() {
            return this.validationDataLength;
        }

        public final void setValidationDataLength(Integer validationDataLength) {
            this.validationDataLength = validationDataLength;
        }

        @Override
        public final Builder validationDataLength(Integer validationDataLength) {
            this.validationDataLength = validationDataLength;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateCardValidationDataRequest build() {
            return new GenerateCardValidationDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateCardValidationDataRequest> {
        public Builder keyIdentifier(String var1);

        public Builder primaryAccountNumber(String var1);

        public Builder generationAttributes(CardGenerationAttributes var1);

        default public Builder generationAttributes(Consumer<CardGenerationAttributes.Builder> generationAttributes) {
            return this.generationAttributes((CardGenerationAttributes)((CardGenerationAttributes.Builder)CardGenerationAttributes.builder().applyMutation(generationAttributes)).build());
        }

        public Builder validationDataLength(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

