/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionDecryptionAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.WrappedKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecryptDataRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, DecryptDataRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(DecryptDataRequest.getter(DecryptDataRequest::keyIdentifier)).setter(DecryptDataRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<String> CIPHER_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CipherText").getter(DecryptDataRequest.getter(DecryptDataRequest::cipherText)).setter(DecryptDataRequest.setter(Builder::cipherText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CipherText").build()}).build();
    private static final SdkField<EncryptionDecryptionAttributes> DECRYPTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DecryptionAttributes").getter(DecryptDataRequest.getter(DecryptDataRequest::decryptionAttributes)).setter(DecryptDataRequest.setter(Builder::decryptionAttributes)).constructor(EncryptionDecryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecryptionAttributes").build()}).build();
    private static final SdkField<WrappedKey> WRAPPED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WrappedKey").getter(DecryptDataRequest.getter(DecryptDataRequest::wrappedKey)).setter(DecryptDataRequest.setter(Builder::wrappedKey)).constructor(WrappedKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, CIPHER_TEXT_FIELD, DECRYPTION_ATTRIBUTES_FIELD, WRAPPED_KEY_FIELD));
    private final String keyIdentifier;
    private final String cipherText;
    private final EncryptionDecryptionAttributes decryptionAttributes;
    private final WrappedKey wrappedKey;

    private DecryptDataRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.cipherText = builder.cipherText;
        this.decryptionAttributes = builder.decryptionAttributes;
        this.wrappedKey = builder.wrappedKey;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final String cipherText() {
        return this.cipherText;
    }

    public final EncryptionDecryptionAttributes decryptionAttributes() {
        return this.decryptionAttributes;
    }

    public final WrappedKey wrappedKey() {
        return this.wrappedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.cipherText());
        hashCode = 31 * hashCode + Objects.hashCode(this.decryptionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptDataRequest)) {
            return false;
        }
        DecryptDataRequest other = (DecryptDataRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.cipherText(), other.cipherText()) && Objects.equals(this.decryptionAttributes(), other.decryptionAttributes()) && Objects.equals(this.wrappedKey(), other.wrappedKey());
    }

    public final String toString() {
        return ToString.builder((String)"DecryptDataRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("CipherText", (Object)(this.cipherText() == null ? null : "*** Sensitive Data Redacted ***")).add("DecryptionAttributes", (Object)this.decryptionAttributes()).add("WrappedKey", (Object)this.wrappedKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "CipherText": {
                return Optional.ofNullable(clazz.cast(this.cipherText()));
            }
            case "DecryptionAttributes": {
                return Optional.ofNullable(clazz.cast(this.decryptionAttributes()));
            }
            case "WrappedKey": {
                return Optional.ofNullable(clazz.cast(this.wrappedKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecryptDataRequest, T> g) {
        return obj -> g.apply((DecryptDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private String cipherText;
        private EncryptionDecryptionAttributes decryptionAttributes;
        private WrappedKey wrappedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptDataRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.cipherText(model.cipherText);
            this.decryptionAttributes(model.decryptionAttributes);
            this.wrappedKey(model.wrappedKey);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getCipherText() {
            return this.cipherText;
        }

        public final void setCipherText(String cipherText) {
            this.cipherText = cipherText;
        }

        @Override
        public final Builder cipherText(String cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        public final EncryptionDecryptionAttributes.Builder getDecryptionAttributes() {
            return this.decryptionAttributes != null ? this.decryptionAttributes.toBuilder() : null;
        }

        public final void setDecryptionAttributes(EncryptionDecryptionAttributes.BuilderImpl decryptionAttributes) {
            this.decryptionAttributes = decryptionAttributes != null ? decryptionAttributes.build() : null;
        }

        @Override
        public final Builder decryptionAttributes(EncryptionDecryptionAttributes decryptionAttributes) {
            this.decryptionAttributes = decryptionAttributes;
            return this;
        }

        public final WrappedKey.Builder getWrappedKey() {
            return this.wrappedKey != null ? this.wrappedKey.toBuilder() : null;
        }

        public final void setWrappedKey(WrappedKey.BuilderImpl wrappedKey) {
            this.wrappedKey = wrappedKey != null ? wrappedKey.build() : null;
        }

        @Override
        public final Builder wrappedKey(WrappedKey wrappedKey) {
            this.wrappedKey = wrappedKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecryptDataRequest build() {
            return new DecryptDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DecryptDataRequest> {
        public Builder keyIdentifier(String var1);

        public Builder cipherText(String var1);

        public Builder decryptionAttributes(EncryptionDecryptionAttributes var1);

        default public Builder decryptionAttributes(Consumer<EncryptionDecryptionAttributes.Builder> decryptionAttributes) {
            return this.decryptionAttributes((EncryptionDecryptionAttributes)((EncryptionDecryptionAttributes.Builder)EncryptionDecryptionAttributes.builder().applyMutation(decryptionAttributes)).build());
        }

        public Builder wrappedKey(WrappedKey var1);

        default public Builder wrappedKey(Consumer<WrappedKey.Builder> wrappedKey) {
            return this.wrappedKey((WrappedKey)((WrappedKey.Builder)WrappedKey.builder().applyMutation(wrappedKey)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

