/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyCardValidationDataRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, VerifyCardValidationDataRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(VerifyCardValidationDataRequest.getter(VerifyCardValidationDataRequest::keyIdentifier)).setter(VerifyCardValidationDataRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(VerifyCardValidationDataRequest.getter(VerifyCardValidationDataRequest::primaryAccountNumber)).setter(VerifyCardValidationDataRequest.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<CardVerificationAttributes> VERIFICATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerificationAttributes").getter(VerifyCardValidationDataRequest.getter(VerifyCardValidationDataRequest::verificationAttributes)).setter(VerifyCardValidationDataRequest.setter(Builder::verificationAttributes)).constructor(CardVerificationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationAttributes").build()}).build();
    private static final SdkField<String> VALIDATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationData").getter(VerifyCardValidationDataRequest.getter(VerifyCardValidationDataRequest::validationData)).setter(VerifyCardValidationDataRequest.setter(Builder::validationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, VERIFICATION_ATTRIBUTES_FIELD, VALIDATION_DATA_FIELD));
    private final String keyIdentifier;
    private final String primaryAccountNumber;
    private final CardVerificationAttributes verificationAttributes;
    private final String validationData;

    private VerifyCardValidationDataRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.verificationAttributes = builder.verificationAttributes;
        this.validationData = builder.validationData;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final CardVerificationAttributes verificationAttributes() {
        return this.verificationAttributes;
    }

    public final String validationData() {
        return this.validationData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyCardValidationDataRequest)) {
            return false;
        }
        VerifyCardValidationDataRequest other = (VerifyCardValidationDataRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.verificationAttributes(), other.verificationAttributes()) && Objects.equals(this.validationData(), other.validationData());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyCardValidationDataRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("VerificationAttributes", (Object)this.verificationAttributes()).add("ValidationData", (Object)this.validationData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "VerificationAttributes": {
                return Optional.ofNullable(clazz.cast(this.verificationAttributes()));
            }
            case "ValidationData": {
                return Optional.ofNullable(clazz.cast(this.validationData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyCardValidationDataRequest, T> g) {
        return obj -> g.apply((VerifyCardValidationDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private String primaryAccountNumber;
        private CardVerificationAttributes verificationAttributes;
        private String validationData;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyCardValidationDataRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.verificationAttributes(model.verificationAttributes);
            this.validationData(model.validationData);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final CardVerificationAttributes.Builder getVerificationAttributes() {
            return this.verificationAttributes != null ? this.verificationAttributes.toBuilder() : null;
        }

        public final void setVerificationAttributes(CardVerificationAttributes.BuilderImpl verificationAttributes) {
            this.verificationAttributes = verificationAttributes != null ? verificationAttributes.build() : null;
        }

        @Override
        public final Builder verificationAttributes(CardVerificationAttributes verificationAttributes) {
            this.verificationAttributes = verificationAttributes;
            return this;
        }

        public final String getValidationData() {
            return this.validationData;
        }

        public final void setValidationData(String validationData) {
            this.validationData = validationData;
        }

        @Override
        public final Builder validationData(String validationData) {
            this.validationData = validationData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyCardValidationDataRequest build() {
            return new VerifyCardValidationDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyCardValidationDataRequest> {
        public Builder keyIdentifier(String var1);

        public Builder primaryAccountNumber(String var1);

        public Builder verificationAttributes(CardVerificationAttributes var1);

        default public Builder verificationAttributes(Consumer<CardVerificationAttributes.Builder> verificationAttributes) {
            return this.verificationAttributes((CardVerificationAttributes)((CardVerificationAttributes.Builder)CardVerificationAttributes.builder().applyMutation(verificationAttributes)).build());
        }

        public Builder validationData(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

